/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.IProperty;
import org.w3c.css.sac.LexicalUnit;

public abstract class AbstractProperty
implements IProperty {
    private String name;
    private static final float EX_FACTOR = 0.6f;

    public AbstractProperty(String name) {
        this.name = name;
    }

    public static boolean isInherit(LexicalUnit lu) {
        return lu != null && lu.getLexicalUnitType() == 12;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static boolean isPercentage(LexicalUnit lu) {
        return lu != null && lu.getLexicalUnitType() == 23;
    }

    public static boolean isLength(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        short type = lu.getLexicalUnitType();
        if (type == 13 && lu.getIntegerValue() == 0) {
            return true;
        }
        return type == 19 || type == 42 || type == 15 || type == 16 || type == 18 || type == 20 || type == 22 || type == 17 || type == 21;
    }

    public static int getIntLength(LexicalUnit lu, float fontSize, int ppi) {
        return Math.round(AbstractProperty.getFloatLength(lu, fontSize, ppi));
    }

    public static float getFloatLength(LexicalUnit lu, float fontSize, int ppi) {
        float value = 0.0f;
        switch (lu.getLexicalUnitType()) {
            case 19: {
                value = lu.getFloatValue() * (float)ppi / 2.54f;
                break;
            }
            case 15: {
                value = lu.getFloatValue() * fontSize;
                break;
            }
            case 16: {
                value = lu.getFloatValue() * fontSize * 0.6f;
                break;
            }
            case 18: {
                value = lu.getFloatValue() * (float)ppi;
                break;
            }
            case 13: {
                value = 0.0f;
                break;
            }
            case 20: {
                value = lu.getFloatValue() * (float)ppi / 25.4f;
                break;
            }
            case 22: {
                value = lu.getFloatValue() * (float)ppi / 6.0f;
                break;
            }
            case 17: {
                value = lu.getFloatValue();
                break;
            }
            case 21: {
                value = lu.getFloatValue() * (float)ppi / 72.0f;
            }
        }
        return value;
    }

    public static boolean isNumber(LexicalUnit lu) {
        return lu != null && (lu.getLexicalUnitType() == 13 || lu.getLexicalUnitType() == 14);
    }

    public static float getNumber(LexicalUnit lu) {
        if (lu.getLexicalUnitType() == 13) {
            return lu.getIntegerValue();
        }
        if (lu.getLexicalUnitType() == 14) {
            return lu.getFloatValue();
        }
        throw new RuntimeException("LexicalUnit type " + lu.getLexicalUnitType() + " is not a numeric type.");
    }
}

