/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class BorderStyleProperty
extends AbstractProperty {
    public BorderStyleProperty(String name) {
        super(name);
    }

    public static boolean isBorderStyle(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("none") || s.equalsIgnoreCase("hidden") || s.equalsIgnoreCase("dotted") || s.equalsIgnoreCase("dashed") || s.equalsIgnoreCase("solid") || s.equalsIgnoreCase("double") || s.equalsIgnoreCase("groove") || s.equalsIgnoreCase("ridge") || s.equalsIgnoreCase("inset") || s.equalsIgnoreCase("outset");
        }
        return false;
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (BorderStyleProperty.isBorderStyle(lu)) {
            return lu.getStringValue();
        }
        if (BorderStyleProperty.isInherit(lu) && parentStyles != null) {
            return parentStyles.get(this.getName());
        }
        return "none";
    }
}

