/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class WhiteSpaceProperty
extends AbstractProperty {
    public WhiteSpaceProperty() {
        super("white-space");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (WhiteSpaceProperty.isWhiteSpace(lu)) {
            return lu.getStringValue();
        }
        if (parentStyles != null) {
            return parentStyles.getWhiteSpace();
        }
        return "normal";
    }

    public static boolean isWhiteSpace(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("normal") || s.equalsIgnoreCase("pre") || s.equalsIgnoreCase("nowrap");
        }
        return false;
    }
}

