/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.core.DisplayDevice;
import net.sf.vex.core.Log;
import net.sf.vex.editor.PreferenceChangeHandler;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.editor.config.ConfigLoaderJob;
import net.sf.vex.swt.SwtDisplayDevice;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class VexPlugin
extends AbstractUIPlugin {
    public static final String ID = "net.sf.vex.editor";
    private List<VexEditor> runningEditors = new ArrayList<VexEditor>();
    private static VexPlugin instance;
    private ConfigLoaderJob initJob = new ConfigLoaderJob();

    public VexPlugin() {
        instance = this;
    }

    public static void assertIsDisplayThread() {
        if (Thread.currentThread() != Display.getDefault().getThread()) {
            throw new IllegalStateException("This method must be called from the display thread.");
        }
    }

    public static VexPlugin getInstance() {
        return instance;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public void log(int severity, String message) {
        this.getLog().log((IStatus)new Status(severity, ID, 0, message, null));
    }

    public void log(int severity, String message, Throwable exception) {
        this.getLog().log((IStatus)new Status(severity, ID, 0, message, exception));
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        DisplayDevice.setCurrent((DisplayDevice)new SwtDisplayDevice());
        this.getPluginPreferences().addPropertyChangeListener((Preferences.IPropertyChangeListener)PreferenceChangeHandler.getInstance());
        Log.setWarningOutput((Log.MessageOutput)new Log.MessageOutput(){

            public void log(String message) {
                VexPlugin.getInstance().log(2, message);
            }

            public void log(String message, Throwable cause) {
                VexPlugin.getInstance().log(2, message, cause);
            }
        });
        Log.setErrorOutput((Log.MessageOutput)new Log.MessageOutput(){

            public void log(String message) {
                VexPlugin.getInstance().log(4, message);
            }

            public void log(String message, Throwable cause) {
                VexPlugin.getInstance().log(4, message, cause);
            }
        });
        this.initJob.schedule();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public List<VexEditor> getRunningEditors() {
        return new ArrayList<VexEditor>(this.runningEditors);
    }

    void registerEditor(VexEditor e) {
        this.runningEditors.add(e);
    }

    void unregisterEditor(VexEditor e) {
        this.runningEditors.remove((Object)e);
    }
}

