/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.conf.client;

import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.LocalProxySelector;
import info.textgrid.lab.conf.client.Messages;
import info.textgrid.middleware.confclient.ConfservClient;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.ProxySelector;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import org.codehaus.jettison.json.JSONException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;

public class ConfClient {
    public static String EXPECTED_API_VERSION = "2011-02-15";
    public static final String PREF_ENDPOINT = "endpoint";
    public static final String DEFAULT_ENDPOINT = "https://textgridlab.org/1.0/confserv";
    public static final String REAL_DEFAULT_ENDPOINT = "https://textgridlab.org/1.0/confserv";
    private static ConfClient confClient;
    protected static final String ENV_ENDPOINT_VAR = "TEXTGRIDLAB_CONFSERV";
    private String endpoint = "";
    private HashMap<String, String> confVars;
    private ConfservClient confservClient;
    private static ListenerList apiChangedListeners;

    static {
        apiChangedListeners = new ListenerList();
    }

    private ConfClient() throws OfflineException {
        IPreferenceStore preferenceStore = ConfPlugin.getDefault().getPreferenceStore();
        preferenceStore.setDefault(PREF_ENDPOINT, "https://textgridlab.org/1.0/confserv");
        ConfClient.setProxySelector();
        this.setEndpoint(ConfClient.computePreferredEndpoint());
    }

    public static String computePreferredEndpoint() {
        String endpoint;
        String env_endpoint = System.getenv().get(ENV_ENDPOINT_VAR);
        if (env_endpoint != null) {
            endpoint = env_endpoint;
        } else {
            endpoint = ConfPlugin.getDefault().getPreferenceStore().getString(PREF_ENDPOINT);
            if (endpoint == null || "".equals(endpoint)) {
                endpoint = "https://textgridlab.org/1.0/confserv";
            }
        }
        return endpoint;
    }

    private void setEndpoint(String endpoint) throws OfflineException {
        if (this.endpoint == null || !this.endpoint.equals(endpoint)) {
            this.endpoint = endpoint;
            this.confservClient = new ConfservClient(endpoint);
            this.refresh();
        }
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public static ConfClient getInstance() throws OfflineException {
        if (confClient == null) {
            confClient = new ConfClient();
        }
        return confClient;
    }

    public String getValue(String key) throws OfflineException {
        if (this.confVars == null) {
            if (OnlineStatus.isOnline()) {
                this.refresh();
            } else {
                throw new OfflineException(Messages.ConfClient_NoConfigWhileOffline, null);
            }
        }
        return this.confVars.get(key);
    }

    @Deprecated
    public String getValue(String key, Boolean force) throws OfflineException {
        return this.getValue(key);
    }

    public void refresh() throws OfflineException {
        IRunnableWithProgress fetchJob = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    monitor.beginTask(Messages.ConfClient_FetchingConfig, -1);
                    ConfClient.this.confVars = ConfClient.this.confservClient.getAll();
                    monitor.done();
                }
                catch (IOException e) {
                    throw new InvocationTargetException(new OfflineException(Messages.ConfClient_FailedToGetValues, e));
                }
                catch (JSONException e) {
                    throw new InvocationTargetException(new OfflineException(Messages.ConfClient_PsrseError, e));
                }
                catch (XMLStreamException e) {
                    throw new InvocationTargetException(new OfflineException(Messages.ConfClient_ParseError, e));
                }
                ConfPlugin.log(1, null, "TextGrid Configuration: {0}", ConfClient.this.confVars);
            }
        };
        try {
            if (Display.getCurrent() == null) {
                fetchJob.run(null);
            } else {
                PlatformUI.getWorkbench().getProgressService().run(false, false, fetchJob);
            }
            this.checkApiChanged();
        }
        catch (InvocationTargetException e) {
            if (e.getCause() != null && e.getCause() instanceof OfflineException) {
                throw (OfflineException)e.getCause();
            }
        }
        catch (InterruptedException e) {
            ConfPlugin.log(8, e, Messages.ConfClient_FetchJobInterrupted, new Object[0]);
        }
    }

    private void checkApiChanged() {
        if (this.confVars.get("last-api-change") == null) {
            return;
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date confServApiDate = new Date();
        Date labApiDate = new Date();
        try {
            confServApiDate = formatter.parse(this.confVars.get("last-api-change"));
        }
        catch (ParseException e) {
            ConfPlugin.log(4, e, String.valueOf(Messages.ConfClient_ErrorParsingApiChange) + this.confVars.get("last-api-change"), new Object[0]);
        }
        try {
            labApiDate = formatter.parse(EXPECTED_API_VERSION);
        }
        catch (ParseException e) {
            ConfPlugin.log(4, e, String.valueOf(Messages.ConfClient_ErrorParsingApiVersionX) + EXPECTED_API_VERSION, new Object[0]);
        }
        if (labApiDate.compareTo(confServApiDate) < 0) {
            this.notifyApiChangedListeners(new Event());
        }
    }

    public static void addApiChangedListener(Listener l) {
        apiChangedListeners.add((Object)l);
    }

    public static void removeApiChangedListener(Listener l) {
        apiChangedListeners.remove((Object)l);
    }

    protected synchronized void notifyApiChangedListeners(Event event) {
        Object[] listeners = apiChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((Listener)listeners[i]).handleEvent(event);
            ++i;
        }
    }

    public static void setProxySelector() {
        if (ConfPlugin.getDefault().getPreferenceStore().getBoolean("proxy_connection")) {
            LocalProxySelector ps = new LocalProxySelector(ProxySelector.getDefault());
            ProxySelector.setDefault(ps);
        } else {
            ProxySelector.setDefault(null);
        }
    }
}

