/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.log;

import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.log.Activator;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class logsession {
    private int logLevel = 0;
    private String sessionId;
    private static logsession session;

    public static logsession getInstance() {
        if (session == null) {
            session = new logsession();
        }
        return session;
    }

    public String getloginfo() {
        if (this.logLevel > 0) {
            try {
                return String.valueOf(this.getLogEndpoint()) + " " + this.sessionId + " " + this.logLevel;
            }
            catch (OfflineException e) {
                OnlineStatus.netAccessFailed((String)"logsession: Could not fetch Log-Service-Endpoint from Confserver!", (Throwable)e);
            }
        }
        return "";
    }

    public String getLogEndpoint() throws OfflineException {
        return ConfClient.getInstance().getValue("logservice");
    }

    public String getLogEndpointNoThrow() {
        try {
            return ConfClient.getInstance().getValue("logservice");
        }
        catch (OfflineException e) {
            OnlineStatus.netAccessFailed((String)"logsession: Could not fetch Log-Service-Endpoint from Confserver!", (Throwable)e);
            return "";
        }
    }

    public void setLogLevel(int logLevel, String logSessionId) {
        this.logLevel = logLevel;
        this.sessionId = logSessionId;
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.printf("Log view configuration changed: log level = %d, log session id = \"%s\", log service endpoint = \"%s\"", logLevel, logSessionId, this.getLogEndpointNoThrow());
        Status status = new Status(1, "info.textgrid.lab.log", stringWriter.toString());
        Activator.getDefault().getLog().log((IStatus)status);
    }
}

