/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core;

import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.lab.ui.core.Activator;
import info.textgrid.lab.ui.core.IOpenHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class OpenHandlerContribution {
    private static final String EXTENSION_POINT_OPEN = "info.textgrid.lab.ui.core.openObject";
    private final TGContentType contentType;
    private final String perspective;
    private final String editor;
    private final String label;
    private final String description;
    private final IOpenHandler handler;
    private final int priority;
    public static final Comparator<OpenHandlerContribution> PRIORITY_COMPARATOR = new Comparator<OpenHandlerContribution>(){

        @Override
        public int compare(OpenHandlerContribution o1, OpenHandlerContribution o2) {
            return o2.getPriority() - o1.getPriority();
        }
    };

    private OpenHandlerContribution(IConfigurationElement openHandlerElement, TGContentType contentType) {
        this.contentType = contentType;
        this.perspective = openHandlerElement.getAttribute("perspective");
        this.editor = openHandlerElement.getAttribute("editor");
        this.label = openHandlerElement.getAttribute("label");
        this.description = openHandlerElement.getAttribute("description");
        this.priority = Integer.valueOf(openHandlerElement.getAttribute("priority"));
        IOpenHandler handler = null;
        if (openHandlerElement.getAttribute("handler") != null) {
            try {
                handler = (IOpenHandler)openHandlerElement.createExecutableExtension("handler");
                handler.setContribution(this);
            }
            catch (CoreException e) {
                Activator.handleProblem(2, "Could not instantiate handler for an open contribution", e);
            }
        }
        this.handler = handler;
    }

    public static List<OpenHandlerContribution> contributionsFor(TGContentType contentType) {
        IConfigurationElement[] configurationElementsFor;
        ArrayList<OpenHandlerContribution> result = new ArrayList<OpenHandlerContribution>();
        IConfigurationElement[] iConfigurationElementArray = configurationElementsFor = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_OPEN);
        int n = configurationElementsFor.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement openHandlerElement = iConfigurationElementArray[n2];
            IConfigurationElement[] iConfigurationElementArray2 = openHandlerElement.getChildren("contentType");
            int n3 = iConfigurationElementArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement contentTypeElement = iConfigurationElementArray2[n4];
                if (contentType.getId().equals(contentTypeElement.getAttribute("id"))) {
                    result.add(OpenHandlerContribution.of(openHandlerElement, contentType));
                }
                ++n4;
            }
            ++n2;
        }
        Collections.sort(result, PRIORITY_COMPARATOR);
        return result;
    }

    public static OpenHandlerContribution bestContributionFor(TGContentType contentType) {
        List<OpenHandlerContribution> contributions = OpenHandlerContribution.contributionsFor(contentType);
        if (contributions.size() == 0) {
            return null;
        }
        return contributions.get(0);
    }

    protected static OpenHandlerContribution of(IConfigurationElement openHandlerElement, TGContentType contentType) {
        return new OpenHandlerContribution(openHandlerElement, contentType);
    }

    public TGContentType getContentType() {
        return this.contentType;
    }

    public String getPerspective() {
        return this.perspective;
    }

    public String getEditor() {
        return this.editor;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public IOpenHandler getHandler() {
        return this.handler;
    }

    public int getPriority() {
        return this.priority;
    }
}

