/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.export.filenames;

import com.google.common.base.Optional;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.utils.export.aggregations.IAggregationEntry;
import info.textgrid.utils.export.filenames.IFilenamePolicy;
import java.net.URI;

public class DefaultMetaFilenamePolicy
implements IFilenamePolicy {
    private IFilenamePolicy filenamePolicy;

    public DefaultMetaFilenamePolicy(IFilenamePolicy filenamePolicy) {
        this.filenamePolicy = filenamePolicy;
    }

    @Override
    public String translate(String title) {
        return this.filenamePolicy.translate(title);
    }

    @Override
    public String getFilename(ObjectType object, boolean asParent) {
        return this.filenamePolicy.getFilename(object, asParent).concat(".meta");
    }

    @Override
    public URI getFilename(IAggregationEntry entry, boolean asParent) throws IllegalStateException {
        return this.getFilename(entry);
    }

    @Override
    public URI getFilename(IAggregationEntry entry) throws IllegalStateException {
        return URI.create(this.filenamePolicy.getFilename(entry).toString().concat(".meta"));
    }

    @Override
    public Optional<URI> getBase(IAggregationEntry entry) {
        return this.filenamePolicy.getBase(entry);
    }
}

