/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class FontWeightProperty
extends AbstractProperty {
    private static final int FONT_WEIGHT_NORMAL = 400;
    private static final int FONT_WEIGHT_BOLD = 700;

    public FontWeightProperty() {
        super("font-weight");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        return new Integer(this.calculateInternal(lu, parentStyles, styles));
    }

    public int calculateInternal(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (FontWeightProperty.isFontWeight(lu)) {
            return FontWeightProperty.getFontWeight(lu, parentStyles);
        }
        if (parentStyles != null) {
            return parentStyles.getFontWeight();
        }
        return 400;
    }

    public static boolean isFontWeight(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 13) {
            return true;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("normal") || s.equalsIgnoreCase("bold") || s.equalsIgnoreCase("bolder") || s.equalsIgnoreCase("lighter");
        }
        return false;
    }

    private static int getFontWeight(LexicalUnit lu, Styles parentStyles) {
        if (lu == null) {
            return 400;
        }
        if (lu.getLexicalUnitType() == 13) {
            return lu.getIntegerValue();
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            if (s.equalsIgnoreCase("normal")) {
                return 400;
            }
            if (s.equalsIgnoreCase("bold")) {
                return 700;
            }
            if (s.equalsIgnoreCase("bolder")) {
                if (parentStyles != null) {
                    return parentStyles.getFontWeight() + 151;
                }
                return 700;
            }
            if (s.equalsIgnoreCase("lighter")) {
                if (parentStyles != null) {
                    return parentStyles.getFontWeight() - 151;
                }
                return 400;
            }
            return 400;
        }
        return 400;
    }
}

