/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.core.Drawable;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Insets;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.BinTree;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.BlockElementWidget;
import net.sf.vex.layout.BlockPseudoElementBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.DrawableBox;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LayoutUtils;
import net.sf.vex.layout.LineBox;
import net.sf.vex.layout.ParagraphBox;
import net.sf.vex.layout.StaticTextBox;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BlockElementBox
extends AbstractBlockBox {
    private static boolean bspSpeedup = true;
    static final float BULLET_SPACE = 0.5f;
    private static int boxCount;
    BlockBox beforeMarker;
    protected BlockBox elementWidget;
    private static final int MARKER_MARGIN_TOP = 15;
    private static final int MARKER_MARGIN_BOTTOM = 5;
    private static final int MARKER_MARGIN_LEFT = 3;
    private static final int MARKER_MARGIN_RIGHT = 3;
    static IWorkbenchWindow wind;
    static Display Idisplay;

    static {
        wind = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        Idisplay = wind.getShell().getDisplay();
    }

    public BlockElementBox(LayoutContext context, BlockBox parent, IVexElement element) {
        super(context, parent, element);
    }

    public static int getBoxCount() {
        return boxCount;
    }

    @Override
    public int getEndOffset() {
        return this.getElement().getEndOffset();
    }

    @Override
    public int getStartOffset() {
        return this.getElement().getStartOffset() + 1;
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        boolean paintSelected = context.isElementSelected(this.getElement());
        if (paintSelected) {
            this.paintSelectionFill(context, x, y);
        }
        if (this.beforeMarker != null) {
            this.beforeMarker.paint(context, x + this.beforeMarker.getX(), y + this.beforeMarker.getY(), area);
        }
        super.paint(context, x, y, area);
        if (context.showBlockMarkers()) {
            this.paintMarkerFrame(context, x, y, this.getParent().getWidth());
        }
        if (paintSelected) {
            this.paintSelectionFrame(context, x, y, this.getParent().getWidth());
        }
    }

    @Override
    protected int positionChildren(LayoutContext context) {
        int repaintStart = super.positionChildren(context);
        Styles styles = context.getStyleSheet().getStyles(this.getElement());
        if (this.beforeMarker != null) {
            int x = -this.beforeMarker.getWidth() - Math.round(0.5f * styles.getFontSize());
            int y = this.getFirstLineTop(context);
            LineBox firstLine = this.getFirstLine();
            if (firstLine != null) {
                y += firstLine.getBaseline() - this.beforeMarker.getFirstLine().getBaseline();
            }
            this.beforeMarker.setX(x);
            this.beforeMarker.setY(y);
        }
        if (this.elementWidget != null) {
            int paddingLeft = styles.getPaddingLeft().get(this.getWidth());
            int paddingRight = styles.getPaddingRight().get(this.getWidth());
            int paddingTop = styles.getPaddingTop().get(this.getHeight());
            this.elementWidget.setX(-paddingRight);
            this.elementWidget.setY(-paddingTop);
            this.elementWidget.setWidth(this.getWidth() + paddingLeft + paddingRight);
        }
        return repaintStart;
    }

    public String toString() {
        return "BlockElementBox: <" + this.getElement().getName() + ">" + "(" + this.getStartOffset() + ", " + this.getEndOffset() + ", " + this.hasContent() + ")" + "[x=" + this.getX() + ",y=" + this.getY() + ",width=" + this.getWidth() + ",height=" + this.getHeight() + "]";
    }

    public static Insets getMarkerInsets(LayoutContext context) {
        if (context.showBlockMarkers()) {
            return new Insets(15, 3, 5, 3);
        }
        return Insets.ZERO_INSETS;
    }

    @Override
    protected List createChildren(LayoutContext context) {
        long start = System.currentTimeMillis();
        IVexElement element = this.getElement();
        int width = this.getWidth();
        context.subTask("Creating children for {0}", element.getName());
        ArrayList<BlockBox> childList = new ArrayList<BlockBox>();
        if (context.showBlockMarkers()) {
            this.elementWidget = new BlockElementWidget(context, this);
            this.elementWidget.setWidth(width);
            childList.add(this.elementWidget);
        }
        if (!context.isCollapsed(this.getElement())) {
            long end;
            Styles styles;
            int dot_pos;
            Styles genStyles;
            StyleSheet ss = context.getStyleSheet();
            ArrayList beforeInlines = null;
            IVexElement genElement = context.getStyleSheet().getBeforeElement(this.getElement());
            if (genElement != null) {
                genStyles = ss.getStyles(genElement);
                if (genStyles.getDisplay().equalsIgnoreCase("inline")) {
                    beforeInlines = new ArrayList();
                    beforeInlines.addAll(LayoutUtils.createGeneratedInlines(context, genElement));
                } else {
                    childList.add(new BlockPseudoElementBox(context, genElement, this, width));
                }
            }
            BlockPseudoElementBox afterBlock = null;
            ArrayList afterInlines = null;
            genElement = context.getStyleSheet().getAfterElement(this.getElement());
            if (genElement != null) {
                genStyles = context.getStyleSheet().getStyles(genElement);
                if (genStyles.getDisplay().equalsIgnoreCase("inline")) {
                    afterInlines = new ArrayList();
                    afterInlines.addAll(LayoutUtils.createGeneratedInlines(context, genElement));
                } else {
                    afterBlock = new BlockPseudoElementBox(context, genElement, this, width);
                }
            }
            ArrayList firstlineInlines = null;
            genElement = context.getStyleSheet().getFirstLineElement(this.getElement());
            if (genElement != null && (genStyles = ss.getStyles(genElement.getParent())).getDisplay().equalsIgnoreCase("block") && genElement.getParent().getName().equals("p")) {
                firstlineInlines = new ArrayList();
                firstlineInlines.addAll(LayoutUtils.createFirstInlines(context, genElement));
            }
            ArrayList firstletterInlines = null;
            genElement = context.getStyleSheet().getFirstLetterElement(this.getElement());
            if (genElement != null && (genStyles = ss.getStyles(genElement.getParent())).getDisplay().equalsIgnoreCase("block") && genElement.getParent().getName().equals("p")) {
                firstletterInlines = new ArrayList();
                firstletterInlines.addAll(LayoutUtils.createFirstInlines(context, genElement));
            }
            if (firstletterInlines == null || firstletterInlines.size() == 0 || firstlineInlines == null || firstlineInlines.size() == 0) {
                int startOffset = element.getStartOffset() + 1;
                int endOffset = element.getEndOffset();
                if (ss.getStyles(element).getDisplay().equalsIgnoreCase("none")) {
                    endOffset = startOffset;
                }
                childList.addAll(this.createBlockBoxes(context, startOffset, endOffset, width, beforeInlines, afterInlines));
                if (afterBlock != null) {
                    childList.add(afterBlock);
                }
            } else if (genElement != null && genElement.getName().equals("first-letter") && genElement.getParent().getName().equals("p")) {
                int end2;
                int st;
                if (element.getChildElements().length <= 0) {
                    st = element.getStartOffset() + 2;
                    end2 = element.getEndOffset();
                    childList.addAll(this.createBlockBoxes(context, st, end2, width, firstletterInlines, null));
                } else {
                    st = element.getChildElements()[0].getStartOffset() + 2;
                    end2 = element.getChildElements()[0].getEndOffset();
                    childList.addAll(this.createBlockBoxes(context, st, end2, width, firstletterInlines, null));
                }
            } else if (genElement != null && genElement.getName().equals("first-line") && genElement.getParent().getName().equals("p") && (dot_pos = element.getText().indexOf(".")) != -1) {
                int st = element.getStartOffset() + dot_pos;
                int end3 = element.getEndOffset();
                childList.addAll(this.createBlockBoxes(context, st, end3, width, firstlineInlines, null));
            }
            if ((styles = context.getStyleSheet().getStyles(this.getElement())).getDisplay().equalsIgnoreCase("list-item") && !styles.getListStyleType().equals("none")) {
                this.createListMarker(context);
            }
            Styles st = context.getStyleSheet().getStyles(this.getElement());
            if (this.getElement().getName().equals("graphic") && !st.getDisplay().equalsIgnoreCase("none") && this.getElement() != null) {
                this.callDrawImage(context, this.getElement(), st);
            }
            if ((end = System.currentTimeMillis()) - start > 10L) {
                System.out.println("BEB.layout for " + this.getElement().getName() + " took " + (end - start) + "ms");
            }
            if (bspSpeedup) {
                ArrayList<BinTree> childBinTree = new ArrayList<BinTree>();
                childBinTree.add(new BinTree(childList, context, this, element));
                return childBinTree;
            }
        }
        return childList;
    }

    private void callDrawImage(LayoutContext context, IVexElement element, Styles styles) {
        String filename = element.getAttribute(styles.getBackgroundImage());
        if (filename != null) {
            InlineBox markerInline = BlockElementBox.DrawImage(element, styles, filename);
            this.beforeMarker = ParagraphBox.create(context, this.getElement(), new InlineBox[]{markerInline}, Integer.MAX_VALUE);
        }
    }

    private static InlineBox DrawImage(IVexElement element, Styles styles, final String filename) {
        float w = styles.getElementWidth();
        float h = styles.getElementHeight();
        final int height = (int)h;
        final int width = (int)w;
        Drawable drawable = new Drawable(){

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, -height, width, height);
            }

            @Override
            public void draw(Graphics g, int x, int y) {
                Image image = new Image((Device)Idisplay, filename);
                g.drawImage(image, g.getClipBounds().getX() + 5, g.getClipBounds().getY() - height, width, height);
            }
        };
        return new DrawableBox(drawable, element);
    }

    private void createListMarker(LayoutContext context) {
        InlineBox markerInline;
        Styles styles = context.getStyleSheet().getStyles(this.getElement());
        String type = styles.getListStyleType();
        if (type.equalsIgnoreCase("none")) {
            return;
        }
        if (type.equalsIgnoreCase("circle")) {
            markerInline = BlockElementBox.createCircleBullet(this.getElement(), styles);
        } else if (type.equalsIgnoreCase("square")) {
            markerInline = BlockElementBox.createSquareBullet(this.getElement(), styles);
        } else if (BlockElementBox.isEnumeratedListStyleType(type)) {
            String item = this.getItemNumberString(type);
            markerInline = new StaticTextBox(context, this.getElement(), String.valueOf(item) + ".");
        } else {
            markerInline = BlockElementBox.createDiscBullet(this.getElement(), styles);
        }
        this.beforeMarker = ParagraphBox.create(context, this.getElement(), new InlineBox[]{markerInline}, Integer.MAX_VALUE);
    }

    private static InlineBox createCircleBullet(IVexElement element, Styles styles) {
        final int size = Math.round(0.5f * styles.getFontSize());
        final int lift = Math.round(0.1f * styles.getFontSize());
        Drawable drawable = new Drawable(){

            @Override
            public void draw(Graphics g, int x, int y) {
                g.setLineStyle(0);
                g.setLineWidth(1);
                g.drawOval(x + 5, y - size - lift, size, size);
            }

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, -size - lift, size, size);
            }
        };
        return new DrawableBox(drawable, element);
    }

    private static InlineBox createDiscBullet(IVexElement element, Styles styles) {
        final int size = Math.round(0.5f * styles.getFontSize());
        final int lift = Math.round(0.1f * styles.getFontSize());
        Drawable drawable = new Drawable(){

            @Override
            public void draw(Graphics g, int x, int y) {
                g.fillOval(x + 5, y - size - lift, size, size);
            }

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, -size - lift, size, size);
            }
        };
        return new DrawableBox(drawable, element);
    }

    private static InlineBox createSquareBullet(IVexElement element, Styles styles) {
        final int size = Math.round(0.5f * styles.getFontSize());
        final int lift = Math.round(0.1f * styles.getFontSize());
        Drawable drawable = new Drawable(){

            @Override
            public void draw(Graphics g, int x, int y) {
                g.setLineStyle(0);
                g.setLineWidth(1);
                g.drawRect(x + 5, y - size - lift, size, size);
            }

            @Override
            public Rectangle getBounds() {
                return new Rectangle(0, -size - lift, size, size);
            }
        };
        return new DrawableBox(drawable, element);
    }

    int getFirstLineTop(LayoutContext context) {
        Styles styles = context.getStyleSheet().getStyles(this.getElement());
        int top = styles.getBorderTopWidth() + styles.getPaddingTop().get(0);
        Box[] children = this.getChildren();
        if (children != null && children.length > 0 && children[0] instanceof BlockElementBox) {
            return top + ((BlockElementBox)children[0]).getFirstLineTop(context);
        }
        return top;
    }

    private int getItemNumber() {
        IVexElement element = this.getElement();
        IVexElement parent = element.getParent();
        if (parent == null) {
            return 1;
        }
        int item = 1;
        IVexElement[] children = parent.getChildElements();
        int i = 0;
        while (i < children.length) {
            if (children[i] == element) {
                return item;
            }
            if (children[i].getName().equals(element.getName())) {
                ++item;
            }
            ++i;
        }
        throw new IllegalStateException();
    }

    private String getItemNumberString(String style) {
        int item = this.getItemNumber();
        if (style.equalsIgnoreCase("decimal-leading-zero")) {
            if (item < 10) {
                return "0" + Integer.toString(item);
            }
            return Integer.toString(item);
        }
        if (style.equalsIgnoreCase("lower-alpha") || style.equalsIgnoreCase("lower-latin")) {
            return this.getAlpha(item);
        }
        if (style.equalsIgnoreCase("lower-roman")) {
            return this.getRoman(item);
        }
        if (style.equalsIgnoreCase("upper-alpha") || style.equalsIgnoreCase("upper-latin")) {
            return this.getAlpha(item).toUpperCase();
        }
        if (style.equalsIgnoreCase("upper-roman")) {
            return this.getRoman(item).toUpperCase();
        }
        return Integer.toString(item);
    }

    private String getAlpha(int n) {
        return String.valueOf("abcdefghijklmnopqrstuvwxyz".charAt((n - 1) % 26));
    }

    private String getRoman(int n) {
        String[] ones = new String[]{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"};
        String[] tens = new String[]{"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"};
        String[] hundreds = new String[]{"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"};
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < n / 1000) {
            sb.append("m");
            ++i;
        }
        sb.append(hundreds[n / 100 % 10]);
        sb.append(tens[n / 10 % 10]);
        sb.append(ones[n % 10]);
        return sb.toString();
    }

    private static boolean isEnumeratedListStyleType(String s) {
        return s.equalsIgnoreCase("armenian") || s.equalsIgnoreCase("cjk-ideographic") || s.equalsIgnoreCase("decimal") || s.equalsIgnoreCase("decimal-leading-zero") || s.equalsIgnoreCase("georgian") || s.equalsIgnoreCase("hebrew") || s.equalsIgnoreCase("hiragana") || s.equalsIgnoreCase("hiragana-iroha") || s.equalsIgnoreCase("katakana") || s.equalsIgnoreCase("katakana-iroha") || s.equalsIgnoreCase("lower-alpha") || s.equalsIgnoreCase("lower-greek") || s.equalsIgnoreCase("lower-latin") || s.equalsIgnoreCase("lower-roman") || s.equalsIgnoreCase("upper-alpha") || s.equalsIgnoreCase("upper-latin") || s.equalsIgnoreCase("upper-roman");
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        Insets markerInsets = BlockElementBox.getMarkerInsets(context);
        Insets ins = super.getInsets(context, containerWidth);
        Styles styles = context.getStyleSheet().getStyles(this.getElement());
        int top = styles.getPaddingTop().get(this.getWidth()) + styles.getBorderTopWidth() + markerInsets.getTop();
        int left = styles.getPaddingLeft().get(this.getWidth()) + styles.getBorderLeftWidth() + styles.getMarginLeft().get(containerWidth) + markerInsets.getLeft();
        int bottom = styles.getPaddingBottom().get(this.getWidth()) + styles.getBorderBottomWidth() + markerInsets.getBottom();
        int right = styles.getPaddingRight().get(this.getWidth()) + styles.getBorderRightWidth() + styles.getMarginRight().get(containerWidth) + markerInsets.getRight();
        return new Insets(ins.getTop() + top, ins.getLeft() + left, ins.getBottom() + bottom, ins.getRight() + right);
    }
}

