/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.swt;

import net.sf.vex.VexToolkitPlugin;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.linked.LinkedElement;
import net.sf.vex.dom.linked.LinkedNode;
import net.sf.vex.dom.linked.LinkedNonElement;
import net.sf.vex.dom.linked.LinkedText;
import net.sf.vex.swt.VexWidget;
import net.sf.vex.widget.IVexWidget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;

public class TextSelectionVex
implements ITextSelection {
    private int startOffset;
    private int length = 0;
    private String text = null;
    private IVexWidget vexWidget;
    private String word = null;
    private IVexNode[] nodes;
    private int sourceStartOffset = -1;
    private int sourceEndOffset = -1;

    public TextSelectionVex(VexWidget vexWidget, int startOffset, int length, String text, IVexNode[] nodes) {
        this.vexWidget = vexWidget;
        this.startOffset = startOffset;
        this.length = length;
        this.text = text;
        this.nodes = nodes;
    }

    public TextSelectionVex(VexWidget vexWidget, int startOffset, IVexNode node) {
        this.vexWidget = vexWidget;
        this.startOffset = startOffset;
        this.length = 0;
        this.nodes = new IVexNode[]{node};
    }

    public TextSelectionVex(IVexWidget vexWidget) {
        this.vexWidget = vexWidget;
        this.startOffset = vexWidget.getSelectionStart();
        if (vexWidget.hasSelection()) {
            this.length = vexWidget.getSelectionEnd() - this.startOffset;
            this.text = vexWidget.getSelectedText();
            this.nodes = vexWidget.getDocument().getNodes(this.startOffset, this.startOffset + this.length);
        } else {
            this.length = 0;
            this.nodes = new IVexNode[]{vexWidget.getCurrentNode()};
        }
    }

    protected void calculateSourcePositions() {
        IDOMNode domNode;
        if (this.nodes == null || this.nodes.length < 1 || !(this.nodes[0] instanceof LinkedNode)) {
            return;
        }
        LinkedNode firstNode = (LinkedNode)this.nodes[0];
        LinkedNode lastNode = (LinkedNode)this.nodes[this.nodes.length - 1];
        int sourceStartCand = ((IndexedRegion)firstNode.getAdapter(IndexedRegion.class)).getStartOffset();
        int sourceEndCand = ((IndexedRegion)lastNode.getAdapter(IndexedRegion.class)).getEndOffset();
        int relStartOffset = 0;
        if (firstNode.getStartOffset() != this.startOffset) {
            relStartOffset = this.startOffset - firstNode.getStartOffset();
            sourceStartCand += relStartOffset;
        }
        if (firstNode instanceof LinkedNonElement) {
            sourceStartCand += ((LinkedNonElement)firstNode).getCorrectionForContentPos();
        } else if (firstNode instanceof LinkedText) {
            sourceStartCand += ((LinkedText)firstNode).getCorrectionForContentPos(relStartOffset);
        } else if (firstNode instanceof LinkedElement && (domNode = (IDOMNode)firstNode.getAdapter(IDOMNode.class)) != null) {
            if (relStartOffset == 1) {
                sourceStartCand += domNode.getFirstStructuredDocumentRegion().getLength() - 1;
            } else if (this.startOffset == firstNode.getEndOffset()) {
                sourceStartCand = domNode.getLastStructuredDocumentRegion().getStartOffset();
            }
        }
        if (this.length == 0) {
            this.sourceEndOffset = sourceStartCand;
        } else {
            int relEndOffset = 0;
            if (lastNode.getEndOffset() != this.startOffset + this.length) {
                sourceEndCand = ((IndexedRegion)lastNode.getAdapter(IndexedRegion.class)).getStartOffset();
                relEndOffset = this.startOffset + this.length - lastNode.getStartOffset();
                sourceEndCand += relEndOffset;
            }
            if (lastNode instanceof LinkedNonElement) {
                sourceEndCand += ((LinkedNonElement)lastNode).getCorrectionForContentPos();
            } else if (lastNode instanceof LinkedText) {
                sourceEndCand += ((LinkedText)lastNode).getCorrectionForContentPos(relEndOffset);
            }
            this.sourceEndOffset = sourceEndCand;
        }
        this.sourceStartOffset = sourceStartCand;
        if (VexToolkitPlugin.isDebugging("net.sf.vex.toolkit/debug/selection")) {
            System.out.println("TextSelectionVex(" + this.startOffset + "+" + this.length + "): source(" + this.sourceStartOffset + ".." + this.sourceEndOffset + ") (" + firstNode + ".." + lastNode + ")");
        }
    }

    public int getSourceStartOffset() {
        if (this.sourceStartOffset == -1) {
            this.calculateSourcePositions();
        }
        return this.sourceStartOffset;
    }

    public int getSourceEndOffset() {
        if (this.length == 0) {
            return this.getSourceStartOffset();
        }
        if (this.sourceEndOffset == -1) {
            this.calculateSourcePositions();
        }
        return this.sourceEndOffset;
    }

    public String getCurrentWord() {
        int left;
        if (this.word != null) {
            return this.word;
        }
        IVexDocument document = this.vexWidget.getDocument();
        int right = left = this.startOffset - 1;
        int length = document.getLength();
        while (right < length && Character.isLetter(document.getCharacterAt(right))) {
            ++right;
        }
        while (left > 0 && Character.isLetter(document.getCharacterAt(left))) {
            --left;
        }
        if (left < right) {
            ++left;
        }
        this.word = document.getRawText(left, right);
        return this.word;
    }

    public int getEndLine() {
        return 0;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.startOffset;
    }

    public int getStartLine() {
        return 0;
    }

    public String getText() {
        return this.text;
    }

    public boolean isEmpty() {
        return this.length < 1;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ": @" + this.startOffset + (this.isEmpty() ? " (empty)" : " " + this.text + " (" + this.length + ")");
    }
}

