/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import info.textgrid.lab.core.swtutils.CommandLinkHandler;
import java.text.MessageFormat;
import net.sf.vex.editor.Messages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;

public class VexLoadWarning
extends Composite {
    private static final String ROOT_ELEMENT_ERROR = Messages.getString("VexLoadWarning.NoRootElement");
    private static final String DUPLICATE_ERROR = Messages.getString("VexLoadWarning.OpenInOtherEditor");
    private Composite noProperStylesheet;
    private Button proceedButton;
    private Label loadingLabel;
    private Label tooLargeLabel;
    private Label errorLabel;

    public VexLoadWarning(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        Label lblWysiwymView = new Label((Composite)this, 0);
        lblWysiwymView.setFont(JFaceResources.getBannerFont());
        lblWysiwymView.setText(Messages.getString("VexLoadWarning.PageTitle"));
        Label introLabel = new Label((Composite)this, 64);
        introLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        introLabel.setText(Messages.getString("VexLoadWarning.PageDescription"));
        this.errorLabel = new Label((Composite)this, 64);
        this.errorLabel.setVisible(false);
        this.errorLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.errorLabel.setText(ROOT_ELEMENT_ERROR);
        this.tooLargeLabel = new Label((Composite)this, 64);
        this.tooLargeLabel.setVisible(false);
        this.tooLargeLabel.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 1, 1));
        this.tooLargeLabel.setText(Messages.getString("VexLoadWarning.SizeWarning"));
        this.noProperStylesheet = new Composite((Composite)this, 0);
        GridLayout gl_noProperStylesheet = new GridLayout(1, false);
        gl_noProperStylesheet.horizontalSpacing = 0;
        this.noProperStylesheet.setLayout((Layout)gl_noProperStylesheet);
        this.noProperStylesheet.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        Label lblYourFileHas = new Label(this.noProperStylesheet, 64);
        lblYourFileHas.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        lblYourFileHas.setText(Messages.getString("VexLoadWarning.NeitherTEINorCSS"));
        CommandLinkHandler commandLinkHandler = new CommandLinkHandler();
        Link stylesheetLink = new Link(this.noProperStylesheet, 0);
        stylesheetLink.setText(Messages.getString("VexLoadWarning.SelectCSS"));
        stylesheetLink.addSelectionListener((SelectionListener)commandLinkHandler);
        Link importLink = new Link(this.noProperStylesheet, 0);
        importLink.setText(Messages.getString("VexLoadWarning.ImportCSS"));
        importLink.addSelectionListener((SelectionListener)commandLinkHandler);
        this.proceedButton = new Button((Composite)this, 0);
        this.proceedButton.setVisible(false);
        this.proceedButton.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        this.proceedButton.setText(Messages.getString("VexLoadWarning.ProceedLabel"));
        this.loadingLabel = new Label((Composite)this, 0);
        this.loadingLabel.setVisible(false);
        this.loadingLabel.setText(Messages.getString("VexLoadWarning.LoadingLabel"));
    }

    public void showSizeWarning(long maxSize) {
        this.tooLargeLabel.setText(MessageFormat.format(Messages.getString("VexLoadWarning.SizeWarning"), maxSize));
        this.tooLargeLabel.setVisible(true);
        this.proceedButton.setVisible(true);
        this.loadingLabel.setVisible(false);
    }

    public void showCSSWarning() {
        this.noProperStylesheet.setVisible(true);
        this.proceedButton.setVisible(true);
    }

    public void indicateLoading() {
        this.loadingLabel.setVisible(true);
        this.proceedButton.setEnabled(false);
    }

    protected void checkSubclass() {
    }

    public void setLoadingText(String message) {
        this.loadingLabel.setVisible(true);
        this.loadingLabel.setText(message);
    }

    public void showRootElementError() {
        this.errorLabel.setVisible(true);
        this.errorLabel.setText(ROOT_ELEMENT_ERROR);
        this.proceedButton.setEnabled(false);
    }

    public void addProceedListener(SelectionListener selectionAdapter) {
        if (this.proceedButton != null) {
            this.proceedButton.addSelectionListener(selectionAdapter);
        }
    }

    public void showDuplicateError() {
        this.errorLabel.setVisible(true);
        this.errorLabel.setText(DUPLICATE_ERROR);
        this.proceedButton.setEnabled(false);
    }
}

