/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import com.wutka.dtd.DTDParseException;
import java.io.IOException;
import java.net.URL;
import net.sf.vex.dom.DTDValidator;
import net.sf.vex.editor.config.BuildProblem;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigSource;
import net.sf.vex.editor.config.ConfigurationElement;
import net.sf.vex.editor.config.DocumentType;
import net.sf.vex.editor.config.IBuildProblemHandler;
import net.sf.vex.editor.config.IConfigElement;
import net.sf.vex.editor.config.IConfigItemFactory;
import net.sf.vex.editor.config.Messages;

public class DoctypeFactory
implements IConfigItemFactory {
    private static final String[] EXTS = new String[]{"dtd"};
    private static final String ELT_DOCTYPE = "doctype";
    private static final String ATTR_OUTLINE_PROVIDER = "outlineProvider";
    private static final String ATTR_DTD = "dtd";
    private static final String ATTR_SYSTEM_ID = "systemId";
    private static final String ATTR_PUBLIC_ID = "publicId";
    private static final String ELT_ROOT_ELEMENT = "rootElement";
    private static final String ATTR_NAME = "name";

    @Override
    public IConfigElement[] createConfigurationElements(ConfigItem item) {
        DocumentType doctype = (DocumentType)item;
        ConfigurationElement doctypeElement = new ConfigurationElement(ELT_DOCTYPE);
        doctypeElement.setAttribute(ATTR_PUBLIC_ID, doctype.getPublicId());
        doctypeElement.setAttribute(ATTR_SYSTEM_ID, doctype.getSystemId());
        doctypeElement.setAttribute(ATTR_DTD, doctype.getResourcePath());
        doctypeElement.setAttribute(ATTR_OUTLINE_PROVIDER, doctype.getOutlineProvider());
        String[] names = doctype.getRootElements();
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            ConfigurationElement rootElement = new ConfigurationElement(ELT_ROOT_ELEMENT);
            rootElement.setAttribute(ATTR_NAME, name);
            doctypeElement.addChild(rootElement);
            ++i;
        }
        return new IConfigElement[]{doctypeElement};
    }

    @Override
    public ConfigItem createItem(ConfigSource config, IConfigElement[] configElements) throws IOException {
        if (configElements.length < 1) {
            return null;
        }
        IConfigElement configElement = configElements[0];
        DocumentType doctype = new DocumentType(config);
        doctype.setPublicId(configElement.getAttribute(ATTR_PUBLIC_ID));
        doctype.setSystemId(configElement.getAttribute(ATTR_SYSTEM_ID));
        doctype.setResourcePath(configElement.getAttribute(ATTR_DTD));
        doctype.setOutlineProvider(configElement.getAttribute(ATTR_OUTLINE_PROVIDER));
        IConfigElement[] rootElementRefs = configElement.getChildren();
        String[] rootElements = new String[rootElementRefs.length];
        int i = 0;
        while (i < rootElementRefs.length) {
            rootElements[i] = rootElementRefs[i].getAttribute(ATTR_NAME);
            ++i;
        }
        doctype.setRootElements(rootElements);
        return doctype;
    }

    @Override
    public String getExtensionPointId() {
        return "net.sf.vex.editor.doctypes";
    }

    @Override
    public String[] getFileExtensions() {
        return EXTS;
    }

    @Override
    public String getPluralName() {
        return Messages.getString("DoctypeFactory.pluralName");
    }

    @Override
    public Object parseResource(URL baseUrl, String resourcePath, IBuildProblemHandler problemHandler) throws IOException {
        try {
            return DTDValidator.create((URL)new URL(baseUrl, resourcePath));
        }
        catch (DTDParseException ex) {
            if (problemHandler != null) {
                BuildProblem problem = new BuildProblem();
                problem.setSeverity(1);
                problem.setResourcePath(resourcePath);
                problem.setMessage(ex.getMessage());
                problem.setLineNumber(ex.getLineNumber());
                problemHandler.foundProblem(problem);
            }
            throw ex;
        }
    }
}

