/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.Messages;
import net.sf.vex.editor.config.PluginProject;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewPluginProjectWizard
extends BasicNewProjectResourceWizard {
    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.getString("NewPluginProjectWizard.title"));
    }

    public boolean performFinish() {
        boolean success = super.performFinish();
        if (success) {
            try {
                this.createVexPluginXml();
                this.registerVexPluginNature();
                PluginProject.load(this.getNewProject());
            }
            catch (CoreException e) {
                VexPlugin.getInstance().log(4, Messages.getString("NewPluginProjectWizard.createError"), e);
                success = false;
            }
        }
        return success;
    }

    private void createVexPluginXml() throws CoreException {
        IProject project = this.getNewProject();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(baos);
        out.println("<?xml version='1.0'?>");
        out.println("<plugin>");
        out.println("</plugin>");
        out.close();
        IFile pluginXml = project.getFile("vex-plugin.xml");
        pluginXml.create((InputStream)new ByteArrayInputStream(baos.toByteArray()), true, null);
        IDE.setDefaultEditor((IFile)pluginXml, (String)"org.eclipse.ui.DefaultTextEditor");
    }

    private void registerVexPluginNature() throws CoreException {
        IProject project = this.getNewProject();
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        String[] newNatures = new String[natures.length + 1];
        System.arraycopy(natures, 0, newNatures, 0, natures.length);
        newNatures[natures.length] = "net.sf.vex.editor.pluginNature";
        description.setNatureIds(newNatures);
        project.setDescription(description, null);
    }
}

