/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.vex.dom.DocumentWriter;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.ConfigEvent;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.ConfigSource;
import net.sf.vex.editor.config.ConfigurationElement;
import net.sf.vex.editor.config.DomConfigurationElement;
import net.sf.vex.editor.config.IConfigElement;
import net.sf.vex.editor.config.IConfigItemFactory;
import net.sf.vex.editor.config.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PluginProject
extends ConfigSource {
    public static final String PLUGIN_XML = "vex-plugin.xml";
    public static final String PROJECT_CONFIG_SER = ".vexConfig.ser";
    private String projectPath;
    public static final String SER_FILE = ".vexConfig.ser";

    protected PluginProject(IProject project) {
        this.projectPath = project.getFullPath().toString();
    }

    public void cleanState() throws CoreException {
        IFile configSer = this.getProject().getFile(".vexConfig.ser");
        configSer.delete(true, null);
    }

    public static PluginProject get(IProject project) {
        List sources = ConfigRegistry.getInstance().getAllConfigSources();
        for (ConfigSource source : sources) {
            if (!(source instanceof PluginProject) || !project.equals((Object)((PluginProject)source).getProject())) continue;
            return (PluginProject)source;
        }
        return null;
    }

    @Override
    public URL getBaseUrl() {
        try {
            return this.getProject().getLocation().toFile().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(Messages.getString("PluginProject.malformedUrl"), e);
        }
    }

    public IProject getProject() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.projectPath);
    }

    public static PluginProject load(IProject project) {
        try {
            if (!project.isOpen() || !project.hasNature("net.sf.vex.editor.pluginNature")) {
                String message = MessageFormat.format(Messages.getString("PluginProject.notPluginProject"), project.getName());
                throw new IllegalArgumentException(message);
            }
        }
        catch (CoreException coreException) {
            String message = MessageFormat.format(Messages.getString("PluginProject.notPluginProject"), project.getName());
            throw new IllegalArgumentException(message);
        }
        IFile serFile = project.getFile(".vexConfig.ser");
        PluginProject pluginProject = null;
        if (serFile.exists()) {
            try {
                ObjectInputStream ois = new ObjectInputStream(serFile.getContents());
                pluginProject = (PluginProject)ois.readObject();
            }
            catch (Exception ex) {
                String message = MessageFormat.format(Messages.getString("PluginProject.loadingError"), serFile);
                VexPlugin.getInstance().log(2, message, ex);
            }
        }
        boolean rebuild = false;
        if (pluginProject == null) {
            rebuild = true;
            pluginProject = new PluginProject(project);
        }
        ConfigRegistry registry = ConfigRegistry.getInstance();
        registry.addConfigSource(pluginProject);
        registry.fireConfigChanged(new ConfigEvent(PluginProject.class));
        if (rebuild) {
            try {
                project.build(6, null);
            }
            catch (Exception ex) {
                String message = MessageFormat.format(Messages.getString("PluginProject.buildError"), project.getName());
                VexPlugin.getInstance().log(4, message, ex);
            }
        }
        return pluginProject;
    }

    public void parseConfigXml() throws SAXException, IOException {
        DocumentBuilder builder;
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        catch (FactoryConfigurationError e) {
            throw new RuntimeException(e);
        }
        this.removeAllItems();
        URL url = new URL(this.getBaseUrl(), PLUGIN_XML);
        Document doc = builder.parse(url.toString());
        Element root = doc.getDocumentElement();
        this.setUniqueIdentifer(root.getAttribute("id"));
        NodeList nodeList = doc.getElementsByTagName("extension");
        int i = 0;
        while (i < nodeList.getLength()) {
            Element element = (Element)nodeList.item(i);
            String extPoint = element.getAttribute("point");
            String id = element.getAttribute("id");
            String name = element.getAttribute("name");
            ArrayList<Node> configElementList = new ArrayList<Node>();
            NodeList childList = element.getChildNodes();
            int j = 0;
            while (j < childList.getLength()) {
                Node child = childList.item(j);
                if (child instanceof Element) {
                    configElementList.add(child);
                }
                ++j;
            }
            IConfigElement[] configElements = new IConfigElement[configElementList.size()];
            int j2 = 0;
            while (j2 < configElementList.size()) {
                configElements[j2] = new DomConfigurationElement((Element)configElementList.get(j2));
                ++j2;
            }
            this.addItem(extPoint, id, name, configElements);
            ++i;
        }
    }

    public void saveState() throws CoreException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(this);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        IFile configSer = this.getProject().getFile(".vexConfig.ser");
        if (configSer.exists()) {
            configSer.setContents((InputStream)bais, true, false, null);
        } else {
            configSer.create((InputStream)bais, true, null);
            configSer.setDerived(true);
        }
    }

    public void writeConfigXml() throws CoreException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)baos, "utf-8"));
        ConfigurationElement root = new ConfigurationElement("plugin");
        for (ConfigItem item : this.getAllItems()) {
            ConfigurationElement extElement = new ConfigurationElement("extension");
            extElement.setAttribute("id", item.getSimpleId());
            extElement.setAttribute("name", item.getName());
            extElement.setAttribute("point", item.getExtensionPointId());
            IConfigItemFactory factory = ConfigRegistry.getInstance().getConfigItemFactory(item.getExtensionPointId());
            extElement.setChildren(factory.createConfigurationElements(item));
            root.addChild(extElement);
        }
        PluginProject.writeElement(root, out, 0);
        out.close();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(baos.toByteArray());
        IFile file = this.getProject().getFile(PLUGIN_XML);
        if (file.exists()) {
            file.setContents((InputStream)inputStream, true, false, null);
        } else {
            file.create((InputStream)inputStream, true, null);
        }
    }

    private static void writeElement(IConfigElement element, PrintWriter out, int level) {
        StringBuffer elementIndent = new StringBuffer();
        int i = 0;
        while (i < level) {
            elementIndent.append("  ");
            ++i;
        }
        StringBuffer elementPrefix = new StringBuffer();
        elementPrefix.append("<");
        elementPrefix.append(element.getName());
        StringBuffer attributeIndent = new StringBuffer(elementIndent.toString());
        int i2 = 0;
        while (i2 < elementPrefix.length() + 1) {
            attributeIndent.append(" ");
            ++i2;
        }
        out.print(elementIndent.toString());
        out.print(elementPrefix.toString());
        String[] attributeNames = element.getAttributeNames();
        int i3 = 0;
        while (i3 < attributeNames.length) {
            String attributeName = attributeNames[i3];
            if (i3 > 0) {
                out.println();
                out.print(attributeIndent);
            } else {
                out.print(" ");
            }
            out.print(attributeName);
            out.print("=\"");
            out.print(DocumentWriter.escape((String)element.getAttribute(attributeName)));
            out.print("\"");
            ++i3;
        }
        out.println(">");
        IConfigElement[] children = element.getChildren();
        int i4 = 0;
        while (i4 < children.length) {
            PluginProject.writeElement(children[i4], out, level + 1);
            ++i4;
        }
        out.print(elementIndent);
        out.print("</");
        out.print(element.getName());
        out.println(">");
    }
}

