/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.editor.config.ConfigItem;
import net.sf.vex.editor.config.ConfigRegistry;
import net.sf.vex.editor.config.ConfigSource;
import net.sf.vex.layout.BoxFactory;

public class Style
extends ConfigItem {
    public static final String EXTENSION_POINT = "net.sf.vex.editor.styles";
    private BoxFactory boxFactory;
    private Set publicIds = new HashSet();

    public Style(ConfigSource config) {
        super(config);
    }

    public void addDocumentType(String publicId) {
        this.publicIds.add(publicId);
    }

    public boolean appliesTo(String publicId) {
        return this.publicIds.contains(publicId);
    }

    public BoxFactory getBoxFactory() {
        return this.boxFactory;
    }

    public Set getDocumentTypes() {
        return Collections.unmodifiableSet(this.publicIds);
    }

    public static Style[] getStylesForDoctype(String publicId) {
        ConfigRegistry registry = ConfigRegistry.getInstance();
        ArrayList<Style> styles = new ArrayList<Style>();
        List allStyles = registry.getAllConfigItems(EXTENSION_POINT);
        for (Style style : allStyles) {
            if (!style.appliesTo(publicId)) continue;
            styles.add(style);
        }
        return styles.toArray(new Style[styles.size()]);
    }

    public StyleSheet getStyleSheet() {
        return (StyleSheet)this.getConfig().getParsedResource(this.getResourcePath());
    }

    @Override
    public String getExtensionPointId() {
        return EXTENSION_POINT;
    }

    public void removeAllDocumentTypes() {
        this.publicIds.clear();
    }

    public void removeDocumentType(String publicId) {
        this.publicIds.remove(publicId);
    }

    public void setBoxFactory(BoxFactory factory) {
        this.boxFactory = factory;
    }
}

