/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.action;

import java.util.ArrayList;
import net.sf.vex.action.AbstractVexAction;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexNonElement;
import net.sf.vex.widget.IVexWidget;

public class SplitAction
extends AbstractVexAction {
    @Override
    public void run(IVexWidget vexWidget) {
        IVexNode node = vexWidget.getCurrentNode();
        if (node instanceof IVexElement) {
            Styles styles = vexWidget.getStyleSheet().getStyles((IVexElement)node);
            while (!styles.isBlock()) {
                node = ((IVexElement)node).getParent();
                styles = vexWidget.getStyleSheet().getStyles((IVexElement)node);
            }
            SplitAction.splitElement(vexWidget, (IVexElement)node);
        } else if (node instanceof IVexNonElement) {
            SplitAction.insertNewLine(vexWidget);
        }
    }

    private static void insertNewLine(IVexWidget vexWidget) {
        IVexDocument doc = vexWidget.getDocument();
        int offset = vexWidget.getCaretOffset();
        doc.insertText(offset, "\n");
        vexWidget.moveTo(offset + 1);
    }

    public static void splitElement(final IVexWidget vexWidget, final IVexElement element) {
        vexWidget.doWork(new Runnable(){

            @Override
            public void run() {
                long start = System.currentTimeMillis();
                Styles styles = vexWidget.getStyleSheet().getStyles(element);
                if (styles.getWhiteSpace().equalsIgnoreCase("pre")) {
                    SplitAction.insertNewLine(vexWidget);
                } else {
                    ArrayList<IVexElement> children = new ArrayList<IVexElement>();
                    ArrayList<IVexDocumentFragment> frags = new ArrayList<IVexDocumentFragment>();
                    IVexElement child = vexWidget.getCurrentElement();
                    while (true) {
                        children.add(child);
                        vexWidget.moveTo(child.getEndOffset(), true);
                        frags.add(vexWidget.getSelectedFragment());
                        vexWidget.deleteSelection();
                        vexWidget.moveTo(child.getEndOffset() + 1);
                        if (child == element) break;
                        child = child.getParent();
                    }
                    int i = children.size() - 1;
                    while (i >= 0) {
                        child = (IVexElement)children.get(i);
                        IVexDocumentFragment frag = (IVexDocumentFragment)frags.get(i);
                        vexWidget.insertElement(child.clone());
                        int offset = vexWidget.getCaretOffset();
                        if (frag != null) {
                            vexWidget.insertFragment(frag);
                        }
                        vexWidget.moveTo(offset);
                        --i;
                    }
                }
                if (vexWidget.isDebugging()) {
                    long end = System.currentTimeMillis();
                    System.out.println("split() took " + (end - start) + "ms");
                }
            }
        });
    }
}

