/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.text.MessageFormat;
import java.util.Map;
import java.util.concurrent.CancellationException;
import net.sf.vex.core.EditorOptions;
import net.sf.vex.core.Graphics;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.BoxFactory;
import net.sf.vex.layout.VexAnnotationTracker;
import org.eclipse.core.runtime.IProgressMonitor;

public class LayoutContext {
    private BoxFactory boxFactory;
    private IVexDocument document;
    private Graphics graphics;
    private StyleSheet styleSheet;
    private int selectionStart;
    private int selectionEnd;
    private long startTime = System.currentTimeMillis();
    private Map<IVexElement, Boolean> collapsed;
    private EditorOptions editorOptions;
    private VexAnnotationTracker annotationTracker;
    private IProgressMonitor progressMonitor;

    public BoxFactory getBoxFactory() {
        return this.boxFactory;
    }

    public IVexDocument getDocument() {
        return this.document;
    }

    public Graphics getGraphics() {
        return this.graphics;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public StyleSheet getStyleSheet() {
        return this.styleSheet;
    }

    public boolean isElementSelected(IVexElement element) {
        return element != null && element.getStartOffset() >= this.getSelectionStart() && element.getEndOffset() + 1 <= this.getSelectionEnd();
    }

    public void resetStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void setBoxFactory(BoxFactory factory) {
        this.boxFactory = factory;
    }

    public void setDocument(IVexDocument document) {
        this.document = document;
    }

    public void setGraphics(Graphics graphics) {
        this.graphics = graphics;
    }

    public void setStyleSheet(StyleSheet sheet) {
        this.styleSheet = sheet;
    }

    public int getSelectionEnd() {
        return this.selectionEnd;
    }

    public int getSelectionStart() {
        return this.selectionStart;
    }

    public void setSelectionEnd(int i) {
        this.selectionEnd = i;
    }

    public void setSelectionStart(int i) {
        this.selectionStart = i;
    }

    public boolean isCollapsed(IVexElement element) {
        boolean coll = false;
        if (this.collapsed.containsKey(element)) {
            coll = true;
        }
        return coll;
    }

    public void collapse(IVexElement element) {
        this.collapsed.put(element, true);
    }

    public void expand(IVexElement element) {
        this.collapsed.remove(element);
    }

    public void setCollapsedList(Map<IVexElement, Boolean> collapsed) {
        this.collapsed = collapsed;
    }

    public void setEditorOptions(EditorOptions globalOptions) {
        this.editorOptions = globalOptions;
    }

    public EditorOptions.InlineMarkerStyle getInlineMarkerStyle() {
        return this.editorOptions.getInlineMarkerStyle();
    }

    public void setInlineMarkerStyle(EditorOptions.InlineMarkerStyle inlineMarkerStyle) {
        this.editorOptions.setInlineMarkerStyle(inlineMarkerStyle);
    }

    public EditorOptions.BlockMarkerStyle getBlockMarkerStyle() {
        return this.editorOptions.getBlockMarkerStyle();
    }

    public void setBlockMarkerStyle(EditorOptions.BlockMarkerStyle blockMarkerStyle) {
        this.editorOptions.setBlockMarkerStyle(blockMarkerStyle);
    }

    public boolean showInlineMarkers() {
        return this.editorOptions.showInlineMarkers();
    }

    public void setShowInlineMarkers(boolean showInlineMarkers) {
        this.editorOptions.setShowInlineMarkers(showInlineMarkers);
    }

    public boolean showBlockMarkers() {
        return this.editorOptions.showBlockMarkers();
    }

    public void setShowBlockMarkers(boolean showBlockMarkers) {
        this.editorOptions.setShowBlockMarkers(showBlockMarkers);
    }

    public void setAnnotationTracker(VexAnnotationTracker annotationTracker) {
        this.annotationTracker = annotationTracker;
    }

    VexAnnotationTracker getAnnotationTracker() {
        return this.annotationTracker;
    }

    public void subTask(String message, Object ... args) throws CancellationException {
        if (this.progressMonitor != null) {
            String parsedMessage = MessageFormat.format(message, args);
            if (this.progressMonitor.isCanceled()) {
                throw new CancellationException(parsedMessage);
            }
            this.progressMonitor.subTask(parsedMessage);
        }
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.progressMonitor = monitor;
    }
}

