/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.editor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import net.sf.vex.dom.DocumentWriter;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexRootElement;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.impl.Document;
import net.sf.vex.dom.impl.RootElement;
import net.sf.vex.editor.DocumentFileCreationPage;
import net.sf.vex.editor.DocumentTypeSelectionPage;
import net.sf.vex.editor.Messages;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.editor.VexPlugin;
import net.sf.vex.editor.config.Style;
import net.sf.vex.widget.CssWhitespacePolicy;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.registry.EditorDescriptor;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.internal.registry.FileEditorMapping;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class NewDocumentWizard
extends BasicNewResourceWizard {
    private DocumentTypeSelectionPage typePage;
    private DocumentFileCreationPage filePage;

    public void addPages() {
        this.typePage = new DocumentTypeSelectionPage();
        this.filePage = new DocumentFileCreationPage("filePage", this.getSelection());
        this.addPage((IWizardPage)this.typePage);
        this.addPage((IWizardPage)this.filePage);
    }

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        super.init(workbench, currentSelection);
        this.setWindowTitle(Messages.getString("NewDocumentWizard.title"));
    }

    public boolean performFinish() {
        IWorkbenchPage page;
        Style style;
        Document doc;
        block4: {
            try {
                RootElement root = new RootElement(this.typePage.getRootElementName());
                doc = new Document((IVexRootElement)root);
                doc.setPublicID(this.typePage.getDocumentType().getPublicId());
                doc.setSystemID(this.typePage.getDocumentType().getSystemId());
                style = VexEditor.findStyleForDoctype(doc.getPublicID());
                if (style != null) break block4;
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewDocumentWizard.noStyles.title"), (String)Messages.getString("NewDocumentWizard.noStyles.message"));
                return false;
            }
            catch (Exception ex) {
                String message = MessageFormat.format(Messages.getString("NewDocumentWizard.errorLoading.message"), this.filePage.getFileName(), ex.getMessage());
                VexPlugin.getInstance().log(4, message, ex);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewDocumentWizard.errorLoading.title"), (String)("Unable to create " + this.filePage.getFileName()));
                return false;
            }
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DocumentWriter writer = new DocumentWriter();
        writer.setWhitespacePolicy((IWhitespacePolicy)new CssWhitespacePolicy(style.getStyleSheet()));
        writer.write((IVexDocument)doc, (OutputStream)baos);
        baos.close();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        this.filePage.setInitialContents(bais);
        IFile file = this.filePage.createNewFile();
        IDE.setDefaultEditor((IFile)file, (String)"net.sf.vex.editor.VexEditor");
        this.selectAndReveal((IResource)file);
        NewDocumentWizard.registerEditorForFilename("*." + file.getFileExtension(), "net.sf.vex.editor.VexEditor");
        IWorkbenchWindow dw = this.getWorkbench().getActiveWorkbenchWindow();
        if (dw != null && (page = dw.getActivePage()) != null) {
            IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
        }
        this.typePage.saveSettings();
        return true;
    }

    private static void registerEditorForFilename(String fileName, String editorId) {
        EditorDescriptor ed = NewDocumentWizard.getEditorDescriptor(editorId);
        if (ed == null) {
            return;
        }
        IEditorRegistry reg = PlatformUI.getWorkbench().getEditorRegistry();
        EditorRegistry ereg = (EditorRegistry)reg;
        FileEditorMapping[] mappings = (FileEditorMapping[])ereg.getFileEditorMappings();
        FileEditorMapping mapping = null;
        int i = 0;
        while (i < mappings.length) {
            FileEditorMapping fem = mappings[i];
            if (fem.getLabel().equals(fileName)) {
                mapping = fem;
                break;
            }
            ++i;
        }
        if (mapping != null) {
            IEditorDescriptor[] editors = mapping.getEditors();
            int i2 = 0;
            while (i2 < editors.length) {
                if (editors[i2].getId().equals(editorId)) {
                    return;
                }
                ++i2;
            }
            mapping.addEditor(ed);
            ereg.setFileEditorMappings(mappings);
            ereg.saveAssociations();
        } else {
            String name = null;
            String ext = null;
            int iDot = fileName.lastIndexOf(46);
            if (iDot == -1) {
                name = fileName;
            } else {
                name = fileName.substring(0, iDot);
                ext = fileName.substring(iDot + 1);
            }
            mapping = new FileEditorMapping(name, ext);
            FileEditorMapping[] newMappings = new FileEditorMapping[mappings.length + 1];
            mapping.addEditor(ed);
            System.arraycopy(mappings, 0, newMappings, 0, mappings.length);
            newMappings[mappings.length] = mapping;
            ereg.setFileEditorMappings(newMappings);
            ereg.saveAssociations();
        }
    }

    private static EditorDescriptor getEditorDescriptor(String editorId) {
        EditorRegistry reg = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor[] editors = reg.getSortedEditorsFromPlugins();
        int i = 0;
        while (i < editors.length) {
            if (editors[i].getId().equals(editorId)) {
                return (EditorDescriptor)editors[i];
            }
            ++i;
        }
        return null;
    }
}

