/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.ui;

import info.textgrid.lab.core.importexport.ImportPlugin;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.importexport.model.ImportModel;
import info.textgrid.lab.core.importexport.ui.ImportExportPart;
import info.textgrid.lab.core.importexport.ui.Messages;
import info.textgrid.lab.core.importexport.ui.TargetProjectCombo;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class ImportPart
extends ImportExportPart {
    private static final String REIMPORT_TEXT = Messages.ImportPart_Reimport_Message;
    private Label reimportLabel;

    public ImportPart() {
        this.setExport(false);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        this.getObjectsViewer().addDropSupport(7, new Transfer[]{FileTransfer.getInstance()}, (DropTargetListener)new ImportDropAdapter((Viewer)this.getObjectsViewer()));
        ImageRegistry registry = JFaceResources.getImageRegistry();
        System.out.println(registry);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.core.importexport.ImportEditor");
    }

    @Override
    protected void createAreaBelowObjectsViewer(Composite content) {
        this.reimportLabel = new Label(content, 64);
        this.reimportLabel.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.reimportLabel.setText("xxx");
        this.reimportLabel.setBackground(Display.getDefault().getSystemColor(29));
        this.reimportLabel.setForeground(Display.getDefault().getSystemColor(28));
        this.reimportLabel.setVisible(false);
    }

    private void showReimportLabel(boolean show) {
        this.reimportLabel.setText(show ? REIMPORT_TEXT : "---");
        this.reimportLabel.setVisible(show);
        this.reimportLabel.pack(true);
        this.getContent().layout(true, true);
    }

    @Override
    protected void createTopArea(Composite parent) {
        Composite topGroup = new Composite(parent, 0);
        topGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        topGroup.setLayout((Layout)new GridLayout(3, false));
        final Label rootLabel = new Label(topGroup, 0);
        rootLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        rootLabel.setText(Messages.ImportExportPart_drop);
        Button addButton = new Button(topGroup, 0x800000);
        addButton.setLayoutData((Object)new GridData(1, 0x1000008, false, false));
        addButton.setText(Messages.ImportPart_Add);
        addButton.setToolTipText(Messages.ImportPart_Add_Tooltip);
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(ImportPart.this.getSite().getShell(), 4098);
                dialog.setText(Messages.ImportPart_AddFilesDialogTitle);
                IPath root = ImportPart.this.getImportModel().getRoot();
                if (root == null && (dialog.getFilterPath() == null || dialog.getFilterPath().isEmpty())) {
                    dialog.setFilterPath(System.getProperty("user.home", "/"));
                } else {
                    dialog.setFilterPath(root.toOSString());
                }
                String result = dialog.open();
                if (result != null) {
                    String[] fileNames = dialog.getFileNames();
                    String[] fullNames = new String[fileNames.length];
                    try {
                        int i = 0;
                        while (i < fileNames.length) {
                            fullNames[i] = new File(dialog.getFilterPath(), fileNames[i]).getCanonicalPath();
                            ++i;
                        }
                        new AddFilesJob(fullNames).schedule();
                    }
                    catch (IOException e1) {
                        StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.core.importexport", NLS.bind((String)Messages.ImportPart_Add_Error, (Object)e1.getLocalizedMessage()), (Throwable)e1), 3);
                    }
                }
            }
        });
        this.createRemoveButton(topGroup);
        this.getImportModel().addListener(new ImportModel.ModelListener(){

            @Override
            public void rootChanged(final ImportModel model, IPath oldRoot) {
                new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        if (!rootLabel.isDisposed()) {
                            rootLabel.setText(model.getRoot().toPortableString());
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
    }

    @Override
    protected Composite createTargetArea(Composite content) {
        Composite targetComposite = new Composite(content, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)targetComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(targetComposite);
        Label targetProject = new Label(targetComposite, 0);
        targetProject.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        targetProject.setText(Messages.ImportExportPart_Target_Project);
        this.setProjectCombo(new TargetProjectCombo(targetComposite));
        GridDataFactory.fillDefaults().grab(true, false).applyTo(this.getProjectCombo().getControl());
        this.getProjectCombo().setNeedsValue(true);
        this.getProjectCombo().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (!event.getSelection().isEmpty()) {
                    ImportPart.this.getImportModel().setTargetProject((TextGridProject)AdapterUtils.getAdapter((Object)((IStructuredSelection)event.getSelection()).getFirstElement(), TextGridProject.class));
                    ImportPart.this.getImportModel().setImportAsNewRevisions(ImportPart.this.getProjectCombo().isNewRevision());
                    ImportPart.this.getObjectsViewer().refresh(true);
                    if (ImportPart.this.noProjectDisabledState != null) {
                        ImportPart.this.noProjectDisabledState.restore();
                        ImportPart.this.noProjectDisabledState = null;
                    }
                } else if (ImportPart.this.noProjectDisabledState == null) {
                    ImportPart.this.noProjectDisabledState = ControlEnableState.disable((Control)ImportPart.this.importGroup);
                }
            }
        });
        return targetComposite;
    }

    public void setProject(TextGridProject project) {
        TargetProjectCombo combo = this.getProjectCombo();
        combo.setProject(project);
    }

    @Override
    protected void perform() {
        final ControlEnableState enableState = ControlEnableState.disable((Control)this.getContent());
        final TextGridProject project = (TextGridProject)AdapterUtils.getAdapter((Object)((IStructuredSelection)this.getProjectCombo().getSelection()).getFirstElement(), TextGridProject.class);
        if (project == null) {
            return;
        }
        Job importJob = new Job(Messages.ImportExportPart_Importing){

            protected IStatus run(IProgressMonitor monitor) {
                return ImportPart.this.getImportModel().doImport(project, monitor);
            }
        };
        importJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                new UIJob(Messages.ImportExportPart_Import_Done){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        (this).ImportPart.this.resultPage.setInput(event.getResult());
                        enableState.restore();
                        if (ImportPlugin.useNewGUI()) {
                            if (event.getResult().getSeverity() <= 2) {
                                ImportPart.this.setDirty(false);
                            }
                            (this).ImportPart.this.pages.showPage((Control)(this).ImportPart.this.resultPage);
                            ImportPart.this.getNextButton().setEnabled(true);
                        }
                        return Status.OK_STATUS;
                    }
                }.schedule();
            }
        });
        importJob.setUser(true);
        importJob.schedule();
    }

    protected class AddFilesJob
    extends Job {
        private final String[] filenames;
        ImportEntry entry;

        public AddFilesJob(String ... filenames) {
            super(Messages.ImportExportPart_Adding_files);
            this.filenames = filenames;
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * this.filenames.length));
            String[] stringArray = this.filenames;
            int n = this.filenames.length;
            int n2 = 0;
            while (n2 < n) {
                String filename = stringArray[n2];
                if (progress.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ImportEntry lastEntry = ImportPart.this.getImportModel().addFile(new File(filename), (IProgressMonitor)progress.newChild(100));
                if (this.entry == null) {
                    this.entry = lastEntry;
                }
                ++n2;
            }
            final Set<String> reimportProjects = ImportPart.this.getImportModel().getReimportProjectIDs();
            new UIJob(Messages.ImportExportPart_Updating_Viewer){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (ImportPart.this.getContent().isDisposed()) {
                        return Status.CANCEL_STATUS;
                    }
                    ImportPart.this.setDirty(true);
                    ImportPart.this.getObjectsViewer().refresh();
                    if (AddFilesJob.this.entry != null) {
                        ImportPart.this.getObjectsViewer().setSelection((ISelection)new StructuredSelection((Object)AddFilesJob.this.entry));
                    }
                    ImportPart.this.getProjectCombo().setReimportProjects(reimportProjects);
                    ImportPart.this.showReimportLabel(!reimportProjects.isEmpty());
                    return Status.OK_STATUS;
                }
            }.schedule();
            return Status.OK_STATUS;
        }
    }

    private final class ImportDropAdapter
    extends ViewerDropAdapter {
        private ImportDropAdapter(Viewer viewer) {
            super(viewer);
            this.setExpandEnabled(true);
        }

        public boolean performDrop(Object data) {
            if (data instanceof String[]) {
                String[] filenames = (String[])data;
                new AddFilesJob(filenames).schedule();
            }
            return true;
        }

        public boolean validateDrop(Object target, int operation, TransferData transferType) {
            System.out.println(MessageFormat.format("validateDrop. Target: {0}; transfer: {1}", target, transferType));
            return target == null || target instanceof ImportModel || target instanceof ImportEntry && ((ImportEntry)((Object)target)).mayHaveChildren();
        }
    }
}

