/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.model;

import info.textgrid.lab.core.model.Activator;
import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.Messages;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.namespaces.middleware.tgcrud.services.tgcrudservice.TextGridFaultType;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Hashtable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.statushandlers.StatusManager;

public class TextGridErrorHandler {
    private static TextGridErrorHandler _instance = new TextGridErrorHandler();
    private static Hashtable<String, TextGridError> errorList = new Hashtable();
    private final int SPANOFTIME = 2000;
    private final String INFO_DELETED = Messages.TextGridErrorHandler_RepetativeErrorXonY;
    private final String INFO_REPETITIVE = Messages.TextGridErrorHandler_AlreadyDeletedErrorXonY;
    private static final String[] TG_FAULT_CODES = new String[]{Messages.TextGridErrorHandler_UnknownFault, Messages.TextGridErrorHandler_AuthFault, Messages.TextGridErrorHandler_IoFault, Messages.TextGridErrorHandler_ObjectNotFoundFault, Messages.TextGridErrorHandler_MetadataParseFault, Messages.TextGridErrorHandler_RelationExistsFault, Messages.TextGridErrorHandler_UpdateConflictFault, Messages.TextGridErrorHandler_ProtocolNotImplementedFault, Messages.TextGridErrorHandler_NoConfigurationFault, Messages.TextGridErrorHandler_InternalServiceError};

    public static String formatErrorMessage(TextGridFaultType faultType, URI uri, boolean addDetail) {
        int faultNo = faultType.getFaultNo();
        if (faultNo >= TG_FAULT_CODES.length) {
            faultNo = 0;
        }
        TextGridObject object = TextGridObject.getInstanceOffline(uri);
        String result = MessageFormat.format(TG_FAULT_CODES[faultNo], object);
        if (addDetail) {
            result = String.valueOf(result) + " \n" + MessageFormat.format(Messages.TextGridErrorHandler_DetailMessage, faultType.getFaultMessage(), faultType.getCause());
        }
        return result;
    }

    public static TextGridErrorHandler getInstance() {
        return _instance;
    }

    public IStatus handleError(Throwable tgError, TextGridFaultType errorFaultType, URI uri) {
        boolean showError = false;
        try {
            if (uri != null && !TextGridObject.getInstance(uri, false).isDeleted()) {
                ErrorKey errorKey = new ErrorKey(uri, errorFaultType.getCause());
                TextGridError listError = errorList.get(errorKey.toString());
                if (listError == null) {
                    showError = true;
                } else if (listError.time + 2000L < System.currentTimeMillis()) {
                    showError = true;
                }
                errorList.put(errorKey.toString(), new TextGridError(tgError, errorFaultType));
                if (showError) {
                    Status status = new Status(4, "info.textgrid.lab.core.model", TextGridErrorHandler.formatErrorMessage(errorFaultType, uri, true), tgError);
                    StatusManager.getManager().handle((IStatus)status, 3);
                    return status;
                }
                return Activator.handleProblem(1, tgError, this.INFO_REPETITIVE, tgError.getClass().getSimpleName(), uri);
            }
            return Activator.handleProblem(1, tgError, this.INFO_DELETED, tgError.getClass().getSimpleName(), uri);
        }
        catch (CrudServiceException e) {
            return Activator.handleError(tgError, Messages.TextGridErrorHandler_ErrorWhileErrorHandling, ((Object)((Object)e)).getClass().getSimpleName(), uri, CrudServiceException.getFaultType((Throwable)((Object)e), TextGridFaultType.class).getFaultMessage(), CrudServiceException.getFaultType((Throwable)((Object)e), TextGridFaultType.class).getCause());
        }
    }

    class ErrorKey {
        private URI uri;
        private String localCause;

        public ErrorKey(URI uri, String localCause) {
            this.uri = uri;
            this.localCause = localCause;
        }

        public String toString() {
            return this.uri + this.localCause;
        }
    }

    class TextGridError {
        private Throwable error;
        private TextGridFaultType faultType;
        private long time;

        public TextGridError(Throwable error, TextGridFaultType faultType) {
            this.error = error;
            this.faultType = faultType;
            this.time = System.currentTimeMillis();
        }
    }
}

