/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.tools;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.linkeditor.tools.Activator;
import info.textgrid.lab.linkeditor.tools.ImportExportUtils;
import info.textgrid.lab.linkeditor.tools.LinksObjectEditorSection;
import info.textgrid.lab.linkeditor.tools.Messages;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class ExportImageLinkEditorFileCombinationDialog
extends TitleAreaDialog {
    private TextGridObject selectedLinksObject = null;
    private LinksObjectEditorSection linksObjectEditor = null;
    private DirectoryDialog dialog = null;
    private String linksObjectTarget;
    private String imagesTarget;
    private String xmlTarget;
    private boolean firstModifyEnabled = false;
    private boolean exportAll = false;
    private boolean modify = false;
    private static Map<String, String> uriPathMap = Collections.synchronizedMap(new HashMap());

    public ExportImageLinkEditorFileCombinationDialog(Shell parentShell) {
        super(parentShell);
        this.dialog = new DirectoryDialog(parentShell);
        this.dialog.setText(Messages.ExportImageLinkEditorFileCombinationDialog_Export);
        this.dialog.setMessage(Messages.ExportImageLinkEditorFileCombinationDialog_PleaseSelectADictionaryToExport);
    }

    public static void openDialog(TextGridObject object) {
        ExportImageLinkEditorFileCombinationDialog dialog = new ExportImageLinkEditorFileCombinationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
        dialog.selectedLinksObject = object;
        dialog.open();
    }

    protected Control createDialogArea(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        control.setLayout((Layout)new GridLayout(1, false));
        this.getShell().setText(Messages.ExportImageLinkEditorFileCombinationDialog_ExportILEOCombination);
        if (this.selectedLinksObject != null) {
            try {
                this.setMessage(String.valueOf(Messages.ExportImageLinkEditorFileCombinationDialog_SelectedTILObject) + this.selectedLinksObject.getTitle() + " (" + this.selectedLinksObject.getURI().toString() + ")");
            }
            catch (CoreException e) {
                Activator.handleError(e, "Couldn't get the title of the selected object!", new Object[0]);
                return control;
            }
        }
        this.setTitle("Export Image Link Editor Object Combination...");
        Group grp0 = new Group(control, 0);
        grp0.setLayoutData((Object)new GridData(4, 4, true, true));
        grp0.setLayout((Layout)new GridLayout(2, false));
        Label lbl0 = new Label((Composite)grp0, 64);
        lbl0.setLayoutData((Object)new GridData(4, 128, true, false));
        lbl0.setText(Messages.ExportImageLinkEditorFileCombinationDialog_SelectLocalDirectoryToExport);
        new Label((Composite)grp0, 0);
        final Text txt10 = new Text((Composite)grp0, 2048);
        txt10.setLayoutData((Object)new GridData(4, 4, true, false));
        txt10.setEditable(false);
        txt10.setBackground(txt10.getDisplay().getSystemColor(1));
        Button btn10 = new Button((Composite)grp0, 8);
        btn10.setText(Messages.ExportImageLinkEditorFileCombinationDialog_Browse);
        btn10.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String result = ExportImageLinkEditorFileCombinationDialog.this.dialog.open();
                if (result != null) {
                    ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget = result;
                    txt10.setText(ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget);
                    ExportImageLinkEditorFileCombinationDialog.this.setErrorMessage(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Group grp1 = new Group(control, 0);
        grp1.setLayoutData((Object)new GridData(4, 4, true, true));
        grp1.setLayout((Layout)new GridLayout(1, false));
        final Button yesNoBtn1 = new Button((Composite)grp1, 16);
        yesNoBtn1.setText(Messages.ExportImageLinkEditorFileCombinationDialog_IWantToExportTheWholeImage);
        final Group grp11 = new Group((Composite)grp1, 0);
        grp11.setLayoutData((Object)new GridData(4, 4, true, true));
        grp11.setLayout((Layout)new GridLayout(2, false));
        Label lbl11 = new Label((Composite)grp11, 0);
        lbl11.setText(Messages.ExportImageLinkEditorFileCombinationDialog_TargetDirectoryForImages);
        new Label((Composite)grp11, 0);
        final Text txt11 = new Text((Composite)grp11, 2048);
        txt11.setLayoutData((Object)new GridData(4, 4, true, false));
        txt11.setEditable(false);
        txt11.setBackground(txt11.getDisplay().getSystemColor(1));
        Button btn11 = new Button((Composite)grp11, 8);
        btn11.setText(Messages.ExportImageLinkEditorFileCombinationDialog_Browse);
        btn11.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String result = ExportImageLinkEditorFileCombinationDialog.this.dialog.open();
                if (result != null) {
                    ExportImageLinkEditorFileCombinationDialog.this.imagesTarget = result;
                    txt11.setText(ExportImageLinkEditorFileCombinationDialog.this.imagesTarget);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        final Group grp12 = new Group((Composite)grp1, 0);
        grp12.setLayoutData((Object)new GridData(4, 4, true, true));
        grp12.setLayout((Layout)new GridLayout(2, false));
        Label lbl12 = new Label((Composite)grp12, 0);
        lbl12.setText(Messages.ExportImageLinkEditorFileCombinationDialog_TargetDirectoryForXmlObjects);
        new Label((Composite)grp12, 0);
        final Text txt12 = new Text((Composite)grp12, 2048);
        txt12.setLayoutData((Object)new GridData(4, 4, true, false));
        txt12.setEditable(false);
        txt12.setBackground(txt12.getDisplay().getSystemColor(1));
        Button btn12 = new Button((Composite)grp12, 8);
        btn12.setText(Messages.ExportImageLinkEditorFileCombinationDialog_Browse);
        btn12.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String result = ExportImageLinkEditorFileCombinationDialog.this.dialog.open();
                if (result != null) {
                    ExportImageLinkEditorFileCombinationDialog.this.xmlTarget = result;
                    txt12.setText(ExportImageLinkEditorFileCombinationDialog.this.xmlTarget);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.setEnabledForComposite((Composite)grp11, false);
        this.setEnabledForComposite((Composite)grp12, false);
        Group grp2 = new Group(control, 0);
        grp2.setLayoutData((Object)new GridData(4, 4, true, true));
        grp2.setLayout((Layout)new GridLayout(1, false));
        final Button yesNoBtn2 = new Button((Composite)grp2, 16);
        yesNoBtn2.setText(Messages.ExportImageLinkEditorFileCombinationDialog_IWantToModifyTheReferences);
        this.linksObjectEditor = new LinksObjectEditorSection();
        this.linksObjectEditor.create((Composite)grp2);
        final Group secGrp = this.linksObjectEditor.getSectionGroup();
        this.setEnabledForComposite((Composite)secGrp, false);
        yesNoBtn1.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget == null || "".equals(ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget)) {
                    ExportImageLinkEditorFileCombinationDialog.this.setErrorMessage("First you have to select a target directory to export the selected Image Link Editor Object!");
                    yesNoBtn1.setSelection(false);
                    return;
                }
                ExportImageLinkEditorFileCombinationDialog.this.exportAll = yesNoBtn1.getSelection();
                if (ExportImageLinkEditorFileCombinationDialog.this.exportAll) {
                    ExportImageLinkEditorFileCombinationDialog.this.modify = false;
                    yesNoBtn2.setSelection(false);
                    ExportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)secGrp, ExportImageLinkEditorFileCombinationDialog.this.modify);
                }
                ExportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp11, ExportImageLinkEditorFileCombinationDialog.this.exportAll);
                ExportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp12, ExportImageLinkEditorFileCombinationDialog.this.exportAll);
                if (ExportImageLinkEditorFileCombinationDialog.this.exportAll) {
                    if (ExportImageLinkEditorFileCombinationDialog.this.imagesTarget == null) {
                        ExportImageLinkEditorFileCombinationDialog.this.imagesTarget = ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget;
                    }
                    if (ExportImageLinkEditorFileCombinationDialog.this.xmlTarget == null) {
                        ExportImageLinkEditorFileCombinationDialog.this.xmlTarget = ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget;
                    }
                    txt11.setText(ExportImageLinkEditorFileCombinationDialog.this.imagesTarget);
                    txt12.setText(ExportImageLinkEditorFileCombinationDialog.this.xmlTarget);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        yesNoBtn2.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget == null || "".equals(ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget)) {
                    ExportImageLinkEditorFileCombinationDialog.this.setErrorMessage("First you have to select a target directory to export the selected Image Link Editor Object!");
                    yesNoBtn2.setSelection(false);
                    return;
                }
                ExportImageLinkEditorFileCombinationDialog.this.modify = yesNoBtn2.getSelection();
                if (ExportImageLinkEditorFileCombinationDialog.this.modify) {
                    ExportImageLinkEditorFileCombinationDialog.this.exportAll = false;
                    yesNoBtn1.setSelection(false);
                    ExportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp11, ExportImageLinkEditorFileCombinationDialog.this.exportAll);
                    ExportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)grp12, ExportImageLinkEditorFileCombinationDialog.this.exportAll);
                }
                ExportImageLinkEditorFileCombinationDialog.this.setEnabledForComposite((Composite)secGrp, ExportImageLinkEditorFileCombinationDialog.this.modify);
                if (!ExportImageLinkEditorFileCombinationDialog.this.firstModifyEnabled) {
                    ExportImageLinkEditorFileCombinationDialog.this.linksObjectEditor.setSelectedTGObject(ExportImageLinkEditorFileCombinationDialog.this.selectedLinksObject);
                    ExportImageLinkEditorFileCombinationDialog.this.firstModifyEnabled = true;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return control;
    }

    private void setEnabledForComposite(Composite comp, boolean enabled) {
        Control[] controlArray = comp.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.setEnabled(enabled);
            if (c instanceof Composite) {
                this.setEnabledForComposite((Composite)c, enabled);
            }
            ++n2;
        }
    }

    protected void okPressed() {
        if (this.linksObjectTarget == null || "".equals(this.linksObjectTarget)) {
            this.setErrorMessage("First you have to select a target directory to export the selected Image Link Editor Object!");
            return;
        }
        if (this.exportAll && (this.imagesTarget == null || this.xmlTarget == null || "".equals(this.imagesTarget) || "".equals(this.xmlTarget))) {
            this.setErrorMessage("First you have to select target directories for saving the image/xml objects!");
            return;
        }
        if (this.exportAll) {
            uriPathMap.clear();
            Job exportJob = new Job("Exporting the objects..."){

                protected IStatus run(IProgressMonitor monitor) {
                    String uri;
                    int n;
                    int n2;
                    String[] stringArray;
                    ArrayList<TextGridObject> objects;
                    ImportExportUtils.TGObjectAnalyzer analyzer = ImportExportUtils.getObjectAnalyzer(ExportImageLinkEditorFileCombinationDialog.this.selectedLinksObject);
                    UIJob xml_j = null;
                    UIJob images_j = null;
                    String[] uris = analyzer.getTextUris();
                    if (uris.length > 0) {
                        objects = new ArrayList<TextGridObject>();
                        stringArray = uris;
                        n2 = uris.length;
                        n = 0;
                        while (n < n2) {
                            uri = stringArray[n];
                            try {
                                if (uri.startsWith("textgrid")) {
                                    objects.add(TextGridObject.getInstance((URI)new URI(uri), (boolean)true));
                                }
                            }
                            catch (CrudServiceException e) {
                                Activator.handleError(e, "Couldn't get the TG-Object: " + uri, new Object[0]);
                            }
                            catch (URISyntaxException e) {
                                Activator.handleError(e, "Couldn't get the TG-Object: " + uri, new Object[0]);
                            }
                            ++n;
                        }
                        xml_j = new UIJob("Exporting xml objects..."){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                ExportImageLinkEditorFileCombinationDialog.exportObjects(ExportImageLinkEditorFileCombinationDialog.this.xmlTarget, objects.toArray(new TextGridObject[0]));
                                return Status.OK_STATUS;
                            }
                        };
                        xml_j.schedule();
                    }
                    if ((uris = analyzer.getImageUris()).length > 0) {
                        objects = new ArrayList();
                        stringArray = uris;
                        n2 = uris.length;
                        n = 0;
                        while (n < n2) {
                            uri = stringArray[n];
                            try {
                                if (uri.startsWith("textgrid")) {
                                    objects.add(TextGridObject.getInstance((URI)new URI(uri), (boolean)true));
                                }
                            }
                            catch (CrudServiceException e) {
                                Activator.handleError(e, "Couldn't get the TG-Object: " + uri, new Object[0]);
                            }
                            catch (URISyntaxException e) {
                                Activator.handleError(e, "Couldn't get the TG-Object: " + uri, new Object[0]);
                            }
                            ++n;
                        }
                        images_j = new UIJob("Exporting image objects..."){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                ExportImageLinkEditorFileCombinationDialog.exportObjects(ExportImageLinkEditorFileCombinationDialog.this.imagesTarget, objects.toArray(new TextGridObject[0]));
                                return Status.OK_STATUS;
                            }
                        };
                        images_j.schedule();
                    }
                    try {
                        if (xml_j != null) {
                            xml_j.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    try {
                        if (images_j != null) {
                            images_j.join();
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                    ExportImageLinkEditorFileCombinationDialog.this.updateSelectedLinksObjectAndExport();
                    return Status.OK_STATUS;
                }
            };
            exportJob.setUser(true);
            exportJob.schedule();
        } else if (this.modify) {
            this.modifySelectedLinksObjectManuallyAndExport();
        } else {
            ExportImageLinkEditorFileCombinationDialog.exportObjects(this.linksObjectTarget, this.selectedLinksObject);
        }
        super.okPressed();
    }

    private void updateSelectedLinksObjectAndExport() {
        Job updatingTGOJob = new Job("Updating and exporting..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    String[] uris;
                    monitor.beginTask("Updating the object...", 100);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IFile file = (IFile)ExportImageLinkEditorFileCombinationDialog.this.selectedLinksObject.getAdapter(IFile.class);
                    InputStream in = file.getContents(true);
                    OMElement root = new StAXOMBuilder(in).getDocumentElement();
                    root.serialize((OutputStream)baos);
                    monitor.worked(20);
                    String tree = baos.toString("UTF-8");
                    String replaceWith = "";
                    String[] stringArray = uris = ImportExportUtils.getObjectAnalyzer(ExportImageLinkEditorFileCombinationDialog.this.selectedLinksObject).getAllUris();
                    int n = uris.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String uri = stringArray[n2];
                        replaceWith = (String)uriPathMap.get(uri);
                        if (replaceWith != null && !"".equals(replaceWith)) {
                            tree = tree.replace(uri, replaceWith);
                        }
                        ++n2;
                    }
                    uriPathMap.clear();
                    final String data = tree;
                    monitor.worked(20);
                    new UIJob("Exporting the object(s)..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                ExportImageLinkEditorFileCombinationDialog.exportObjects(ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget, ExportImageLinkEditorFileCombinationDialog.this.selectedLinksObject, data.getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                Activator.handleError(e);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.worked(40);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError(e);
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        updatingTGOJob.setUser(true);
        updatingTGOJob.schedule();
    }

    private void modifySelectedLinksObjectManuallyAndExport() {
        TableItem[] selectedObjectItems = this.linksObjectEditor.getFirstTable().getTable().getItems();
        TableItem[] replaceItems = this.linksObjectEditor.getSecondTable().getTable().getItems();
        final int itemsCountFirstTable = selectedObjectItems.length;
        final int itemsCountSecondTable = replaceItems.length;
        final String[] selectedObjectItemsText = new String[itemsCountFirstTable];
        final String[] replaceItemsText = new String[itemsCountSecondTable];
        int i = 0;
        while (i < itemsCountFirstTable) {
            selectedObjectItemsText[i] = selectedObjectItems[i].getText();
            ++i;
        }
        i = 0;
        while (i < itemsCountSecondTable) {
            replaceItemsText[i] = replaceItems[i].getText();
            ++i;
        }
        Job modifyingTGOJob = new Job("Modifying and exporting..."){

            protected IStatus run(IProgressMonitor monitor) {
                if (monitor == null) {
                    monitor = new NullProgressMonitor();
                }
                try {
                    monitor.beginTask("Modifying the object...", 100);
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    IFile file = (IFile)ExportImageLinkEditorFileCombinationDialog.this.selectedLinksObject.getAdapter(IFile.class);
                    InputStream in = file.getContents(true);
                    OMElement root = new StAXOMBuilder(in).getDocumentElement();
                    root.serialize((OutputStream)baos);
                    monitor.worked(20);
                    String tree = baos.toString("UTF-8");
                    String first = "";
                    String replaceWith = "";
                    int i = 0;
                    while (i < itemsCountFirstTable && i < itemsCountSecondTable) {
                        first = ExportImageLinkEditorFileCombinationDialog.this.linksObjectEditor.getObjectUriFromTable1(selectedObjectItemsText[i]);
                        replaceWith = ExportImageLinkEditorFileCombinationDialog.this.linksObjectEditor.getObjectUriFromTable2(replaceItemsText[i]);
                        tree = tree.replace(first, replaceWith);
                        ++i;
                    }
                    final String data = tree;
                    monitor.worked(20);
                    new UIJob("Exporting the object(s)..."){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                ExportImageLinkEditorFileCombinationDialog.exportObjects(ExportImageLinkEditorFileCombinationDialog.this.linksObjectTarget, ExportImageLinkEditorFileCombinationDialog.this.selectedLinksObject, data.getBytes("UTF-8"));
                            }
                            catch (UnsupportedEncodingException e) {
                                Activator.handleError(e);
                                return Status.CANCEL_STATUS;
                            }
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                    monitor.worked(40);
                    monitor.done();
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Activator.handleError(e);
                }
                catch (UnsupportedEncodingException e) {
                    Activator.handleError(e);
                }
                catch (Exception e) {
                    Activator.handleError(e);
                }
                return Status.CANCEL_STATUS;
            }
        };
        modifyingTGOJob.setUser(true);
        modifyingTGOJob.schedule();
    }

    public static void exportObjects(String targetPath, TextGridObject ... textGridObjects) {
        if (targetPath == null) {
            return;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        ExportRunnable exportRunnable = new ExportRunnable(targetPath, textGridObjects);
        try {
            progressService.run(true, true, (IRunnableWithProgress)exportRunnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)e.getCause()).getStatus(), 3);
            }
        }
        catch (InterruptedException e) {
            Activator.handleWarning(e, "Export cancelled.", new Object[0]);
        }
        if (exportRunnable.status.getSeverity() < 2) {
            StatusManager.getManager().handle((IStatus)new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, exportRunnable.status.getChildren(), "Export finished.", null));
        }
    }

    public static void exportObjects(String targetPath, TextGridObject textGridObject, byte[] data) {
        if (targetPath == null) {
            return;
        }
        IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
        ExportRunnable exportRunnable = new ExportRunnable(targetPath, textGridObject, data);
        try {
            progressService.run(true, true, (IRunnableWithProgress)exportRunnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                StatusManager.getManager().handle(((CoreException)e.getCause()).getStatus(), 3);
            }
        }
        catch (InterruptedException e) {
            Activator.handleWarning(e, "Export cancelled.", new Object[0]);
        }
        if (exportRunnable.status.getSeverity() < 2) {
            StatusManager.getManager().handle((IStatus)new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, exportRunnable.status.getChildren(), "Export finished.", null));
        }
    }

    private static class ExportRunnable
    implements IRunnableWithProgress {
        private String targetPath;
        private TextGridObject[] textGridObjects;
        private byte[] data = null;
        private MultiStatus status = new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, "One or more errors occured while exporting files from the TextGridRep.", null);

        public ExportRunnable(String targetPath, TextGridObject[] textGridObjects) {
            this.targetPath = targetPath;
            this.textGridObjects = textGridObjects;
        }

        public ExportRunnable(String targetPath, TextGridObject textGridObject, byte[] data) {
            this.targetPath = targetPath;
            this.textGridObjects = new TextGridObject[]{textGridObject};
            this.data = data;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)MessageFormat.format("Exporting to {0} ...", this.targetPath), (int)(10 + 100 * this.textGridObjects.length));
            File targetDir = new File(this.targetPath);
            if (!targetDir.isDirectory() && !targetDir.mkdirs()) {
                throw new InvocationTargetException(new IOException(MessageFormat.format("Failed to create the target directory {0}", targetDir)));
            }
            progress.worked(10);
            TextGridObject[] textGridObjectArray = this.textGridObjects;
            int n = this.textGridObjects.length;
            int n2 = 0;
            while (n2 < n) {
                TextGridObject textGridObject = textGridObjectArray[n2];
                if (progress.isCanceled()) {
                    throw new InterruptedException("Cancelled on user request.");
                }
                progress.subTask(MessageFormat.format("Exporting {0} ...", textGridObject));
                IFile file = (IFile)AdapterUtils.getAdapter((Object)textGridObject, IFile.class);
                progress.worked(10);
                try {
                    File targetFile = new File(targetDir, textGridObject.getURIBasedName());
                    uriPathMap.put(textGridObject.getURI().toString(), targetFile.toURI().toString());
                    progress.subTask(MessageFormat.format("Exporting {0} ...", textGridObject));
                    if (this.data != null) {
                        try (FileOutputStream fOut = null;){
                            fOut = new FileOutputStream(targetFile);
                            fOut.write(this.data);
                            fOut.flush();
                        }
                    } else {
                        IFileStore remoteStore = EFS.getStore((URI)file.getLocationURI());
                        IFileStore localStore = EFS.getLocalFileSystem().fromLocalFile(targetFile);
                        progress.worked(10);
                        remoteStore.copy(localStore, 2, (IProgressMonitor)progress.newChild(70));
                    }
                    if (progress.isCanceled()) {
                        throw new InterruptedException("Cancelled on user request");
                    }
                    File metaFile = new File(targetDir, "." + textGridObject.getURIBasedName().concat(".meta"));
                    BufferedOutputStream metaStream = new BufferedOutputStream(new FileOutputStream(metaFile));
                    textGridObject.getMetadataXML().serialize((OutputStream)metaStream);
                    metaStream.close();
                    progress.worked(10);
                    this.status.add((IStatus)new Status(0, "info.textgrid.lab.linkeditor.controller", MessageFormat.format("Successfully exported {0} to {1}.", textGridObject, targetFile)));
                }
                catch (CoreException e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                catch (FileNotFoundException e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                catch (IOException e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                catch (Exception e) {
                    this.status.add(this.exportFailed(e, textGridObject));
                }
                ++n2;
            }
            if (this.status.getSeverity() >= 2) {
                throw new InvocationTargetException(new CoreException((IStatus)this.status));
            }
        }

        private IStatus exportFailed(Throwable e, TextGridObject textGridObject) {
            if (e instanceof CoreException) {
                CoreException ce = (CoreException)e;
                return new MultiStatus("info.textgrid.lab.linkeditor.controller", 0, new IStatus[]{ce.getStatus()}, MessageFormat.format("Failed to export {0}.", textGridObject), e);
            }
            return new Status(4, "info.textgrid.lab.linkeditor.controller", MessageFormat.format("Failed to export {0}", textGridObject), e);
        }
    }
}

