/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search.ui.newsearch;

import info.textgrid.lab.search.ui.Activator;
import info.textgrid.lab.search.ui.newsearch.Messages;
import info.textgrid.lab.search.ui.newsearch.MetadataMainArea;
import info.textgrid.lab.search.ui.views.SearchView;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;

public class MetadataMainAreaLine {
    private MetadataMainArea metaDataMainArea;
    private ComboViewer metadataViewer;
    private ArrayList<Text> textList = new ArrayList();
    private RowData rdText;
    private Composite mainComposite;
    private ScrolledComposite scrolledComposite;
    private Label deleteImage;
    private static final ArrayList<String> standardMetadataList = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(Messages.MetadataMainAreaLine_DataContributor);
            this.add(Messages.MetadataMainAreaLine_Identifier);
            this.add(Messages.MetadataMainAreaLine_Notes);
            this.add(Messages.MetadataMainAreaLine_Project);
            this.add(Messages.MetadataMainAreaLine_RightsHolder);
            this.add(Messages.MetadataMainAreaLine_TextGridURI);
            this.add(Messages.MetadataMainAreaLine_Agent);
            this.add(Messages.MetadataMainAreaLine_Title);
        }
    };
    public static final HashMap<String, String> standardMetadataMap = new HashMap();
    private static ArrayList<String> dynamicMetadataList = new ArrayList();
    public static HashMap<String, String> dynamicMetadataMap = new HashMap();

    MetadataMainAreaLine(MetadataMainArea metaDataMainArea, Composite composite, ScrolledComposite scrolledComposite, Boolean firstLine) {
        standardMetadataMap.put(Messages.MetadataMainAreaLine_DataContributor, "dataContributor");
        standardMetadataMap.put(Messages.MetadataMainAreaLine_Identifier, "identifier");
        standardMetadataMap.put(Messages.MetadataMainAreaLine_Notes, "notes");
        standardMetadataMap.put(Messages.MetadataMainAreaLine_Project, "project.value");
        standardMetadataMap.put(Messages.MetadataMainAreaLine_RightsHolder, "rightsHolder");
        standardMetadataMap.put(Messages.MetadataMainAreaLine_TextGridURI, "textgridUri");
        standardMetadataMap.put(Messages.MetadataMainAreaLine_Agent, "edition.agent.value");
        standardMetadataMap.put(Messages.MetadataMainAreaLine_Title, "title");
        this.metaDataMainArea = metaDataMainArea;
        this.mainComposite = composite;
        this.scrolledComposite = scrolledComposite;
        RowLayout rl = new RowLayout();
        rl.wrap = false;
        MetadataMainAreaLine.initDynamicLists();
        composite.setLayout((Layout)rl);
        this.metadataViewer = new ComboViewer(composite);
        this.metadataViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.metadataViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.metadataViewer.setInput(standardMetadataList);
        if (firstLine.booleanValue()) {
            this.metadataViewer.getCombo().select(standardMetadataMap.size() - 1);
        } else {
            this.metadataViewer.getCombo().select(standardMetadataMap.size() - 3);
        }
        GridDataFactory.defaultsFor((Control)this.metadataViewer.getControl());
        if (!firstLine.booleanValue()) {
            this.metadataViewer.getControl().setEnabled(false);
        }
        this.rdText = new RowData();
        this.rdText.width = 100;
        this.addText(composite, firstLine);
        this.addLabel(composite);
        this.addText(composite, false);
        this.addImageLabel(composite, true);
        new Label(composite, 256);
    }

    private void addText(Composite composite, Boolean enabled) {
        final Text text = new Text(composite, 2052);
        text.setLayoutData((Object)this.rdText);
        text.setEnabled(enabled.booleanValue());
        if (!enabled.booleanValue()) {
            text.setBackground(Display.getDefault().getSystemColor(22));
        } else {
            text.setBackground(null);
        }
        this.textList.add(text);
        text.addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 13) {
                    IViewPart searchView = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("info.textgrid.lab.search.views.SearchView");
                    ((SearchView)searchView).startAdvancedSearch();
                    return;
                }
                Text nextText = (Text)MetadataMainAreaLine.this.textList.get(MetadataMainAreaLine.this.textList.indexOf(text) + 1);
                if (!nextText.isEnabled()) {
                    nextText.setEnabled(true);
                    nextText.setBackground(null);
                    Boolean visible = MetadataMainAreaLine.this.deleteImage.isVisible();
                    MetadataMainAreaLine.this.deleteImage.dispose();
                    MetadataMainAreaLine.this.addLabel(nextText.getParent());
                    MetadataMainAreaLine.this.addText(nextText.getParent(), false);
                    MetadataMainAreaLine.this.addImageLabel(nextText.getParent(), visible);
                    MetadataMainAreaLine nextLine = MetadataMainAreaLine.this.metaDataMainArea.getNextLine(MetadataMainAreaLine.this);
                    if (nextLine != null) {
                        if (!nextLine.getComboViewer().getControl().isEnabled()) {
                            nextLine.getComboViewer().getControl().setEnabled(true);
                            ArrayList<Text> nextLineTextArray = nextLine.getTextList();
                            nextLineTextArray.get(0).setEnabled(true);
                            nextLineTextArray.get(0).setBackground(null);
                        }
                    } else {
                        MetadataMainAreaLine newLine = MetadataMainAreaLine.this.metaDataMainArea.addLine();
                        newLine.getComboViewer().getControl().setEnabled(true);
                        ArrayList<Text> newLineTextArray = newLine.getTextList();
                        newLineTextArray.get(0).setEnabled(true);
                        newLineTextArray.get(0).setBackground(null);
                    }
                    MetadataMainAreaLine.this.refreshMainComposite();
                }
            }
        });
    }

    private void addLabel(Composite composite) {
        new Label(composite, 16384).setText(Messages.MetadataMainAreaLine_OrLabel);
    }

    private void addImageLabel(Composite composite, Boolean visible) {
        this.deleteImage = new Label(composite, 16384);
        this.deleteImage.setImage(Activator.getDefault().getImageRegistry().get("roundclose"));
        this.deleteImage.setVisible(visible.booleanValue());
        this.deleteImage.addMouseListener(new MouseListener(){

            public void mouseDoubleClick(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                MetadataMainAreaLine.this.metaDataMainArea.removeLine(MetadataMainAreaLine.this);
            }

            public void mouseUp(MouseEvent e) {
            }
        });
    }

    public ComboViewer getComboViewer() {
        return this.metadataViewer;
    }

    public ArrayList<Text> getTextList() {
        return this.textList;
    }

    public Composite getMainComposite() {
        return this.mainComposite;
    }

    private void refreshMainComposite() {
        this.mainComposite.getParent().layout();
        this.mainComposite.getParent().getParent().layout();
        this.mainComposite.getParent().getParent().getParent().layout();
        this.scrolledComposite.setMinSize(this.scrolledComposite.getContent().computeSize(-1, -1));
    }

    public Label getDeleteImage() {
        return this.deleteImage;
    }

    public static void initDynamicLists() {
        dynamicMetadataList.clear();
        dynamicMetadataMap.clear();
        for (String element : standardMetadataList) {
            dynamicMetadataList.add(element);
            dynamicMetadataMap.put(element, standardMetadataMap.get(element));
        }
    }

    public void initMetadataViewer() {
        this.metadataViewer.setInput(dynamicMetadataList);
        if (!dynamicMetadataList.isEmpty()) {
            this.metadataViewer.getCombo().select(dynamicMetadataList.size() - 1);
        }
    }

    public static void addMetadataItem(String name, String type, String project) {
        String key = String.valueOf(name) + " [" + project + "]";
        dynamicMetadataList.add(key);
        dynamicMetadataMap.put(key, name);
    }
}

