/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.ui.core.utils;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.core.swtutils.DeferredListContentProvider;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.utils.Messages;
import info.textgrid.lab.ui.core.utils.TGODefaultLabelProvider;
import info.textgrid.lab.ui.core.utils.UpdatingDeferredListContentProvider;
import java.text.SimpleDateFormat;
import java.util.EnumMap;
import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceColors;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.progress.PendingUpdateAdapter;
import org.eclipse.ui.statushandlers.StatusManager;

public class TextGridObjectTableViewer
extends TableViewer {
    private EnumSet<Column> visibleColumns;
    private final EnumMap<Column, TableViewerColumn> columns = Maps.newEnumMap(Column.class);
    private UpdatingDeferredListContentProvider defaultContentProvider;
    private TextGridObject[] defaultSelection = null;
    public static final StyledString.Styler ERROR_STYLER = new StyledString.Styler(){

        public void applyStyles(TextStyle textStyle) {
            textStyle.foreground = JFaceColors.getErrorText((Display)Display.getCurrent());
            textStyle.background = JFaceColors.getErrorBackground((Display)Display.getCurrent());
        }
    };
    private ColumnComparator comparator;

    public TableViewerColumn getColumn(Column column) {
        return this.columns.get((Object)column);
    }

    public void setVisibleColumns(EnumSet<Column> columnsToShow) {
        this.visibleColumns = columnsToShow;
        Column[] columnArray = Column.values();
        int n = columnArray.length;
        int n2 = 0;
        while (n2 < n) {
            Column column = columnArray[n2];
            TableViewerColumn tableViewerColumn = this.columns.get((Object)column);
            if (tableViewerColumn != null) {
                TableColumn tableColumn = tableViewerColumn.getColumn();
                if (columnsToShow.contains((Object)column)) {
                    Object data = tableColumn.getData("defaultwidth");
                    int width = data != null && data instanceof Integer ? (Integer)data : (column.equals((Object)Column.WARNING) ? 800 : 200);
                    tableColumn.setWidth(width);
                    tableColumn.setResizable(true);
                } else {
                    int width = tableColumn.getWidth();
                    if (width > 0) {
                        tableColumn.setData("defaultwidth", (Object)width);
                    }
                    tableColumn.setWidth(0);
                    tableColumn.setResizable(false);
                }
            }
            ++n2;
        }
        this.comparator.activate((Column)((Object)this.visibleColumns.iterator().next()));
    }

    public TextGridObjectTableViewer(Composite parent, int style) {
        super(parent, style);
        this.init();
    }

    public UpdatingDeferredListContentProvider getDefaultContentProvider() {
        return this.defaultContentProvider;
    }

    public void setDefaultSelection(TextGridObject ... defaultSelection) {
        this.defaultSelection = defaultSelection;
    }

    protected void init() {
        this.initColumns();
        this.defaultContentProvider = new UpdatingDeferredListContentProvider(TextGridObject.class);
        this.defaultContentProvider.addDoneListener(new DeferredListContentProvider.IDoneListener(){

            public void loadDone(Viewer viewer) {
                if (viewer == TextGridObjectTableViewer.this && TextGridObjectTableViewer.this.getContentProvider() == TextGridObjectTableViewer.this.defaultContentProvider && TextGridObjectTableViewer.this.defaultSelection != null && TextGridObjectTableViewer.this.getSelection().isEmpty()) {
                    TextGridObjectTableViewer.this.setSelection((ISelection)new StructuredSelection((Object[])TextGridObjectTableViewer.this.defaultSelection), true);
                }
            }
        });
        this.setContentProvider(this.defaultContentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
    }

    protected void initColumns() {
        TableViewerColumn revisionColumn = new TableViewerColumn((TableViewer)this, 0);
        revisionColumn.getColumn().setText("Revision");
        revisionColumn.getColumn().setWidth(50);
        revisionColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return null;
                }
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (textGridObject != null) {
                    return textGridObject.getRevisionNumber();
                }
                return null;
            }
        });
        this.columns.put(Column.REVISION, revisionColumn);
        TableViewerColumn titleColumn = new TableViewerColumn((TableViewer)this, 0);
        titleColumn.getColumn().setText(Messages.TextGridObjectTableViewer_Title);
        titleColumn.getColumn().setWidth(200);
        titleColumn.setLabelProvider((CellLabelProvider)new TGODefaultLabelProvider(true));
        this.columns.put(Column.TITLE, titleColumn);
        TableViewerColumn projectColumn = new TableViewerColumn((TableViewer)this, 0);
        projectColumn.getColumn().setText(Messages.TextGridObjectTableViewer_Project);
        projectColumn.getColumn().setWidth(125);
        projectColumn.setLabelProvider((CellLabelProvider)new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new TGOProjectLabelProvider()));
        this.columns.put(Column.PROJECT, projectColumn);
        TableViewerColumn authorsColumn = new TableViewerColumn((TableViewer)this, 0);
        authorsColumn.getColumn().setText(Messages.TextGridObjectTableViewer_Author);
        authorsColumn.getColumn().setWidth(150);
        authorsColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return null;
                }
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (textGridObject != null) {
                    try {
                        return Joiner.on((String)", ").join((Iterable)textGridObject.getAuthors());
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
                    }
                }
                return null;
            }
        });
        this.columns.put(Column.AUTHORS, authorsColumn);
        TableViewerColumn ownerColumn = new TableViewerColumn((TableViewer)this, 0);
        ownerColumn.getColumn().setText(Messages.TextGridObjectTableViewer_DataContributor);
        ownerColumn.getColumn().setWidth(125);
        ownerColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return null;
                }
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (textGridObject != null) {
                    try {
                        String owner = textGridObject.getDataContributor();
                        if (owner.equals("") && TextGridObjectTableViewer.this.visibleColumns != null && TextGridObjectTableViewer.this.visibleColumns.contains((Object)Column.OWNER)) {
                            textGridObject.reloadMetadata(true);
                            owner = textGridObject.getDataContributor();
                        }
                        return owner;
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
                    }
                }
                return null;
            }
        });
        this.columns.put(Column.OWNER, ownerColumn);
        TableViewerColumn dateColumn = new TableViewerColumn((TableViewer)this, 0);
        dateColumn.getColumn().setText(Messages.TextGridObjectTableViewer_CreationDate);
        dateColumn.getColumn().setWidth(125);
        final SimpleDateFormat sdFormatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss");
        dateColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof PendingUpdateAdapter) {
                    return null;
                }
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                if (textGridObject != null) {
                    try {
                        return sdFormatter.format(textGridObject.getCreated().getTime());
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
                    }
                }
                return null;
            }
        });
        this.columns.put(Column.DATE, dateColumn);
        TableViewerColumn warningColumn = new TableViewerColumn((TableViewer)this, 0);
        warningColumn.getColumn().setText(Messages.TextGridObjectTableViewer_Warning);
        warningColumn.getColumn().setWidth(800);
        warningColumn.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (TextGridObjectTableViewer.this.visibleColumns != null && TextGridObjectTableViewer.this.visibleColumns.contains((Object)Column.WARNING)) {
                    if (element instanceof PendingUpdateAdapter) {
                        return null;
                    }
                    TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
                    if (textGridObject != null) {
                        try {
                            String warning = textGridObject.getCrudWarning();
                            return warning;
                        }
                        catch (CoreException e) {
                            StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
                        }
                    }
                }
                return null;
            }
        });
        this.columns.put(Column.WARNING, warningColumn);
        this.comparator = new ColumnComparator();
        for (Column columnType : this.columns.keySet()) {
            this.comparator.registerColumn(columnType, this.columns.get((Object)columnType));
        }
        this.setComparator(this.comparator);
        this.getTable().setLinesVisible(true);
        this.getTable().setHeaderVisible(true);
    }

    public void queryMetadata(String query) {
        SearchRequest searchRequest = new SearchRequest();
        searchRequest.setQueryMetadata(query);
        this.setInput(searchRequest);
    }

    public static enum Column {
        REVISION,
        TITLE,
        PROJECT,
        AUTHORS,
        OWNER,
        DATE,
        WARNING;

    }

    protected class ColumnComparator
    extends ViewerComparator {
        private EnumMap<Column, SortColumn> sortColumns = Maps.newEnumMap(Column.class);
        private SortColumn currentColumn = null;

        protected ColumnComparator() {
        }

        public ColumnComparator registerColumn(Column columnType, TableViewerColumn viewerColumn) {
            this.sortColumns.put(columnType, new SortColumn(viewerColumn, columnType));
            return this;
        }

        public int compare(Viewer aViewer, Object e1, Object e2) {
            if (e1 instanceof PendingUpdateAdapter) {
                return -1;
            }
            if (e2 instanceof PendingUpdateAdapter) {
                return 1;
            }
            if (this.currentColumn != null) {
                return this.currentColumn.direction * this.currentColumn.getProperty(e1).compareTo(this.currentColumn.getProperty(e2));
            }
            return e1.toString().compareTo(e2.toString());
        }

        public void activate(Column column) {
            this.sortColumns.get((Object)column).activate();
        }

        private class SortColumn {
            public final TableColumn tableColumn;
            public final Table table;
            public final Column columnType;
            private int direction = 1;
            public final ColumnViewer viewer;

            public SortColumn(TableViewerColumn column, Column columnType) {
                this.columnType = columnType;
                this.tableColumn = column.getColumn();
                this.table = this.tableColumn.getParent();
                this.viewer = column.getViewer();
                this.tableColumn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (SortColumn.this.table.getSortColumn() == SortColumn.this.tableColumn) {
                            SortColumn sortColumn = SortColumn.this;
                            sortColumn.direction = sortColumn.direction * -1;
                        }
                        SortColumn.this.activate();
                        SortColumn.this.viewer.refresh();
                    }
                });
            }

            public SortColumn activate() {
                this.table.setSortColumn(this.tableColumn);
                this.table.setSortDirection(this.direction < 0 ? 128 : 1024);
                ColumnComparator.this.currentColumn = this;
                return this;
            }

            protected Comparable getProperty(Object object) {
                TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)object, TextGridObject.class);
                if (textGridObject == null) {
                    if (object != null) {
                        return object.toString();
                    }
                    return "";
                }
                try {
                    switch (this.columnType) {
                        case TITLE: {
                            return textGridObject.getTitle();
                        }
                        case AUTHORS: {
                            return Joiner.on((String)", ").join((Iterable)textGridObject.getAuthors());
                        }
                        case DATE: {
                            return textGridObject.getLastModified();
                        }
                        case OWNER: {
                            return textGridObject.getMetadataForReading().getGeneric().getGenerated().getDataContributor();
                        }
                        case PROJECT: {
                            return textGridObject.getProjectInstance().getName();
                        }
                        case REVISION: {
                            return Integer.valueOf(textGridObject.getRevisionNumber());
                        }
                        case WARNING: {
                            return textGridObject.getCrudWarning();
                        }
                    }
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
                }
                return object.toString();
            }
        }
    }

    public class TGOProjectLabelProvider
    extends BaseLabelProvider
    implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
        public Image getImage(Object element) {
            return null;
        }

        public StyledString getStyledText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return new StyledString();
            }
            TextGridObject textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)element, TextGridObject.class);
            if (textGridObject != null) {
                try {
                    TextGridProject project = textGridObject.getProjectInstance();
                    StyledString label = new StyledString(project.getName());
                    label.append(' ').append(project.getId(), StyledString.DECORATIONS_STYLER);
                    return label;
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "info.textgrid.lab.ui.core.utils");
                    return new StyledString(e.getLocalizedMessage(), ERROR_STYLER);
                }
            }
            return new StyledString(element.toString()).append(" ?", ERROR_STYLER);
        }
    }
}

