/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom;

import java.util.LinkedList;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.IWhitespacePolicyFactory;
import net.sf.vex.dom.impl.Document;
import net.sf.vex.dom.impl.Element;
import net.sf.vex.dom.impl.RootElement;
import net.sf.vex.dom.impl.SwingGapContentWrapper;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;

public class DocumentBuilder
implements ContentHandler,
LexicalHandler {
    private IWhitespacePolicyFactory policyFactory;
    private IWhitespacePolicy policy;
    private StringBuffer pendingChars = new StringBuffer();
    private boolean trimLeading = false;
    private Content content = new SwingGapContentWrapper(100);
    private LinkedList stack = new LinkedList();
    private RootElement rootElement;
    private String dtdPublicID;
    private String dtdSystemID;
    private IVexDocument doc;
    private Locator locator;

    public DocumentBuilder(IWhitespacePolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    public IVexDocument getDocument() {
        return this.doc;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        char[] chars = new char[length];
        System.arraycopy(ch, start, chars, 0, length);
        int i = 0;
        while (i < chars.length) {
            if (Character.isISOControl(chars[i]) && chars[i] != '\n' && chars[i] != '\r') {
                chars[i] = 32;
            }
            ++i;
        }
        this.pendingChars.append(chars);
    }

    @Override
    public void endDocument() {
        this.doc = new Document(this.content, this.rootElement);
        this.doc.setPublicID(this.dtdPublicID);
        this.doc.setSystemID(this.dtdSystemID);
        this.rootElement.setDocument(this.doc);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        this.appendChars(true);
        StackEntry entry = (StackEntry)this.stack.removeLast();
        this.content.insertString(this.content.getLength(), "\u0000");
        entry.element.setContent(this.content, entry.offset, this.content.getLength() - 1);
        if (this.isBlock(entry.element)) {
            this.trimLeading = true;
        }
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            Element element;
            if (this.stack.size() == 0) {
                this.rootElement = new RootElement(qName);
                element = this.rootElement;
                if (this.policyFactory != null) {
                    this.policy = this.policyFactory.getPolicy(this.dtdPublicID);
                }
            } else {
                element = new Element(qName);
                IVexElement parent = ((StackEntry)this.stack.getLast()).element;
                parent.addChild(element);
            }
            int n = attrs.getLength();
            int i = 0;
            while (i < n) {
                element.setAttribute(attrs.getQName(i), attrs.getValue(i));
                ++i;
            }
            this.appendChars(this.isBlock(element));
            this.stack.add(new StackEntry(element, this.content.getLength(), this.isPre(element)));
            this.content.insertString(this.content.getLength(), "\u0000");
            this.trimLeading = true;
        }
        catch (DocumentValidationException ex) {
            throw new SAXParseException("DocumentValidationException", this.locator, ex);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
    }

    @Override
    public void comment(char[] ch, int start, int length) {
    }

    @Override
    public void endCDATA() {
    }

    @Override
    public void endDTD() {
    }

    @Override
    public void endEntity(String name) {
    }

    @Override
    public void startCDATA() {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) {
        this.dtdPublicID = publicId;
        this.dtdSystemID = systemId;
    }

    @Override
    public void startEntity(String name) {
    }

    private void appendChars(boolean trimTrailing) {
        StringBuffer sb;
        StackEntry entry;
        StackEntry stackEntry = entry = this.stack.size() > 0 ? (StackEntry)this.stack.getLast() : null;
        if (entry != null && entry.pre) {
            sb = this.pendingChars;
        } else {
            sb = new StringBuffer(this.pendingChars.length());
            boolean ws = false;
            int i = 0;
            while (i < this.pendingChars.length()) {
                char c = this.pendingChars.charAt(i);
                if (Character.isWhitespace(c)) {
                    ws = true;
                } else {
                    if (ws) {
                        sb.append(' ');
                        ws = false;
                    }
                    sb.append(c);
                }
                ++i;
            }
            if (ws) {
                sb.append(' ');
            }
            if (this.trimLeading && sb.length() > 0 && sb.charAt(0) == ' ') {
                sb.deleteCharAt(0);
            }
            if (trimTrailing && sb.length() > 0 && sb.charAt(sb.length() - 1) == ' ') {
                sb.setLength(sb.length() - 1);
            }
        }
        this.normalizeNewlines(sb);
        this.content.insertString(this.content.getLength(), sb.toString());
        this.pendingChars.setLength(0);
        this.trimLeading = false;
    }

    private boolean isBlock(IVexElement element) {
        return this.policy != null && this.policy.isBlock(element);
    }

    private boolean isPre(IVexElement element) {
        return this.policy != null && this.policy.isPre(element);
    }

    private void normalizeNewlines(StringBuffer sb) {
        int state = 0;
        int i = 0;
        while (i < sb.length()) {
            char c = sb.charAt(i);
            switch (state) {
                case 0: {
                    if (c == '\r') {
                        state = 1;
                    }
                    ++i;
                    break;
                }
                case 1: {
                    if (c == '\n') {
                        sb.deleteCharAt(i - 1);
                        state = 0;
                        break;
                    }
                    if (c == '\r') {
                        sb.setCharAt(i - 1, '\n');
                        ++i;
                        break;
                    }
                    sb.setCharAt(i - 1, '\n');
                    ++i;
                    state = 0;
                }
            }
        }
    }

    private static class StackEntry {
        public IVexElement element;
        public int offset;
        public boolean pre;

        public StackEntry(IVexElement element, int offset, boolean pre) {
            this.element = element;
            this.offset = offset;
            this.pre = pre;
        }
    }
}

