/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import net.sf.vex.dom.DocumentBuilder;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IWhitespacePolicyFactory;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class DocumentReader {
    private boolean debugging;
    private EntityResolver entityResolver;
    private IWhitespacePolicyFactory whitespacePolicyFactory;

    public boolean isDebugging() {
        return this.debugging;
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public IWhitespacePolicyFactory getWhitespacePolicyFactory() {
        return this.whitespacePolicyFactory;
    }

    public IVexDocument read(InputStream stream) throws IOException, ParserConfigurationException, SAXException {
        return this.read(new InputSource(stream));
    }

    public IVexDocument read(URL url) throws IOException, ParserConfigurationException, SAXException {
        return this.read(new InputSource(url.toString()));
    }

    public IVexDocument read(String s) throws IOException, ParserConfigurationException, SAXException {
        CharArrayReader reader = new CharArrayReader(s.toCharArray());
        return this.read(new InputSource(reader));
    }

    public IVexDocument read(InputSource is) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilder builder;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(false);
        XMLReader xmlReader = factory.newSAXParser().getXMLReader();
        ContentHandler contentHandler = builder = new DocumentBuilder(this.getWhitespacePolicyFactory());
        LexicalHandler lexicalHandler = builder;
        if (this.isDebugging()) {
            Object proxy = Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ContentHandler.class, LexicalHandler.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    try {
                        return method.invoke((Object)builder, args);
                    }
                    catch (InvocationTargetException ex) {
                        ex.getCause().printStackTrace();
                        throw ex.getCause();
                    }
                }
            });
            contentHandler = (ContentHandler)proxy;
            lexicalHandler = (LexicalHandler)proxy;
        }
        xmlReader.setContentHandler(contentHandler);
        xmlReader.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
        if (this.getEntityResolver() != null) {
            xmlReader.setEntityResolver(this.getEntityResolver());
        }
        xmlReader.parse(is);
        IVexDocument document = builder.getDocument();
        document.setWhitespacePolicy(this.getWhitespacePolicyFactory().getPolicy(document.getPublicID()));
        return document;
    }

    public void setDebugging(boolean debugging) {
        this.debugging = debugging;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setWhitespacePolicyFactory(IWhitespacePolicyFactory whitespacePolicyFactory) {
        this.whitespacePolicyFactory = whitespacePolicyFactory;
    }
}

