/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import net.sf.vex.dom.AttributeDefinition;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.TextWrapper;
import net.sf.vex.dom.Validator;

public class DocumentWriter {
    private IWhitespacePolicy whitespacePolicy;
    private String indent = "  ";
    private int wrapColumn = 572;

    public static String escape(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '<') {
                sb.append("&lt;");
            } else if (c == '>') {
                sb.append("&gt;");
            } else if (c == '&') {
                sb.append("&amp;");
            } else if (c == '\"') {
                sb.append("&quot;");
            } else if (c == '\'') {
                sb.append("&apos;");
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    public String getIndent() {
        return this.indent;
    }

    public IWhitespacePolicy getWhitespacePolicy() {
        return this.whitespacePolicy;
    }

    public int getWrapColumn() {
        return this.wrapColumn;
    }

    public void setIndent(String indent) {
        this.indent = indent;
    }

    public void setWhitespacePolicy(IWhitespacePolicy whitespacePolicy) {
        this.whitespacePolicy = whitespacePolicy;
    }

    public void setWrapColumn(int wrapColumn) {
        this.wrapColumn = wrapColumn;
    }

    public void write(IVexDocument doc, OutputStream os) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(os, "UTF-8");
        PrintWriter pw = new PrintWriter(osw);
        pw.println("<?xml version='1.0'?>");
        if (doc.getSystemID() != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("<!DOCTYPE ");
            sb.append(doc.getRootElement().getName());
            if (doc.getPublicID() != null) {
                sb.append(" PUBLIC");
                sb.append(" \"");
                sb.append(doc.getPublicID());
                sb.append("\"");
            } else {
                sb.append(" SYSTEM");
            }
            sb.append(" \"");
            sb.append(doc.getSystemID());
            sb.append("\">");
            pw.println(sb.toString());
        }
        this.writeNode(doc.getRootElement(), pw, "");
        pw.flush();
    }

    private void writeNode(IVexNode node, PrintWriter pw, String indent) {
        if (node instanceof IVexText) {
            TextWrapper wrapper = new TextWrapper();
            wrapper.add(DocumentWriter.escape(node.getText()));
            String[] lines = wrapper.wrap(this.wrapColumn - indent.length());
            int i = 0;
            while (i < lines.length) {
                pw.print(indent);
                pw.println(lines[i]);
                ++i;
            }
        } else {
            IVexElement element = (IVexElement)node;
            if (this.whitespacePolicy != null && this.whitespacePolicy.isPre(element)) {
                pw.print(indent);
                this.writeNodeNoWrap(node, pw);
                pw.println();
                return;
            }
            boolean hasBlockChild = false;
            IVexElement[] children = element.getChildElements();
            int i = 0;
            while (i < children.length) {
                if (this.whitespacePolicy != null && this.whitespacePolicy.isBlock(children[i])) {
                    hasBlockChild = true;
                    break;
                }
                ++i;
            }
            if (hasBlockChild) {
                pw.print(indent);
                pw.print("<");
                pw.print(element.getName());
                TextWrapper wrapper = new TextWrapper();
                wrapper.addNoSplit(this.getAttributeString(element));
                int outdent = indent.length() + 1 + element.getName().length();
                String[] lines = wrapper.wrap(this.wrapColumn - outdent);
                char[] bigIndent = new char[outdent];
                Arrays.fill(bigIndent, ' ');
                int i2 = 0;
                while (i2 < lines.length) {
                    if (i2 > 0) {
                        pw.print(bigIndent);
                    }
                    pw.print(lines[i2]);
                    if (i2 < lines.length - 1) {
                        pw.println();
                    }
                    ++i2;
                }
                pw.println(">");
                pw.println();
                String childIndent = String.valueOf(indent) + this.indent;
                IVexNode[] content = element.getChildNodes();
                int i3 = 0;
                while (i3 < content.length) {
                    this.writeNode(content[i3], pw, childIndent);
                    ++i3;
                }
                pw.print(indent);
                pw.print("</");
                pw.print(element.getName());
                pw.println(">");
                pw.println();
            } else {
                TextWrapper wrapper = new TextWrapper();
                this.addNode(element, wrapper);
                String[] lines = wrapper.wrap(this.wrapColumn - indent.length());
                int i4 = 0;
                while (i4 < lines.length) {
                    pw.print(indent);
                    pw.println(lines[i4]);
                    ++i4;
                }
                if (this.whitespacePolicy != null && this.whitespacePolicy.isBlock(element)) {
                    pw.println();
                }
            }
        }
    }

    private void writeNodeNoWrap(IVexNode node, PrintWriter pw) {
        if (node instanceof IVexText) {
            pw.print(DocumentWriter.escape(node.getText()));
        } else {
            IVexElement element = (IVexElement)node;
            pw.print("<");
            pw.print(element.getName());
            pw.print(this.getAttributeString(element));
            pw.print(">");
            IVexNode[] content = element.getChildNodes();
            int i = 0;
            while (i < content.length) {
                this.writeNodeNoWrap(content[i], pw);
                ++i;
            }
            pw.print("</");
            pw.print(element.getName());
            pw.print(">");
        }
    }

    private String attrToString(String name, String value) {
        StringBuffer sb = new StringBuffer();
        sb.append(" ");
        sb.append(name);
        sb.append("=\"");
        sb.append(DocumentWriter.escape(value));
        sb.append("\"");
        return sb.toString();
    }

    private void addNode(IVexNode node, TextWrapper wrapper) {
        if (node instanceof IVexText) {
            wrapper.add(DocumentWriter.escape(node.getText()));
        } else {
            IVexElement element = (IVexElement)node;
            IVexNode[] content = element.getChildNodes();
            Object[] attrs = element.getAttributeNames();
            Arrays.sort(attrs);
            if (attrs.length == 0) {
                if (content.length == 0) {
                    wrapper.add("<" + element.getName() + " />");
                } else {
                    wrapper.add("<" + element.getName() + ">");
                }
            } else {
                Validator validator = element.getDocument().getValidator();
                StringBuffer sb = new StringBuffer();
                int i = 0;
                while (i < attrs.length) {
                    sb.setLength(0);
                    if (i == 0) {
                        sb.append("<" + element.getName());
                    }
                    if (!DocumentWriter.attrHasDefaultValue(validator, element, (String)attrs[i])) {
                        sb.append(this.attrToString((String)attrs[i], element.getAttribute((String)attrs[i])));
                    }
                    if (i == attrs.length - 1) {
                        if (content.length == 0) {
                            sb.append("/>");
                        } else {
                            sb.append(">");
                        }
                    }
                    wrapper.addNoSplit(sb.toString());
                    ++i;
                }
            }
            int i = 0;
            while (i < content.length) {
                this.addNode(content[i], wrapper);
                ++i;
            }
            if (content.length > 0) {
                wrapper.add("</" + element.getName() + ">");
            }
        }
    }

    private String getAttributeString(IVexElement element) {
        Validator validator = element.getDocument().getValidator();
        Object[] attrs = element.getAttributeNames();
        Arrays.sort(attrs);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < attrs.length) {
            if (!DocumentWriter.attrHasDefaultValue(validator, element, (String)attrs[i])) {
                sb.append(" ");
                sb.append((String)attrs[i]);
                sb.append("=\"");
                sb.append(DocumentWriter.escape(element.getAttribute((String)attrs[i])));
                sb.append("\"");
            }
            ++i;
        }
        return sb.toString();
    }

    private static boolean attrHasDefaultValue(Validator validator, IVexElement element, String attribute) {
        AttributeDefinition ad;
        if (validator != null && (ad = validator.getAttributeDefinition(element.getName(), attribute)) != null) {
            String value = element.getAttribute(attribute);
            String defaultValue = ad.getDefaultValue();
            return value != null && value.equals(defaultValue);
        }
        return false;
    }
}

