/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.dom.impl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import net.sf.vex.core.ListenerList;
import net.sf.vex.dom.Content;
import net.sf.vex.dom.DocumentEvent;
import net.sf.vex.dom.DocumentListener;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexDocumentFragment;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexRootElement;
import net.sf.vex.dom.IVexText;
import net.sf.vex.dom.IWhitespacePolicy;
import net.sf.vex.dom.Position;
import net.sf.vex.dom.Validator;
import net.sf.vex.dom.impl.DocumentFragment;
import net.sf.vex.dom.impl.Element;
import net.sf.vex.dom.impl.RootElement;
import net.sf.vex.dom.impl.SwingGapContentWrapper;
import net.sf.vex.dom.impl.Text;
import net.sf.vex.dom.impl.WrongModelException;
import net.sf.vex.undo.IUndoableEdit;

public class Document
implements IVexDocument {
    private String cssfile_location;
    private Content content;
    private IVexRootElement rootElement;
    private ListenerList listeners = new ListenerList(DocumentListener.class, DocumentEvent.class);
    private boolean undoEnabled = true;
    private String publicID;
    private String systemID;
    private String encoding;
    private Validator validator;
    private IWhitespacePolicy whitespacePolicy;

    protected ListenerList getListeners() {
        return this.listeners;
    }

    public Document(IVexRootElement rootElement) {
        this.content = new SwingGapContentWrapper(100);
        this.setRootElement(rootElement);
        rootElement.setDocument(this);
        this.content.insertString(0, "\u0000\u0000");
        rootElement.setContent(this.content, 0, 1);
    }

    public Document(Content content, RootElement rootElement) {
        this.content = content;
        this.setRootElement(rootElement);
    }

    @Override
    public void addDocumentListener(DocumentListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public boolean canInsertFragment(int offset, IVexDocumentFragment fragment) {
        if (this.validator == null) {
            return true;
        }
        IVexElement element = this.getElementAt(offset);
        String[] seq1 = this.getNodeNames(element.getStartOffset() + 1, offset);
        String[] seq2 = fragment.getNodeNames();
        String[] seq3 = this.getNodeNames(offset, element.getEndOffset());
        return this.validator.isValidSequence(element.getName(), seq1, seq2, seq3, true);
    }

    @Override
    public boolean canInsertText(int offset) {
        if (this.validator == null) {
            return true;
        }
        IVexElement element = this.getElementAt(offset);
        String[] seq1 = this.getNodeNames(element.getStartOffset() + 1, offset);
        String[] seq2 = new String[]{"#PCDATA"};
        String[] seq3 = this.getNodeNames(offset, element.getEndOffset());
        return this.validator.isValidSequence(element.getName(), seq1, seq2, seq3, true);
    }

    @Override
    public Position createPosition(int offset) {
        return this.content.createPosition(offset);
    }

    @Override
    public void delete(int startOffset, int endOffset) throws DocumentValidationException {
        IVexElement e2;
        IVexElement e1 = this.getElementAt(startOffset);
        if (e1 != (e2 = this.getElementAt(endOffset))) {
            throw new IllegalArgumentException("Deletion from " + startOffset + " to " + endOffset + " is unbalanced");
        }
        Validator validator = this.getValidator();
        if (validator != null) {
            String[] seq1 = this.getNodeNames(e1.getStartOffset() + 1, startOffset);
            String[] seq2 = this.getNodeNames(endOffset, e1.getEndOffset());
            if (!validator.isValidSequence(e1.getName(), seq1, seq2, null, true)) {
                throw new DocumentValidationException("Unable to delete from " + startOffset + " to " + endOffset);
            }
        }
        IVexDocumentFragment frag = this.getFragment(startOffset, endOffset);
        this.fireBeforeContentDeleted(new DocumentEvent(this, e1, startOffset, endOffset - startOffset, null));
        Iterator iter = e1.getChildIterator();
        while (iter.hasNext()) {
            IVexElement child = (IVexElement)iter.next();
            if (startOffset > child.getStartOffset() || child.getEndOffset() >= endOffset) continue;
            iter.remove();
        }
        this.content.remove(startOffset, endOffset - startOffset);
        DeleteEdit edit = this.undoEnabled ? new DeleteEdit(startOffset, endOffset, frag) : null;
        this.fireContentDeleted(new DocumentEvent(this, e1, startOffset, endOffset - startOffset, edit));
    }

    @Override
    public IVexElement findCommonElement(int offset1, int offset2) {
        boolean tryAgain;
        IVexElement element = this.getRootElement();
        block0: do {
            tryAgain = false;
            IVexElement[] children = element.getChildElements();
            int i = 0;
            while (i < children.length) {
                if (offset1 > children[i].getStartOffset() && offset2 > children[i].getStartOffset() && offset1 <= children[i].getEndOffset() && offset2 <= children[i].getEndOffset()) {
                    element = children[i];
                    tryAgain = true;
                    continue block0;
                }
                ++i;
            }
        } while (tryAgain);
        return element;
    }

    @Override
    public char getCharacterAt(int offset) {
        return this.content.getString(offset, 1).charAt(0);
    }

    @Override
    public IVexElement getElementAt(int offset) {
        boolean tryAgain;
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Illegal offset: " + offset + ". Must be between 1 and " + this.getLength());
        }
        IVexElement element = this.getRootElement();
        block0: do {
            tryAgain = false;
            IVexElement[] children = element.getChildElements();
            int i = 0;
            while (i < children.length) {
                IVexElement child = children[i];
                if (offset <= child.getStartOffset()) {
                    return element;
                }
                if (offset <= child.getEndOffset()) {
                    element = child;
                    tryAgain = true;
                    continue block0;
                }
                ++i;
            }
        } while (tryAgain);
        return element;
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public IVexDocumentFragment getFragment(int startOffset, int endOffset) {
        IVexElement e2;
        Document.assertOffset(startOffset, 0, this.content.getLength());
        Document.assertOffset(endOffset, 0, this.content.getLength());
        if (endOffset <= startOffset) {
            throw new IllegalArgumentException("Invalid range (" + startOffset + ", " + endOffset + ")");
        }
        IVexElement e1 = this.getElementAt(startOffset);
        if (e1 != (e2 = this.getElementAt(endOffset))) {
            throw new IllegalArgumentException("Fragment from " + startOffset + " to " + endOffset + " is unbalanced");
        }
        IVexElement[] children = e1.getChildElements();
        SwingGapContentWrapper newContent = new SwingGapContentWrapper(endOffset - startOffset);
        String s = this.content.getString(startOffset, endOffset - startOffset);
        newContent.insertString(0, s);
        ArrayList<IVexElement> newChildren = new ArrayList<IVexElement>();
        int i = 0;
        while (i < children.length) {
            IVexElement child = children[i];
            if (child.getEndOffset() > startOffset) {
                if (child.getStartOffset() >= endOffset) break;
                newChildren.add(this.cloneElement(child, newContent, -startOffset, null));
            }
            ++i;
        }
        IVexElement[] elementArray = newChildren.toArray(new IVexElement[newChildren.size()]);
        return new DocumentFragment(newContent, elementArray);
    }

    @Override
    public int getLength() {
        return this.content.getLength();
    }

    @Override
    public String[] getNodeNames(int startOffset, int endOffset) {
        IVexNode[] nodes = this.getNodes(startOffset, endOffset);
        String[] names = new String[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            IVexNode node = nodes[i];
            names[i] = node instanceof IVexElement ? ((IVexElement)node).getName() : "#PCDATA";
            ++i;
        }
        return names;
    }

    @Override
    public IVexNode[] getNodes(int startOffset, int endOffset) {
        IVexElement element = this.getElementAt(startOffset);
        if (element != this.getElementAt(endOffset)) {
            throw new IllegalArgumentException("Offsets are unbalanced: " + startOffset + " is in " + element.getName() + ", " + endOffset + " is in " + this.getElementAt(endOffset).getName());
        }
        ArrayList<IVexNode> list = new ArrayList<IVexNode>();
        IVexNode[] nodes = element.getChildNodes();
        int i = 0;
        while (i < nodes.length) {
            IVexNode node = nodes[i];
            if (node.getEndOffset() > startOffset) {
                if (node.getStartOffset() >= endOffset) break;
                if (node instanceof IVexElement) {
                    list.add(node);
                } else {
                    IVexText text = (IVexText)node;
                    if (text.getStartOffset() < startOffset) {
                        text.setContent(text.getContent(), startOffset, text.getEndOffset());
                    } else if (text.getEndOffset() > endOffset) {
                        text.setContent(text.getContent(), text.getStartOffset(), endOffset);
                    }
                    list.add(text);
                }
            }
            ++i;
        }
        return list.toArray(new IVexNode[list.size()]);
    }

    static IVexNode[] createNodeArray(Content content, int startOffset, int endOffset, IVexElement[] elements) {
        ArrayList<IVexNode> nodes = new ArrayList<IVexNode>();
        int offset = startOffset;
        int i = 0;
        while (i < elements.length) {
            int start = elements[i].getStartOffset();
            if (offset < start) {
                nodes.add(new Text(content, offset, start));
            }
            nodes.add(elements[i]);
            offset = elements[i].getEndOffset() + 1;
            ++i;
        }
        if (offset < endOffset) {
            nodes.add(new Text(content, offset, endOffset));
        }
        return nodes.toArray(new IVexNode[nodes.size()]);
    }

    @Override
    public String getPublicID() {
        return this.publicID;
    }

    @Override
    public String getRawText(int startOffset, int endOffset) {
        return this.content.getString(startOffset, endOffset - startOffset);
    }

    @Override
    public IVexElement getRootElement() {
        return this.rootElement;
    }

    @Override
    public String getSystemID() {
        return this.systemID;
    }

    @Override
    public String getText(int startOffset, int endOffset) {
        String raw = this.content.getString(startOffset, endOffset - startOffset);
        StringBuffer sb = new StringBuffer(raw.length());
        int i = 0;
        while (i < raw.length()) {
            char c = raw.charAt(i);
            if (c != '\u0000') {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }

    @Override
    public Validator getValidator() {
        return this.validator;
    }

    public void setContent(Content content) {
        this.content = content;
    }

    protected Content getContent() {
        return this.content;
    }

    @Override
    public void insertElement(int offset, IVexElement elementArg) throws DocumentValidationException {
        IVexElement parent;
        WrongModelException.throwIfNeeded(elementArg, Element.class);
        IVexElement element = elementArg;
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Error inserting element <" + element.getName() + ">: offset is " + offset + ", but it must be between 1 and " + (this.getLength() - 1));
        }
        Validator validator = this.getValidator();
        if (validator != null) {
            parent = this.getElementAt(offset);
            String[] seq1 = this.getNodeNames(parent.getStartOffset() + 1, offset);
            String[] seq2 = new String[]{element.getName()};
            String[] seq3 = this.getNodeNames(offset, parent.getEndOffset());
            if (!validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true)) {
                throw new DocumentValidationException("Cannot insert element " + element.getName() + " at offset " + offset);
            }
        }
        parent = this.getRootElement();
        int childIndex = -1;
        while (childIndex == -1) {
            boolean tryAgain = false;
            IVexElement[] children = parent.getChildElements();
            int i = 0;
            while (i < children.length) {
                IVexElement child = children[i];
                if (offset <= child.getStartOffset()) {
                    childIndex = i;
                    break;
                }
                if (offset <= child.getEndOffset()) {
                    parent = child;
                    tryAgain = true;
                    break;
                }
                ++i;
            }
            if (tryAgain || childIndex != -1) continue;
            childIndex = children.length;
            break;
        }
        this.fireBeforeContentInserted(new DocumentEvent(this, parent, offset, 2, null));
        this.content.insertString(offset, "\u0000\u0000");
        element.setContent(this.content, offset, offset + 1);
        element.setParent(parent);
        parent.internalInsertChild(childIndex, element);
        InsertElementEdit edit = this.undoEnabled ? new InsertElementEdit(offset, element) : null;
        this.fireContentInserted(new DocumentEvent(this, parent, offset, 2, edit));
    }

    @Override
    public void insertFragment(int offset, IVexDocumentFragment fragment) throws DocumentValidationException {
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Error inserting document fragment");
        }
        IVexElement parent = this.getElementAt(offset);
        if (this.validator != null) {
            String[] seq1 = this.getNodeNames(parent.getStartOffset() + 1, offset);
            String[] seq2 = fragment.getNodeNames();
            String[] seq3 = this.getNodeNames(offset, parent.getEndOffset());
            if (!this.validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true)) {
                throw new DocumentValidationException("Cannot insert document fragment");
            }
        }
        this.fireBeforeContentInserted(new DocumentEvent(this, parent, offset, 2, null));
        Content c = fragment.getContent();
        String s = c.getString(0, c.getLength());
        this.content.insertString(offset, s);
        IVexElement[] children = parent.getChildElements();
        int index = 0;
        while (index < children.length && children[index].getEndOffset() < offset) {
            ++index;
        }
        IVexElement[] elements = fragment.getElements();
        int i = 0;
        while (i < elements.length) {
            IVexElement newElement = this.cloneElement(elements[i], this.content, offset, parent);
            parent.internalInsertChild(index, newElement);
            ++index;
            ++i;
        }
        InsertFragmentEdit edit = this.undoEnabled ? new InsertFragmentEdit(offset, fragment) : null;
        this.fireContentInserted(new DocumentEvent(this, parent, offset, fragment.getContent().getLength(), edit));
    }

    @Override
    public void insertText(int offset, String text) throws DocumentValidationException {
        if (offset < 1 || offset >= this.getLength()) {
            throw new IllegalArgumentException("Offset must be between 1 and n-1");
        }
        IVexElement parent = this.getElementAt(offset);
        boolean isValid = false;
        if (this.getCharacterAt(offset - 1) != '\u0000') {
            isValid = true;
        } else if (this.getCharacterAt(offset) != '\u0000') {
            isValid = true;
        } else {
            Validator validator = this.getValidator();
            if (validator != null) {
                String[] seq1 = this.getNodeNames(parent.getStartOffset() + 1, offset);
                String[] seq2 = new String[]{"#PCDATA"};
                String[] seq3 = this.getNodeNames(offset, parent.getEndOffset());
                isValid = validator.isValidSequence(parent.getName(), seq1, seq2, seq3, true);
            } else {
                isValid = true;
            }
        }
        if (!isValid) {
            throw new DocumentValidationException("Cannot insert text '" + text + "' at offset " + offset);
        }
        StringBuffer sb = new StringBuffer(text);
        int i = 0;
        while (i < sb.length()) {
            if (Character.isISOControl(sb.charAt(i)) && sb.charAt(i) != '\n') {
                sb.setCharAt(i, ' ');
            }
            ++i;
        }
        String s = sb.toString();
        this.fireBeforeContentInserted(new DocumentEvent(this, parent, offset, 2, null));
        this.content.insertString(offset, s);
        InsertTextEdit edit = this.undoEnabled ? new InsertTextEdit(offset, s) : null;
        this.fireContentInserted(new DocumentEvent(this, parent, offset, s.length(), edit));
    }

    @Override
    public boolean isUndoEnabled() {
        return this.undoEnabled;
    }

    @Override
    public void removeDocumentListener(DocumentListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void setPublicID(String publicID) {
        this.publicID = publicID;
    }

    @Override
    public void setSystemID(String systemID) {
        this.systemID = systemID;
    }

    @Override
    public void setUndoEnabled(boolean undoEnabled) {
        this.undoEnabled = undoEnabled;
    }

    @Override
    public void setValidator(Validator validator) {
        this.validator = validator;
    }

    private static void assertOffset(int offset, int min, int max) {
        if (offset < min || offset > max) {
            throw new IllegalArgumentException("Bad offset " + offset + "must be between " + min + " and " + max);
        }
    }

    protected IVexElement cloneElement(IVexElement original, Content content, int shift, IVexElement parent) {
        Element clone = new Element(original.getName());
        clone.setContent(content, original.getStartOffset() + shift, original.getEndOffset() + shift);
        String[] attrNames = original.getAttributeNames();
        int i = 0;
        while (i < attrNames.length) {
            try {
                clone.setAttribute(attrNames[i], original.getAttribute(attrNames[i]));
            }
            catch (DocumentValidationException ex) {
                throw new RuntimeException("Unexpected exception: " + ex);
            }
            ++i;
        }
        clone.setParent(parent);
        IVexElement[] children = original.getChildElements();
        int i2 = 0;
        while (i2 < children.length) {
            IVexElement cloneChild = this.cloneElement(children[i2], content, shift, clone);
            clone.internalInsertChild(i2, cloneChild);
            ++i2;
        }
        return clone;
    }

    void fireAttributeChanged(DocumentEvent e) {
        this.listeners.fireEvent("attributeChanged", e);
    }

    protected void fireBeforeContentDeleted(DocumentEvent e) {
        this.listeners.fireEvent("beforeContentDeleted", e);
    }

    protected void fireBeforeContentInserted(DocumentEvent e) {
        this.listeners.fireEvent("beforeContentInserted", e);
    }

    protected void fireContentDeleted(DocumentEvent e) {
        this.listeners.fireEvent("contentDeleted", e);
    }

    protected void fireContentInserted(DocumentEvent e) {
        this.listeners.fireEvent("contentInserted", e);
    }

    public void setRootElement(IVexRootElement rootElement) {
        this.rootElement = rootElement;
    }

    @Override
    public IWhitespacePolicy getWhitespacePolicy() {
        return this.whitespacePolicy;
    }

    @Override
    public void setWhitespacePolicy(IWhitespacePolicy policy) {
        this.whitespacePolicy = policy;
    }

    public void setCSSfileLocation(String filename) {
        this.cssfile_location = filename;
    }

    public String getCSSfileLocation() {
        return this.cssfile_location;
    }

    public class DeleteEdit
    implements IUndoableEdit {
        private int startOffset;
        private int endOffset;
        private IVexDocumentFragment frag;

        public DeleteEdit(int startOffset, int endOffset, IVexDocumentFragment frag) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
            this.frag = frag;
        }

        @Override
        public boolean combine(IUndoableEdit edit) {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    Document.this.insertFragment(this.startOffset, this.frag);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    Document.this.delete(this.startOffset, this.endOffset);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }
    }

    public class InsertElementEdit
    implements IUndoableEdit {
        private int offset;
        private IVexElement element;

        public InsertElementEdit(int offset, IVexElement element) {
            this.offset = offset;
            this.element = element;
        }

        @Override
        public boolean combine(IUndoableEdit edit) {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    Document.this.delete(this.offset, this.offset + 2);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    Document.this.insertElement(this.offset, this.element);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }
    }

    public class InsertFragmentEdit
    implements IUndoableEdit {
        private int offset;
        private IVexDocumentFragment frag;

        public InsertFragmentEdit(int offset, IVexDocumentFragment frag) {
            this.offset = offset;
            this.frag = frag;
        }

        @Override
        public boolean combine(IUndoableEdit edit) {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    int length = this.frag.getContent().getLength();
                    Document.this.delete(this.offset, this.offset + length);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    Document.this.insertFragment(this.offset, this.frag);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }
    }

    public class InsertTextEdit
    implements IUndoableEdit {
        private int offset;
        private String text;

        public InsertTextEdit(int offset, String text) {
            this.offset = offset;
            this.text = text;
        }

        @Override
        public boolean combine(IUndoableEdit edit) {
            if (edit instanceof InsertTextEdit) {
                InsertTextEdit ite = (InsertTextEdit)edit;
                if (ite.offset == this.offset + this.text.length()) {
                    this.text = String.valueOf(this.text) + ite.text;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    Document.this.delete(this.offset, this.offset + this.text.length());
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            try {
                try {
                    Document.this.setUndoEnabled(false);
                    Document.this.insertText(this.offset, this.text);
                }
                catch (DocumentValidationException documentValidationException) {
                    throw new CannotUndoException();
                }
            }
            finally {
                Document.this.setUndoEnabled(true);
            }
        }
    }
}

