/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.sf.vex.core.Caret;
import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.FontSpec;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Insets;
import net.sf.vex.core.IntRange;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.StyleSheet;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexDocument;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.Position;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.AnnotationRenderingInfo;
import net.sf.vex.layout.BinTree;
import net.sf.vex.layout.BlockBox;
import net.sf.vex.layout.BlockElementBox;
import net.sf.vex.layout.BlockElementWidget;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.ElementOrRangeCallback;
import net.sf.vex.layout.HCaret;
import net.sf.vex.layout.InlineElementBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LayoutUtils;
import net.sf.vex.layout.LineBox;
import net.sf.vex.layout.ParagraphBox;
import net.sf.vex.layout.PlaceholderBox;
import net.sf.vex.layout.RootBox;
import net.sf.vex.layout.TableBox;
import net.sf.vex.layout.VexAnnotationTracker;

public abstract class AbstractBlockBox
extends AbstractBox
implements BlockBox {
    private static Color markerColor = new Color(100, 100, 160);
    private BlockBox parent;
    protected Box[] children;
    public static final byte LAYOUT_OK = 0;
    public static final byte LAYOUT_PROPAGATE = 1;
    public static final byte LAYOUT_REDO = 2;
    private byte layoutState = (byte)2;
    private static final int H_CARET_LENGTH = 20;
    private IVexElement element;
    private int marginTop;
    private int marginBottom;
    protected Position startPosition;
    protected Position endPosition;

    public AbstractBlockBox(LayoutContext context, BlockBox parent, IVexElement element) {
        this.parent = parent;
        this.element = element;
        int parentWidth = parent.getWidth();
        if (element != null) {
            Styles styles = context.getStyleSheet().getStyles(element);
            this.marginTop = styles.getMarginTop().get(parentWidth);
            this.marginBottom = styles.getMarginBottom().get(parentWidth);
        }
    }

    public AbstractBlockBox(LayoutContext context, BlockBox parent, int startOffset, int endOffset) {
        this.parent = parent;
        this.marginTop = 0;
        this.marginBottom = 0;
        IVexDocument doc = context.getDocument();
        this.startPosition = doc.createPosition(startOffset);
        this.endPosition = doc.createPosition(endOffset);
    }

    protected IVexElement findContainingElement() {
        BlockBox box = this;
        IVexElement element = box.getElement();
        while (element == null) {
            box = box.getParent();
            element = box.getElement();
        }
        return element;
    }

    protected BlockBox[] getBlockChildren() {
        return (BlockBox[])this.getChildren();
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        if (this.getLayoutState() != 0) {
            int relative = offset - this.getStartOffset();
            int size = this.getEndOffset() - this.getStartOffset();
            int y = 0;
            if (size > 0) {
                y = this.getHeight() * (relative / size);
            }
            return new HCaret(0, y, this.getHCaretWidth());
        }
        BlockBox[] contentChildren = this.getContentChildren();
        int i = 0;
        while (i < contentChildren.length) {
            if (offset < contentChildren[i].getStartOffset()) {
                Box firstChild;
                int y = i > 0 ? (contentChildren[i - 1].getY() + contentChildren[i - 1].getHeight() + contentChildren[i].getY()) / 2 : ((firstChild = this.getFirstChild()) != null && firstChild instanceof BlockElementWidget ? firstChild.getHeight() : 0);
                return new HCaret(0, y, this.getHCaretWidth());
            }
            if (offset >= contentChildren[i].getStartOffset() && offset <= contentChildren[i].getEndOffset()) {
                Caret caret = contentChildren[i].getCaret(context, offset);
                caret.translate(contentChildren[i].getX(), contentChildren[i].getY());
                return caret;
            }
            ++i;
        }
        int y = this.hasChildren() ? this.getHeight() : this.getHeight() / 2;
        return new HCaret(0, y, this.getHCaretWidth());
    }

    @Override
    public Box[] getChildren() {
        return this.children;
    }

    protected BlockBox[] getContentChildren() {
        Box[] children = this.getChildren();
        ArrayList<Box> contentChildren = new ArrayList<Box>(children.length);
        int i = 0;
        while (i < children.length) {
            if (children[i].hasContent()) {
                contentChildren.add(children[i]);
            }
            ++i;
        }
        return contentChildren.toArray(new BlockBox[contentChildren.size()]);
    }

    @Override
    public IVexElement getElement() {
        return this.element;
    }

    @Override
    public int getEndOffset() {
        IVexElement element = this.getElement();
        if (element != null) {
            return element.getEndOffset();
        }
        if (this.getEndPosition() != null) {
            return this.getEndPosition().getOffset();
        }
        throw new IllegalStateException();
    }

    protected int getEstimatedHeight(LayoutContext context) {
        IVexElement element = this.findContainingElement();
        Styles styles = context.getStyleSheet().getStyles(element);
        int charCount = this.getEndOffset() - this.getStartOffset();
        float fontSize = styles.getFontSize();
        float lineHeight = styles.getLineHeight();
        float estHeight = lineHeight * fontSize * 0.6f * (float)charCount / (float)this.getWidth();
        return Math.round(Math.max(estHeight, lineHeight));
    }

    @Override
    public LineBox getFirstLine() {
        if (this.hasChildren()) {
            BlockBox firstChild = (BlockBox)this.getChildren()[0];
            return firstChild.getFirstLine();
        }
        return null;
    }

    protected int getHCaretWidth() {
        return 20;
    }

    @Override
    public LineBox getLastLine() {
        if (this.hasChildren()) {
            BlockBox lastChild = (BlockBox)this.getChildren()[this.getChildren().length - 1];
            return lastChild.getLastLine();
        }
        return null;
    }

    protected byte getLayoutState() {
        return this.layoutState;
    }

    @Override
    public int getLineEndOffset(int offset) {
        BlockBox[] children = this.getContentChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].containsOffset(offset)) {
                return children[i].getLineEndOffset(offset);
            }
            ++i;
        }
        return offset;
    }

    @Override
    public int getLineStartOffset(int offset) {
        BlockBox[] children = this.getContentChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].containsOffset(offset)) {
                return children[i].getLineStartOffset(offset);
            }
            ++i;
        }
        return offset;
    }

    @Override
    public int getMarginBottom() {
        return this.marginBottom;
    }

    @Override
    public int getMarginTop() {
        return this.marginTop;
    }

    @Override
    public int getNextLineOffset(LayoutContext context, int offset, int x) {
        if (offset == this.getEndOffset()) {
            return -1;
        }
        BlockBox[] children = this.getContentChildren();
        if (offset < this.getStartOffset() && children.length > 0 && children[0].getStartOffset() > this.getStartOffset()) {
            return this.getStartOffset();
        }
        int i = 0;
        while (i < children.length) {
            BlockBox child = children[i];
            if (offset <= child.getEndOffset()) {
                int newOffset = child.getNextLineOffset(context, offset, x - child.getX());
                if (newOffset < 0) {
                    return child.getEndOffset() + 1;
                }
                return newOffset;
            }
            ++i;
        }
        return this.getEndOffset();
    }

    @Override
    public BlockBox getParent() {
        return this.parent;
    }

    @Override
    public int getPreviousLineOffset(LayoutContext context, int offset, int x) {
        if (offset == this.getStartOffset()) {
            return -1;
        }
        BlockBox[] children = this.getContentChildren();
        if (offset > this.getEndOffset() && children.length > 0 && children[children.length - 1].getEndOffset() < this.getEndOffset()) {
            return this.getEndOffset();
        }
        int i = children.length;
        while (i > 0) {
            BlockBox child = children[i - 1];
            if (offset >= child.getStartOffset()) {
                int newOffset = child.getPreviousLineOffset(context, offset, x - child.getX());
                if (newOffset < 0 && i > 0) {
                    return child.getStartOffset() - 1;
                }
                return newOffset;
            }
            --i;
        }
        return this.getStartOffset();
    }

    @Override
    public int getStartOffset() {
        IVexElement element = this.getElement();
        if (element != null) {
            return element.getStartOffset() + 1;
        }
        if (this.getStartPosition() != null) {
            return this.getStartPosition().getOffset();
        }
        throw new IllegalStateException();
    }

    @Override
    public boolean hasContent() {
        return true;
    }

    @Override
    public void invalidate(boolean direct) {
        this.layoutState = direct ? (byte)2 : (byte)1;
        if (this.getParent() instanceof AbstractBlockBox) {
            ((AbstractBlockBox)this.getParent()).invalidate(false);
        }
    }

    @Override
    public boolean isAnonymous() {
        return this.getElement() == null;
    }

    protected void iterateChildrenByDisplayStyle(StyleSheet styleSheet, Set displayStyles, ElementOrRangeCallback callback) {
        LayoutUtils.iterateChildrenByDisplayStyle(styleSheet, displayStyles, this.findContainingElement(), this.getStartOffset(), this.getEndOffset(), callback);
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        if (this.skipPaint(context, x, y)) {
            return;
        }
        this.drawBox(context, x, y, this.getParent().getWidth(), true);
        this.paintChildren(context, x, y, area);
    }

    @Override
    public void setInitialSize(LayoutContext context) {
        int parentWidth = this.getParent().getWidth();
        Insets insets = this.getInsets(context, parentWidth);
        this.setWidth(Math.max(0, parentWidth - insets.getLeft() - insets.getRight()));
        this.setHeight(this.getEstimatedHeight(context));
    }

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        Box[] children = this.getChildren();
        if (children == null) {
            int charCount = this.getEndOffset() - this.getStartOffset() - 1;
            if (charCount == 0 || this.getHeight() == 0) {
                return this.getEndOffset();
            }
            return this.getStartOffset() + charCount * y / this.getHeight();
        }
        int i = 0;
        while (i < children.length) {
            Box child = children[i];
            if (child.hasContent()) {
                if (y < child.getY()) {
                    return child.getStartOffset() - 1;
                }
                if (y < child.getY() + child.getHeight()) {
                    return child.viewToModel(context, x - child.getX(), y - child.getY());
                }
            }
            ++i;
        }
        return this.getEndOffset();
    }

    protected void paintSurroundingFrame(LayoutContext context, int x, int y, int width, ColorResource foreground, ColorResource background) {
        Styles styles = context.getStyleSheet().getStyles(this.element);
        int plusLeft = styles.getBorderLeftWidth() + styles.getPaddingLeft().get(width);
        int plusTop = styles.getBorderTopWidth() + styles.getPaddingTop().get(width);
        int plusRight = styles.getBorderRightWidth() + styles.getPaddingRight().get(width);
        int plusBottom = styles.getBorderBottomWidth() + styles.getPaddingBottom().get(width);
        Graphics g = context.getGraphics();
        FontResource font = g.createFont(new FontSpec(new String[]{"sans-serif"}, 0, 10.0f));
        FontResource oldFont = g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        ColorResource oldColor = g.setColor(background);
        g.setLineStyle(0);
        g.setLineWidth(1);
        int tabWidth = g.stringWidth(this.getElement().getName()) + fm.getLeading();
        fm.getHeight();
        this.getWidth();
        g.drawRect(x - plusLeft, y - plusTop, this.getWidth() + plusLeft + plusRight, this.getHeight() + plusTop + plusBottom);
        g.setColor(oldColor);
        g.setFont(oldFont);
        font.dispose();
    }

    protected void paintMarkerFrame(LayoutContext context, int x, int y, int width) {
        AnnotationRenderingInfo annotationInfo = VexAnnotationTracker.getRenderingInfo(context, this.getElement());
        ColorResource background = annotationInfo != null && annotationInfo.isShownInText() ? context.getGraphics().createColor(annotationInfo.getColor()) : context.getGraphics().createColor(markerColor);
        ColorResource foreground = context.getGraphics().createColor(new Color(255, 255, 255));
        this.paintSurroundingFrame(context, x, y, width, foreground, background);
        foreground.dispose();
        background.dispose();
    }

    protected void paintSelectionFrame(LayoutContext context, int x, int y, int width) {
        ColorResource background = context.getGraphics().getSystemColor(0);
        ColorResource foreground = context.getGraphics().getSystemColor(1);
        this.paintSurroundingFrame(context, x, y, width, background, foreground);
    }

    protected void paintSelectionFill(LayoutContext context, int x, int y) {
        ColorResource background = context.getGraphics().getSystemColor(0);
        Graphics g = context.getGraphics();
        ColorResource oldColor = g.setColor(background);
        g.fillRect(x, y, this.getWidth(), this.getHeight());
        g.setColor(oldColor);
    }

    @Override
    public IntRange layout(LayoutContext context, int top, int bottom) {
        BlockBox child;
        int i;
        int repaintStart = Integer.MAX_VALUE;
        int repaintEnd = 0;
        boolean repaintToBottom = false;
        Insets ins = this.getInsets(context, -1);
        int originalHeight = this.getHeight() + ins.getTop() + ins.getBottom();
        String name = this.getElement() == null ? this.toString() : this.getElement().getName();
        context.subTask("Laying out {0}", name);
        if (this.layoutState == 2) {
            List childList = this.createChildren(context);
            this.children = childList.toArray(new BlockBox[childList.size()]);
            i = 0;
            while (i < this.children.length) {
                child = (BlockBox)this.children[i];
                child.setInitialSize(context);
                ++i;
            }
            this.positionChildren(context);
            repaintToBottom = true;
            repaintStart = 0;
        }
        Box[] children = this.getChildren();
        i = 0;
        while (i < children.length) {
            if (children[i] instanceof BlockBox) {
                IntRange repaintRange;
                child = (BlockBox)children[i];
                Insets childIns = Insets.ZERO_INSETS;
                if (child instanceof BlockElementBox) {
                    childIns = child.getInsets(context, this.getWidth());
                }
                if (top <= child.getY() + child.getHeight() + childIns.getTop() + childIns.getBottom() && bottom >= child.getY() && (repaintRange = child.layout(context, top - child.getY(), bottom - child.getY())) != null) {
                    repaintStart = Math.min(repaintStart, repaintRange.getStart() + child.getY());
                    repaintEnd = Math.max(repaintEnd, repaintRange.getEnd() + child.getY());
                }
            }
            ++i;
        }
        int childRepaintStart = this.positionChildren(context);
        if (childRepaintStart != -1) {
            repaintToBottom = true;
            repaintStart = Math.min(repaintStart, childRepaintStart);
        }
        this.layoutState = 0;
        if (repaintToBottom) {
            ins = Insets.ZERO_INSETS;
            if (this instanceof BlockElementBox) {
                ins = this.getInsets(context, -1);
            }
            repaintEnd = Math.max(originalHeight, this.getHeight() + ins.getTop() + ins.getBottom());
        }
        if (repaintStart < repaintEnd) {
            return new IntRange(repaintStart, repaintEnd);
        }
        return null;
    }

    protected abstract List createChildren(LayoutContext var1);

    protected List createBlockBoxes(LayoutContext context, int startOffset, int endOffset, int width, List beforeInlines, List afterInlines) {
        ArrayList<Box> blockBoxes = new ArrayList<Box>();
        ArrayList<PlaceholderBox> pendingInlines = new ArrayList<PlaceholderBox>();
        if (beforeInlines != null) {
            pendingInlines.addAll(beforeInlines);
        }
        IVexElement element = context.getDocument().findCommonElement(startOffset, endOffset);
        if (startOffset == endOffset) {
            int relOffset = startOffset - element.getStartOffset();
            pendingInlines.add(new PlaceholderBox(context, element, relOffset));
        } else {
            Object next;
            BlockInlineIterator iter = new BlockInlineIterator(context, element, startOffset, endOffset);
            while ((next = iter.next()) != null) {
                if (next instanceof IntRange) {
                    IntRange range = (IntRange)next;
                    InlineElementBox.InlineBoxes inlineBoxes = InlineElementBox.createInlineBoxes(context, element, range.getStart(), range.getEnd());
                    pendingInlines.addAll(inlineBoxes.boxes);
                    pendingInlines.add(new PlaceholderBox(context, element, range.getEnd() - element.getStartOffset()));
                    continue;
                }
                if (pendingInlines.size() > 0) {
                    blockBoxes.add(ParagraphBox.create(context, element, pendingInlines, width));
                    pendingInlines.clear();
                }
                if (this.isTableChild(context, next)) {
                    int tableStartOffset = ((IVexElement)next).getStartOffset();
                    int tableEndOffset = -1;
                    while (this.isTableChild(context, next)) {
                        tableEndOffset = ((IVexElement)next).getEndOffset() + 1;
                        next = iter.next();
                    }
                    blockBoxes.add(new TableBox(context, this, tableStartOffset, tableEndOffset));
                    if (next == null) break;
                    iter.push(next);
                    continue;
                }
                IVexElement blockElement = (IVexElement)next;
                blockBoxes.add(context.getBoxFactory().createBox(context, blockElement, this, width));
            }
        }
        if (afterInlines != null) {
            pendingInlines.addAll(afterInlines);
        }
        if (pendingInlines.size() > 0) {
            blockBoxes.add(ParagraphBox.create(context, element, pendingInlines, width));
            pendingInlines.clear();
        }
        return blockBoxes;
    }

    protected boolean hasChildren() {
        return this.getChildren() != null && this.getChildren().length > 0;
    }

    protected int positionChildren(LayoutContext context) {
        int childY = 0;
        int prevMargin = 0;
        BlockBox[] children = this.getBlockChildren();
        int repaintStart = -1;
        Styles styles = null;
        if (!this.isAnonymous()) {
            styles = context.getStyleSheet().getStyles(this.getElement());
        }
        if (styles != null && children.length > 0 && styles.getBorderTopWidth() + styles.getPaddingTop().get(this.getWidth()) == 0) {
            this.marginTop = Math.max(this.marginTop, children[0].getMarginTop());
            childY -= children[0].getMarginTop();
        }
        int i = 0;
        while (i < children.length) {
            Insets insets = children[i].getInsets(context, this.getWidth());
            childY += insets.getTop();
            if (i > 0) {
                childY -= Math.min(prevMargin, children[i].getMarginTop());
            }
            if (repaintStart == -1 && children[i].getY() != childY) {
                repaintStart = Math.min(children[i].getY(), childY);
            }
            children[i].setX(insets.getLeft());
            children[i].setY(childY);
            childY += children[i].getHeight() + insets.getBottom();
            prevMargin = children[i].getMarginBottom();
            ++i;
        }
        if (styles != null && children.length > 0 && styles.getBorderBottomWidth() + styles.getPaddingBottom().get(this.getWidth()) == 0) {
            this.marginBottom = Math.max(this.marginBottom, prevMargin);
            childY -= prevMargin;
        }
        this.setHeight(childY);
        return repaintStart;
    }

    protected void setLayoutState(byte layoutState) {
        this.layoutState = layoutState;
    }

    private static IVexElement findNextBlockElement(LayoutContext context, IVexElement element, int startOffset, int endOffset) {
        IVexElement[] children = element.getChildElements();
        int i = 0;
        while (i < children.length) {
            IVexElement child = children[i];
            if (child.getEndOffset() >= startOffset) {
                if (child.getStartOffset() >= endOffset) break;
                Styles styles = context.getStyleSheet().getStyles(child);
                if (!styles.getDisplay().equalsIgnoreCase("inline")) {
                    return child;
                }
            }
            ++i;
        }
        return null;
    }

    private Position getEndPosition() {
        return this.endPosition;
    }

    private Position getStartPosition() {
        return this.startPosition;
    }

    private boolean isTableChild(LayoutContext context, Object rangeOrElement) {
        if (rangeOrElement != null && rangeOrElement instanceof IVexElement) {
            return LayoutUtils.isTableChild(context.getStyleSheet(), (IVexElement)rangeOrElement);
        }
        return false;
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        Insets ins = new Insets(this.marginTop, 0, this.marginBottom, 0);
        return ins;
    }

    @Override
    public void setParent(BlockBox parent) {
        this.parent = parent;
    }

    public static void setMarkerColor(Color markerColor) {
        AbstractBlockBox.markerColor = markerColor;
    }

    public RootBox findRoot() {
        BlockBox b = this;
        while (!(b instanceof RootBox)) {
            b = b.getParent();
        }
        return (RootBox)b;
    }

    public Box getFirstChild() {
        if (this.children.length != 0) {
            if (this.children[0] instanceof BinTree) {
                return ((AbstractBlockBox)this.children[0]).getFirstChild();
            }
            return this.children[0];
        }
        return null;
    }

    private class BlockInlineIterator {
        private LayoutContext context;
        private IVexElement element;
        private int startOffset;
        private int endOffset;
        private LinkedList pushStack = new LinkedList();

        public BlockInlineIterator(LayoutContext context, IVexElement element, int startOffset, int endOffset) {
            this.context = context;
            this.element = element;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public Object next() {
            if (this.pushStack.size() > 0) {
                return this.pushStack.removeLast();
            }
            if (this.startOffset == this.endOffset) {
                return null;
            }
            IVexElement blockElement = AbstractBlockBox.findNextBlockElement(this.context, this.element, this.startOffset, this.endOffset);
            if (blockElement == null) {
                if (this.startOffset < this.endOffset) {
                    IntRange result = new IntRange(this.startOffset, this.endOffset);
                    this.startOffset = this.endOffset;
                    return result;
                }
                return null;
            }
            if (blockElement.getStartOffset() > this.startOffset) {
                this.pushStack.addLast(blockElement);
                IntRange result = new IntRange(this.startOffset, blockElement.getStartOffset());
                this.startOffset = blockElement.getEndOffset() + 1;
                return result;
            }
            this.startOffset = blockElement.getEndOffset() + 1;
            return blockElement;
        }

        public Object peek() {
            if (this.pushStack.size() == 0) {
                Object next = this.next();
                if (next == null) {
                    return null;
                }
                this.push(next);
            }
            return this.pushStack.getLast();
        }

        public void push(Object pushed) {
            this.pushStack.addLast(pushed);
        }
    }
}

