/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import net.sf.vex.core.Caret;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.css.Styles;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.TextCaret;

public abstract class CompositeInlineBox
extends AbstractBox
implements InlineBox {
    @Override
    public boolean hasContent() {
        Box[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i].hasContent()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isEOL() {
        Box[] children = this.getChildren();
        return children.length > 0 && ((InlineBox)children[children.length - 1]).isEOL();
    }

    @Override
    public Caret getCaret(LayoutContext context, int offset) {
        int x = 0;
        Box[] children = this.getChildren();
        int start = 0;
        while (start < children.length && !children[start].hasContent()) {
            x += children[start].getWidth();
            ++start;
        }
        int end = children.length;
        while (end < 0 && !children[end - 1].hasContent()) {
            --end;
        }
        int i = start;
        while (i < end) {
            Box child = children[i];
            if (child.hasContent()) {
                if (offset < child.getStartOffset()) break;
                if (offset <= child.getEndOffset()) {
                    Caret caret = child.getCaret(context, offset);
                    caret.translate(child.getX(), child.getY());
                    return caret;
                }
            }
            x += child.getWidth();
            ++i;
        }
        Graphics g = context.getGraphics();
        Styles styles = context.getStyleSheet().getStyles(this.getElement());
        FontResource font = g.createFont(styles.getFont());
        FontResource oldFont = g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        int height = fm.getAscent() + fm.getDescent();
        g.setFont(oldFont);
        font.dispose();
        int lineHeight = styles.getLineHeight();
        int y = (lineHeight - height) / 2;
        return new TextCaret(x, y, height);
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, int maxWidth, boolean force) {
        LinkedList<Box> rights = new LinkedList<Box>(Arrays.asList(this.getChildren()));
        ArrayList<InlineBox> pending = new ArrayList<InlineBox>();
        ArrayList<InlineBox> lefts = new ArrayList<InlineBox>();
        int remaining = maxWidth;
        boolean eol = false;
        while (!rights.isEmpty() && remaining >= 0) {
            InlineBox inline = (InlineBox)rights.removeFirst();
            InlineBox.Pair pair = inline.split(context, remaining, force && lefts.isEmpty());
            if (pair.getLeft() != null) {
                lefts.addAll(pending);
                pending.clear();
                lefts.add(pair.getLeft());
                remaining -= pair.getLeft().getWidth();
            }
            if (pair.getRight() != null) {
                pending.add(pair.getRight());
                remaining -= pair.getRight().getWidth();
            }
            if (pair.getLeft() == null || !pair.getLeft().isEOL()) continue;
            eol = true;
            break;
        }
        if ((force && lefts.isEmpty() || remaining >= 0) && !eol) {
            lefts.addAll(pending);
        } else {
            rights.addAll(0, pending);
        }
        InlineBox[] leftKids = lefts.toArray(new InlineBox[lefts.size()]);
        InlineBox[] rightKids = rights.toArray(new InlineBox[rights.size()]);
        return this.split(context, leftKids, rightKids);
    }

    protected abstract InlineBox.Pair split(LayoutContext var1, InlineBox[] var2, InlineBox[] var3);

    @Override
    public int viewToModel(LayoutContext context, int x, int y) {
        if (!this.hasContent()) {
            throw new RuntimeException("Oops. Calling viewToModel on a line with no content");
        }
        Box closestContentChild = null;
        int delta = Integer.MAX_VALUE;
        Box[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            Box child = children[i];
            if (child.hasContent()) {
                int newDelta = 0;
                if (x < child.getX()) {
                    newDelta = child.getX() - x;
                } else if (x > child.getX() + child.getWidth()) {
                    newDelta = x - (child.getX() + child.getWidth());
                }
                if (newDelta < delta) {
                    delta = newDelta;
                    closestContentChild = child;
                }
            }
            ++i;
        }
        return closestContentChild.viewToModel(context, x - closestContentChild.getX(), y - closestContentChild.getY());
    }
}

