/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.List;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Insets;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.dom.IVexNode;
import net.sf.vex.dom.IVexNonElement;
import net.sf.vex.dom.IVexText;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.Box;
import net.sf.vex.layout.CompositeInlineBox;
import net.sf.vex.layout.DocumentTextBox;
import net.sf.vex.layout.DrawableBox;
import net.sf.vex.layout.InlineBox;
import net.sf.vex.layout.LabeledInlineMarkerBox;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.LayoutUtils;
import net.sf.vex.layout.NonElementBox;
import net.sf.vex.layout.PlaceholderBox;
import net.sf.vex.layout.UnlabeledInlineMarker;

public class InlineElementBox
extends CompositeInlineBox {
    private IVexElement element;
    private InlineBox[] children;
    private InlineBox firstContentChild = null;
    private InlineBox lastContentChild = null;
    private int baseline;
    private int halfLeading;

    private InlineElementBox(LayoutContext context, IVexElement element, int startOffset, int endOffset) {
        this.element = element;
        ArrayList<AbstractBox> childList = new ArrayList<AbstractBox>();
        Styles styles = context.getStyleSheet().getStyles(element);
        if (startOffset <= element.getStartOffset()) {
            IVexElement beforeElement = context.getStyleSheet().getBeforeElement(element);
            if (beforeElement != null) {
                childList.addAll(LayoutUtils.createGeneratedInlines(context, beforeElement));
            }
            if (context.showInlineMarkers()) {
                switch (context.getInlineMarkerStyle()) {
                    case Unlabeled: {
                        UnlabeledInlineMarker leftMarker = new UnlabeledInlineMarker(true, (int)styles.getFontSize());
                        childList.add(new DrawableBox(leftMarker, element, 1));
                        break;
                    }
                    case Labeled: {
                        childList.add(new LabeledInlineMarkerBox(context, styles.getFontSize(), element, true));
                    }
                }
            }
        }
        InlineBoxes inlines = InlineElementBox.createInlineBoxes(context, element, startOffset, endOffset);
        childList.addAll(inlines.boxes);
        this.firstContentChild = inlines.firstContentBox;
        this.lastContentChild = inlines.lastContentBox;
        if (endOffset > element.getEndOffset()) {
            IVexElement afterElement;
            childList.add(new PlaceholderBox(context, element, element.getEndOffset() - element.getStartOffset()));
            if (context.showInlineMarkers()) {
                switch (context.getInlineMarkerStyle()) {
                    case Unlabeled: {
                        UnlabeledInlineMarker uRightMarker = new UnlabeledInlineMarker(false, (int)styles.getFontSize());
                        childList.add(new DrawableBox(uRightMarker, element, 2));
                        break;
                    }
                    case Labeled: {
                        childList.add(new LabeledInlineMarkerBox(context, styles.getFontSize(), element, false));
                    }
                }
            }
            if ((afterElement = context.getStyleSheet().getAfterElement(element)) != null) {
                childList.addAll(LayoutUtils.createGeneratedInlines(context, afterElement));
            }
        }
        this.children = childList.toArray(new InlineBox[childList.size()]);
        this.layout(context);
    }

    private InlineElementBox(LayoutContext context, IVexElement element, InlineBox[] children) {
        this.element = element;
        this.children = children;
        this.layout(context);
        int i = 0;
        while (i < children.length) {
            InlineBox child = children[i];
            if (child.hasContent()) {
                if (this.firstContentChild == null) {
                    this.firstContentChild = child;
                }
                this.lastContentChild = child;
            }
            ++i;
        }
    }

    @Override
    public int getBaseline() {
        return this.baseline;
    }

    @Override
    public Box[] getChildren() {
        return this.children;
    }

    @Override
    public IVexElement getElement() {
        return this.element;
    }

    @Override
    public int getEndOffset() {
        if (this.lastContentChild == null) {
            return this.getElement().getEndOffset();
        }
        return this.lastContentChild.getEndOffset();
    }

    @Override
    public int getStartOffset() {
        if (this.firstContentChild == null) {
            return this.getElement().getStartOffset();
        }
        return this.firstContentChild.getStartOffset();
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        Insets ins = this.getInsets(context, this.getWidth());
        boolean drawSelected = context.isElementSelected(this.getElement());
        this.drawBox(context, x + ins.getLeft(), y + ins.getTop(), 0, drawSelected);
        super.paint(context, x, y, area);
    }

    @Override
    public InlineBox.Pair split(LayoutContext context, InlineBox[] lefts, InlineBox[] rights) {
        context.subTask("Splitting in {0} ...", this.element.getName());
        InlineElementBox left = null;
        InlineElementBox right = null;
        if (lefts.length > 0 || rights.length == 0) {
            left = new InlineElementBox(context, this.getElement(), lefts);
        }
        if (rights.length > 0) {
            right = new InlineElementBox(context, this.getElement(), rights);
        }
        return new InlineBox.Pair(left, right);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.getStartOffset() == this.getElement().getStartOffset() + 1) {
            sb.append("<");
            sb.append(this.getElement().getName());
            sb.append(">");
        }
        Box[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            sb.append(children[i]);
            ++i;
        }
        if (this.getEndOffset() == this.getElement().getEndOffset()) {
            sb.append("</");
            sb.append(this.getElement().getName());
            sb.append(">");
        }
        return sb.toString();
    }

    static InlineBoxes createInlineBoxes(LayoutContext context, IVexElement containingElement, int startOffset, int endOffset) {
        InlineBoxes result = new InlineBoxes();
        IVexNode[] nodes = containingElement.getChildNodes();
        int i = 0;
        while (i < nodes.length) {
            block8: {
                AbstractBox child;
                block9: {
                    IVexNode node;
                    block10: {
                        block7: {
                            int end;
                            int start;
                            node = nodes[i];
                            if (node.getStartOffset() >= endOffset) break;
                            if (!(node instanceof IVexText)) break block7;
                            if (node.getEndOffset() <= startOffset || (start = Math.max(startOffset, node.getStartOffset())) == (end = Math.min(endOffset, node.getEndOffset()))) break block8;
                            child = new DocumentTextBox(context, containingElement, start, end);
                            break block9;
                        }
                        if (!(node instanceof IVexNonElement)) break block10;
                        if (node.getEndOffset() < startOffset) break block8;
                        IVexNonElement childElement = (IVexNonElement)node;
                        PlaceholderBox placeholder = new PlaceholderBox(context, containingElement, childElement.getStartOffset() - containingElement.getStartOffset());
                        result.boxes.add(placeholder);
                        if (result.firstContentBox == null) {
                            result.firstContentBox = placeholder;
                        }
                        int start = Math.max(startOffset, node.getStartOffset());
                        int end = Math.min(endOffset, node.getEndOffset());
                        child = NonElementBox.createNonElementBox(context, childElement, start, end);
                        break block9;
                    }
                    if (node.getEndOffset() < startOffset) break block8;
                    IVexElement childElement = (IVexElement)node;
                    PlaceholderBox placeholder = new PlaceholderBox(context, containingElement, childElement.getStartOffset() - containingElement.getStartOffset());
                    result.boxes.add(placeholder);
                    if (result.firstContentBox == null) {
                        result.firstContentBox = placeholder;
                    }
                    child = new InlineElementBox(context, childElement, startOffset, endOffset);
                }
                if (result.firstContentBox == null) {
                    result.firstContentBox = child;
                }
                result.lastContentBox = child;
                result.boxes.add(child);
            }
            ++i;
        }
        return result;
    }

    private void layout(LayoutContext context) {
        Graphics g = context.getGraphics();
        Styles styles = context.getStyleSheet().getStyles(this.element);
        FontResource font = g.createFont(styles.getFont());
        FontResource oldFont = g.setFont(font);
        FontMetrics fm = g.getFontMetrics();
        this.setHeight(styles.getLineHeight());
        this.halfLeading = (styles.getLineHeight() - fm.getAscent() - fm.getDescent()) / 2;
        Insets ins = this.getInsets(context, this.getWidth());
        int x = 0;
        int i = 0;
        while (i < this.children.length) {
            InlineBox child = this.children[i];
            Insets childIns = child.getInsets(context, this.getWidth());
            child.setX(x + ins.getLeft());
            x += child.getWidth() + childIns.getLeft();
            this.setHeight(Math.max(this.getHeight(), child.getHeight() + childIns.getTop() + childIns.getBottom()));
            ++i;
        }
        this.setWidth(x);
        InlineBox[] inlineBoxArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            InlineBox b = inlineBoxArray[n2];
            Insets childIns = Insets.ZERO_INSETS;
            if (b instanceof InlineElementBox) {
                childIns = b.getInsets(context, this.getWidth());
            }
            b.setY(ins.getTop() + (this.getHeight() - b.getHeight() - childIns.getTop() - childIns.getBottom()) / 2);
            ++n2;
        }
        g.setFont(oldFont);
        font.dispose();
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        IVexElement element = this.getElement();
        if (element == null) {
            return Insets.ZERO_INSETS;
        }
        return InlineElementBox.getInsets(context.getStyleSheet().getStyles(element), containerWidth);
    }

    static class InlineBoxes {
        public List boxes = new ArrayList();
        public InlineBox firstContentBox;
        public InlineBox lastContentBox;

        InlineBoxes() {
        }
    }
}

