/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.swt;

import net.sf.vex.core.Color;
import net.sf.vex.core.ColorResource;
import net.sf.vex.core.FontMetrics;
import net.sf.vex.core.FontResource;
import net.sf.vex.core.FontSpec;
import net.sf.vex.core.Graphics;
import net.sf.vex.swt.SwtColor;
import net.sf.vex.swt.SwtFont;
import net.sf.vex.swt.SwtFontMetrics;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class SwtGraphics
implements Graphics {
    private GC gc;
    private int originX;
    private int originY;
    private static final int FAR_OUT_FIX = 30000;
    private int lineStyle = 0;

    public SwtGraphics(GC gc) {
        this.gc = gc;
    }

    @Override
    public void dispose() {
        this.gc.dispose();
    }

    @Override
    public void drawChars(char[] chars, int offset, int length, int x, int y) {
        this.drawString(new String(chars, offset, length), x, y);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2) {
        this.gc.drawLine(x1 + this.originX, y1 + this.originY, x2 + this.originX, y2 + this.originY);
    }

    @Override
    public void drawOval(int x, int y, int width, int height) {
        this.gc.drawOval(x + this.originX, y + this.originY, width, height);
    }

    @Override
    public void drawRect(int x, int y, int width, int height) {
        int startY = y + this.originY;
        int endY = y + this.originY + height;
        if (startY < -30000) {
            startY = -30000;
        } else {
            this.gc.drawLine(x + this.originX, startY, x + this.originX + width, startY);
        }
        if (endY > 30000) {
            endY = 30000;
        } else {
            this.gc.drawLine(x + this.originX, endY, x + this.originX + width, endY);
        }
        this.gc.drawLine(x + this.originX, startY, x + this.originX, endY);
        this.gc.drawLine(x + this.originX + width, startY, x + this.originX + width, endY);
    }

    @Override
    public void drawString(String s, int x, int y) {
        int startY = y + this.originY;
        if (startY < -30000) {
            startY = -30000;
        }
        if (startY > 30000) {
            startY = 30000;
        }
        this.gc.drawString(s, x + this.originX, startY, true);
    }

    @Override
    public void drawImage(Image image, int x, int y, int width, int height) {
        this.gc.drawImage(image, x + this.originX, y + this.originY);
    }

    @Override
    public void fillOval(int x, int y, int width, int height) {
        this.gc.fillOval(x + this.originX, y + this.originY, width, height);
    }

    @Override
    public void fillRect(int x, int y, int width, int height) {
        int startY = y + this.originY;
        if (startY < -30000) {
            startY = -30000;
        }
        if (startY + height > 30000) {
            height = 30000 - startY;
        }
        this.gc.fillRectangle(x + this.originX, startY, width, height);
    }

    @Override
    public net.sf.vex.core.Rectangle getClipBounds() {
        Rectangle r = this.gc.getClipping();
        return new net.sf.vex.core.Rectangle(r.x - this.originX, r.y - this.originY, r.width, r.height);
    }

    @Override
    public ColorResource getColor() {
        return new SwtColor(this.gc.getForeground());
    }

    @Override
    public FontResource getFont() {
        return new SwtFont(this.gc.getFont());
    }

    @Override
    public FontMetrics getFontMetrics() {
        return new SwtFontMetrics(this.gc.getFontMetrics());
    }

    @Override
    public int getLineStyle() {
        return this.lineStyle;
    }

    @Override
    public int getLineWidth() {
        return this.gc.getLineWidth();
    }

    @Override
    public boolean isAntiAliased() {
        return false;
    }

    @Override
    public void setAntiAliased(boolean antiAliased) {
    }

    @Override
    public ColorResource setColor(ColorResource color) {
        ColorResource oldColor = this.getColor();
        this.gc.setForeground(((SwtColor)color).getSwtColor());
        this.gc.setBackground(((SwtColor)color).getSwtColor());
        return oldColor;
    }

    @Override
    public FontResource setFont(FontResource font) {
        FontResource oldFont = this.getFont();
        this.gc.setFont(((SwtFont)font).getSwtFont());
        return oldFont;
    }

    @Override
    public void setLineStyle(int lineStyle) {
        this.lineStyle = lineStyle;
        switch (lineStyle) {
            case 1: {
                this.gc.setLineStyle(2);
                break;
            }
            case 2: {
                this.gc.setLineStyle(3);
                break;
            }
            default: {
                this.gc.setLineStyle(1);
            }
        }
    }

    @Override
    public void setLineWidth(int lineWidth) {
        this.gc.setLineWidth(lineWidth);
    }

    @Override
    public int charsWidth(char[] data, int offset, int length) {
        return this.stringWidth(new String(data, offset, length));
    }

    @Override
    public ColorResource createColor(Color rgb) {
        return new SwtColor(new org.eclipse.swt.graphics.Color(null, rgb.getRed(), rgb.getGreen(), rgb.getBlue()));
    }

    @Override
    public FontResource createFont(FontSpec fontSpec) {
        int style = 0;
        if ((fontSpec.getStyle() & 1) > 0) {
            style |= 1;
        }
        if ((fontSpec.getStyle() & 2) > 0) {
            style |= 2;
        }
        int size = Math.round(fontSpec.getSize() * 72.0f / 90.0f);
        String[] names = fontSpec.getNames();
        FontData[] fd = new FontData[names.length];
        int i = 0;
        while (i < names.length) {
            fd[i] = new FontData(names[i], size, style);
            ++i;
        }
        return new SwtFont(new Font(null, fd));
    }

    @Override
    public ColorResource getSystemColor(int id) {
        if (id == 0) {
            return new SwtColor(Display.getCurrent().getSystemColor(26));
        }
        if (id == 1) {
            return new SwtColor(Display.getCurrent().getSystemColor(27));
        }
        return new SwtColor(Display.getCurrent().getSystemColor(-1));
    }

    public void setOrigin(int x, int y) {
        this.originX = x;
        this.originY = y;
    }

    @Override
    public int stringWidth(String s) {
        return this.gc.stringExtent((String)s).x;
    }
}

