/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.mpeditor;

import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.xmleditor.mpeditor.Activator;
import info.textgrid.lab.xmleditor.mpeditor.Messages;
import info.textgrid.lab.xmleditor.mpeditor.SchemaManager;
import java.io.File;
import java.net.URI;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverExtension;

public class TextGridSchemaResolver
implements URIResolverExtension {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String resolve(IFile file, String baseLocation, String publicId, String systemId) {
        if (baseLocation != null && baseLocation.startsWith("file:///") && (baseLocation.startsWith("textgrid-efs", 8) || baseLocation.startsWith("textgrid", 8) || baseLocation.startsWith("textgrid-newfile", 8))) {
            baseLocation = baseLocation.substring(8);
        }
        if (Activator.isDebugging("info.textgrid.lab.xmleditor.mpeditor/debug/resolve")) {
            System.out.println(MessageFormat.format("TG schema resolve({0}, {1}, {2}, {3}) ...", file, baseLocation, publicId, systemId));
        }
        TextGridObject textGridObject = null;
        URI schemaURI = null;
        try {
            if (systemId != null && systemId.startsWith("textgrid")) {
                schemaURI = URI.create(systemId);
            } else {
                if (file != null) {
                    textGridObject = (TextGridObject)AdapterUtils.getAdapter((Object)file, TextGridObject.class);
                } else if (baseLocation != null && (baseLocation.startsWith("textgrid-newfile") || baseLocation.startsWith("textgrid-efs"))) {
                    textGridObject = TextGridObject.getInstance((URI)URI.create(baseLocation), (boolean)false);
                }
                if (textGridObject == null) {
                    return null;
                }
                schemaURI = textGridObject.getSchemaURI();
            }
            if (Activator.isDebugging("info.textgrid.lab.xmleditor.mpeditor/debug/resolve")) {
                System.out.println(MessageFormat.format("... found schema {0}", schemaURI));
            }
            if (schemaURI == null) {
                return null;
            }
            TextGridObject schemaObject = TextGridObject.getInstance((URI)schemaURI, (boolean)false);
            if (!schemaObject.isAccessible()) return null;
            File localSchema = schemaObject.toLocalFile(null, false);
            SchemaManager.getInstance().registerLocalSchema(schemaObject, localSchema.toURI());
            Activator.handleProblem(0, null, "Returned schema {0} for file {1}, object {2}", localSchema, file, textGridObject);
            return localSchema.toURI().toString();
        }
        catch (CoreException e) {
            IStatus status = Activator.handleProblem(2, e, Messages.TextGridSchemaResolver_FailedTryingToGetSchema, textGridObject, schemaURI, e.getMessage());
            if (!Activator.isDebugging("info.textgrid.lab.xmleditor.mpeditor/debug/resolve")) return null;
            System.out.println(MessageFormat.format("... failed: {0}", status));
        }
        return null;
    }
}

