/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.newsearch;

import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.model.RestrictedTextGridObject;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.search.Activator;
import info.textgrid.lab.search.NoMatchEntry;
import info.textgrid.middleware.tgsearch.client.SearchClient;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import info.textgrid.namespaces.middleware.tgsearch.Response;
import info.textgrid.namespaces.middleware.tgsearch.ResultType;
import info.textgrid.namespaces.middleware.tgsearch.Revisions;
import java.math.BigInteger;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class SearchRequest
extends PlatformObject
implements IDeferredWorkbenchAdapter {
    private SearchClient searchClient = null;
    private ArrayList<TextGridObject> resultList = new ArrayList();
    private String queryMetadata;
    private String queryText;
    private String queryBaseline;
    private String revisionURI;
    private String queryRelated;
    private String relatedURI;
    private TargetModus target = TargetModus.BOTH;
    private int wordDistance = -1;
    private boolean isMetadataQuery;
    private boolean isTextQuery;
    private boolean isBaselineQuery;
    private boolean isRevisionQuery;
    private boolean isRelatedQuery;
    private boolean hitCountAvailable = false;
    private boolean isResolvePath = false;
    private boolean allProjects = false;
    private String sid = null;
    public Integer returnedByNow = 0;
    public Integer returnedInThisPortion;
    private int hitCount = 0;
    private String ORDER = "relevance";
    private ListenerList hitCountListeners = new ListenerList();
    private ListenerList partSearchReadyListeners = new ListenerList();
    private static final String TGSearchProjectException = "The webservice TG-Search isn't available at the moment.";

    public SearchRequest() {
        try {
            this.searchClient = new SearchClient(ConfClient.getInstance().getValue("tgsearch"));
            this.searchClient.setSid(RBACSession.getInstance().getSID(false));
            this.searchClient.setLIMIT(100);
            IPreferenceStore preferenceStore = ConfPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean("compressedTransfer")) {
                this.searchClient.enableGzipCompression();
            }
        }
        catch (OfflineException offlineException) {
            Status status = new Status(4, "info.textgrid.lab.search", "System offline, can not connect to TG-Search.");
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public SearchRequest(EndPoint endPoint) {
        try {
            this.searchClient = endPoint != null ? (endPoint.equals((Object)EndPoint.PUBLIC) ? new SearchClient(ConfClient.getInstance().getValue("tgsearch-public")) : new SearchClient(ConfClient.getInstance().getValue("tgsearch"))) : new SearchClient(ConfClient.getInstance().getValue("tgsearch"));
            this.searchClient.setSid(RBACSession.getInstance().getSID(false));
            this.searchClient.setLIMIT(100);
            IPreferenceStore preferenceStore = ConfPlugin.getDefault().getPreferenceStore();
            if (preferenceStore.getBoolean("compressedTransfer")) {
                this.searchClient.enableGzipCompression();
            }
        }
        catch (OfflineException offlineException) {
            Status status = new Status(4, "info.textgrid.lab.search", "System offline, can not connect to TG-Search.");
            Activator.getDefault().getLog().log((IStatus)status);
        }
    }

    public void setSID(String sid) {
        this.searchClient.setSid(sid);
    }

    public Response listProject(String projectID) {
        try {
            return this.searchClient.listProject(projectID);
        }
        catch (Exception e) {
            Activator.handleError(e, TGSearchProjectException, 4, new Object[0]);
            Activator.handleError(e, TGSearchProjectException, 1, new Object[0]);
            return null;
        }
    }

    public Response listAggregation(String aggregation) {
        try {
            return this.searchClient.listAggregation(aggregation);
        }
        catch (Exception e) {
            Activator.handleError(e, TGSearchProjectException, 4, new Object[0]);
            Activator.handleError(e, TGSearchProjectException, 1, new Object[0]);
            return null;
        }
    }

    public Response listTopLevelAggregations() {
        try {
            return this.searchClient.listToplevelAggregations();
        }
        catch (Exception e) {
            Activator.handleError(e, TGSearchProjectException, 4, new Object[0]);
            Activator.handleError(e, TGSearchProjectException, 1, new Object[0]);
            return null;
        }
    }

    public TextGridObject[] getResultList() {
        return this.resultList.toArray(new TextGridObject[0]);
    }

    public void setQueryMetadata(String queryMetadata) {
        if (!queryMetadata.isEmpty()) {
            this.isMetadataQuery = true;
            this.queryMetadata = queryMetadata;
        }
    }

    public void setQueryText(String queryText) {
        if (!queryText.isEmpty()) {
            this.isTextQuery = true;
            this.queryText = queryText;
        }
    }

    public void setQueryBaseline(String queryBaseline) {
        if (!queryBaseline.isEmpty()) {
            this.isBaselineQuery = true;
            this.queryBaseline = queryBaseline;
        }
    }

    public void setQueryRevision(String revisionURI) {
        if (!revisionURI.isEmpty()) {
            this.isRevisionQuery = true;
            this.revisionURI = revisionURI;
        }
    }

    public void setQueryRelated(String queryRelated, String relatedURI) {
        if (!queryRelated.isEmpty()) {
            this.isRelatedQuery = true;
            this.queryRelated = queryRelated;
            this.relatedURI = relatedURI;
        }
    }

    public Response execute(IProgressMonitor monitor) {
        try {
            Response response = null;
            this.searchClient.setTarget(this.target.toString().toLowerCase());
            this.searchClient.setResolvePath(this.isResolvePath);
            if (this.wordDistance != -1) {
                this.searchClient.setWordDistance(this.wordDistance);
            }
            if (this.isMetadataQuery) {
                response = this.isAllProjects() ? this.searchClient.queryAllProjects(this.queryMetadata, null, RBACSession.getInstance().getSID(false), 0, Integer.MAX_VALUE) : this.searchClient.query(this.queryMetadata);
                this.sid = this.searchClient.getSid();
            } else if (this.isTextQuery) {
                response = this.isAllProjects() ? this.searchClient.queryAllProjects(this.queryText, null, null, 0, Integer.MAX_VALUE) : this.searchClient.query(this.queryText);
                this.sid = this.searchClient.getSid();
            } else if (this.isBaselineQuery) {
                response = this.searchClient.queryBaseline(this.queryBaseline, 0);
                this.sid = this.searchClient.getSid();
            } else if (this.isRevisionQuery) {
                response = this.searchClient.listRevisionsAndMeta(this.revisionURI);
                this.sid = this.searchClient.getSid();
            } else if (this.isRelatedQuery) {
                response = this.searchClient.getRelatedAndMeta(this.queryRelated, this.relatedURI);
                this.sid = this.searchClient.getSid();
            }
            if (response != null && !this.hitCountAvailable) {
                try {
                    this.hitCount = Integer.parseInt(response.getHits());
                    this.setHitCountAvailable(true);
                }
                catch (NumberFormatException numberFormatException) {
                    this.hitCount = 0;
                }
            }
            return response;
        }
        catch (Exception e) {
            Activator.handleError(e, TGSearchProjectException, 4, new Object[0]);
            Activator.handleError(e, TGSearchProjectException, 1, new Object[0]);
            return null;
        }
    }

    public Response execute(IProgressMonitor monitor, int start, int limit) {
        try {
            Response response = null;
            this.searchClient.setTarget(this.target.toString().toLowerCase());
            this.searchClient.setResolvePath(this.isResolvePath);
            if (this.wordDistance != -1) {
                this.searchClient.setWordDistance(this.wordDistance);
            }
            if (this.isMetadataQuery) {
                response = this.isAllProjects() ? this.searchClient.queryAllProjects(this.queryMetadata, this.ORDER, this.sid, start, limit) : this.searchClient.query(this.queryMetadata, this.ORDER, this.sid, start, limit);
                this.sid = this.searchClient.getSid();
            } else if (this.isTextQuery) {
                response = this.isAllProjects() ? this.searchClient.queryAllProjects(this.queryText, this.ORDER, this.sid, start, limit) : this.searchClient.query(this.queryText, this.ORDER, this.sid, start, limit);
                this.sid = this.searchClient.getSid();
            } else if (this.isBaselineQuery) {
                response = this.searchClient.queryBaseline(this.queryBaseline, this.ORDER, this.sid, start, limit);
                this.sid = this.searchClient.getSid();
            } else if (this.isRevisionQuery) {
                response = this.searchClient.listRevisionsAndMeta(this.revisionURI);
                this.sid = this.searchClient.getSid();
            } else if (this.isRelatedQuery) {
                response = this.searchClient.getRelatedAndMeta(this.queryRelated, this.relatedURI);
                this.sid = this.searchClient.getSid();
            }
            if (response != null && !this.hitCountAvailable) {
                try {
                    this.hitCount = Integer.parseInt(response.getHits());
                    this.setHitCountAvailable(true);
                }
                catch (NumberFormatException numberFormatException) {
                    this.hitCount = 0;
                }
            }
            this.setPartSearchReady();
            return response;
        }
        catch (Exception e) {
            Activator.handleError(e, TGSearchProjectException, 4, new Object[0]);
            Activator.handleError(e, TGSearchProjectException, 1, new Object[0]);
            return null;
        }
    }

    public SearchClient getSearchClient() {
        return this.searchClient;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("Search running", -1);
        SearchRequest searchRequest = this;
        synchronized (searchRequest) {
            if (object instanceof SearchRequest) {
                Activator.resetLogTimer();
                Activator.debugLog("SearchResult fetching: Starting query ...");
                Response searchResult = this.execute(monitor);
                Activator.debugLog("SearchResult fetching: Query done");
                Iterator iter = searchResult.getResult().iterator();
                Activator.debugLog("SearchResult fetching: got child elements");
                while (iter.hasNext()) {
                    ObjectType oType;
                    Object obj = iter.next();
                    if (!(obj instanceof ResultType) || (oType = ((ResultType)obj).getObject()) == null) continue;
                    try {
                        if (oType.getGeneric().getProvided() != null) {
                            TextGridObject tgo = TextGridObject.getInstance((ObjectType)oType, (boolean)true, (boolean)true);
                            collector.add((Object)tgo, monitor);
                            continue;
                        }
                        RestrictedTextGridObject rtgo = new RestrictedTextGridObject(oType.getGeneric().getGenerated().getTextgridUri().getValue());
                        collector.add((Object)rtgo, monitor);
                    }
                    catch (CoreException e) {
                        Status status = new Status(4, "info.textgrid.lab.search", "Error while preparing search result.", (Throwable)e);
                        Activator.getDefault().getLog().log((IStatus)status);
                    }
                }
            } else {
                throw new IllegalArgumentException(MessageFormat.format("SearchResult''s fetchDeferredChildren does not know the children of {0}s like {1}", object.getClass(), object));
            }
            collector.add((Object)new NoMatchEntry(), monitor);
            collector.done();
            monitor.done();
            Activator.debugLog("SearchResult fetching: done");
        }
    }

    public boolean isContainer() {
        return false;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public void setHitCountAvailable(boolean flag) {
        this.hitCountAvailable = flag;
        Event e = new Event();
        e.doit = flag;
        this.notifyHitCountListeners(e);
    }

    public void addHitCountListener(Listener l) {
        this.hitCountListeners.add((Object)l);
    }

    public void removeHitCountListener(Listener l) {
        this.hitCountListeners.remove((Object)l);
    }

    protected void notifyHitCountListeners(Event event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.hitCountListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((Listener)listener).handleEvent(event);
            ++n2;
        }
    }

    public void setPartSearchReady() {
        Event e = new Event();
        e.doit = true;
        this.notifyPartSearchReadyListeners(e);
    }

    public void addPartSearchReadyListener(Listener l) {
        this.partSearchReadyListeners.add((Object)l);
    }

    public void removePartSearchReadyListener(Listener l) {
        this.partSearchReadyListeners.remove((Object)l);
    }

    protected void notifyPartSearchReadyListeners(Event event) {
        Object[] listeners;
        Object[] objectArray = listeners = this.partSearchReadyListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((Listener)listener).handleEvent(event);
            ++n2;
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public static boolean isTgoLatestRevision(String uri) {
        SearchRequest searchRequest = new SearchRequest();
        Revisions revisions = searchRequest.getSearchClient().listRevisions(uri);
        List revisionsList = revisions.getRevision();
        if (!revisionsList.isEmpty()) {
            BigInteger thisRevision = new BigInteger(uri.split("\\.")[1]);
            BigInteger lastRevision = (BigInteger)Collections.max(revisionsList);
            return lastRevision.equals(thisRevision);
        }
        return false;
    }

    public static String maskSpecialCharacters(String query) {
        String result = query.replace("+", "\\+");
        return result;
    }

    public void setTarget(TargetModus target) {
        this.target = target;
    }

    public void setWordDistance(int wordDistance) {
        this.wordDistance = wordDistance;
    }

    public void setResolvePath(boolean value) {
        this.isResolvePath = value;
    }

    public void setAllProjects(boolean allProjects) {
        this.allProjects = allProjects;
    }

    public boolean isAllProjects() {
        return this.allProjects;
    }

    public HashMap<String, HashMap<String, Integer>> gatherAggregationURIs(String uri, HashMap<String, HashMap<String, Integer>> aggregationURIs) {
        Response agg = this.searchClient.listAggregation(uri);
        for (ResultType res : agg.getResult()) {
            HashMap<Object, Object> titleCount;
            String aggUri = res.getObject().getGeneric().getGenerated().getTextgridUri().getValue();
            String title = (String)res.getObject().getGeneric().getProvided().getTitle().get(0);
            String format = res.getObject().getGeneric().getProvided().getFormat();
            if (aggregationURIs.containsKey(aggUri)) {
                titleCount = aggregationURIs.get(aggUri);
                int count = (Integer)titleCount.get(title);
                titleCount.put(title, ++count);
            } else {
                titleCount = new HashMap();
                titleCount.put(title, 1);
                aggregationURIs.put(aggUri, titleCount);
            }
            if (!format.contains("aggregation")) continue;
            aggregationURIs = this.gatherAggregationURIs(aggUri, aggregationURIs);
        }
        return aggregationURIs;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("query: ");
        if (this.isTextQuery) {
            result.append(' ').append(this.queryText);
        }
        if (this.isMetadataQuery) {
            result.append(' ').append(this.queryMetadata);
        }
        return result.toString();
    }

    public static enum EndPoint {
        STANDARD,
        PUBLIC;

    }

    public class ListAggregationResult {
        public String uri;
        public String title;
        public int count;

        public ListAggregationResult(String uri, String title, int count) {
            this.uri = uri;
            this.title = title;
            this.count = count;
        }
    }

    public static enum TargetModus {
        STRUCTURE,
        METADATA,
        BOTH;

    }
}

