/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.utils.export.filenames;

import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FileExtensionMap {
    private final ImmutableMultimap<String, String> map;
    private static Logger logger = Logger.getLogger(FileExtensionMap.class.getName());
    private static FileExtensionMap instance;

    protected FileExtensionMap() throws IOException {
        Pattern mapLine = Pattern.compile("^[ \t]*([^# \t]+)[ \t]*([^#]+)[ \t]*(#.*)?$");
        Pattern space = Pattern.compile("[ \t]+");
        LineNumberReader reader = new LineNumberReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("mime.types"), Charset.forName("UTF-8")));
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher = mapLine.matcher(line);
            if (matcher.matches() && matcher.groupCount() >= 2) {
                builder.putAll((Object)matcher.group(1), (Object[])space.split(matcher.group(2)));
            }
            line = reader.readLine();
        }
        this.map = builder.build();
        logger.fine(MessageFormat.format("Read {0} lines from the mime.types file, parsed {1}\u00a0mappings", reader.getLineNumber(), this.map.size()));
        reader.close();
    }

    public ImmutableCollection<String> getExtensions(String mimeType) {
        return this.map.get((Object)mimeType);
    }

    public Optional<String> getFirstExtension(String mimeType) {
        ImmutableCollection extensions = this.map.get((Object)mimeType);
        if (!extensions.isEmpty()) {
            return Optional.of((Object)extensions.iterator().next());
        }
        return Optional.absent();
    }

    public String addExtension(String plainFileName, String mimeType) {
        Optional<String> extension = this.getFirstExtension(mimeType);
        if (extension.isPresent()) {
            return plainFileName.concat(".").concat((String)extension.get());
        }
        return plainFileName;
    }

    public static FileExtensionMap getInstance() {
        if (instance == null) {
            try {
                instance = new FileExtensionMap();
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        return instance;
    }
}

