/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.core.DisplayDevice;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class BorderSpacingProperty
extends AbstractProperty {
    public BorderSpacingProperty() {
        super("border-spacing");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        int horizontal = 0;
        int vertical = 0;
        DisplayDevice device = DisplayDevice.getCurrent();
        if (BorderSpacingProperty.isLength(lu)) {
            horizontal = BorderSpacingProperty.getIntLength(lu, styles.getFontSize(), device.getHorizontalPPI());
            vertical = BorderSpacingProperty.isLength(lu = lu.getNextLexicalUnit()) ? BorderSpacingProperty.getIntLength(lu, styles.getFontSize(), device.getVerticalPPI()) : horizontal;
            return new Value(horizontal, vertical);
        }
        if (parentStyles == null) {
            return Value.ZERO;
        }
        return parentStyles.getBorderSpacing();
    }

    public static class Value {
        private int horizontal;
        private int vertical;
        public static final Value ZERO = new Value(0, 0);

        public Value(int horizontal, int vertical) {
            this.horizontal = horizontal;
            this.vertical = vertical;
        }

        public int getHorizontal() {
            return this.horizontal;
        }

        public int getVertical() {
            return this.vertical;
        }
    }
}

