/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class FontVariantProperty
extends AbstractProperty {
    public FontVariantProperty() {
        super("font-variant");
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        if (FontVariantProperty.isFontVariant(lu)) {
            return lu.getStringValue();
        }
        if (parentStyles != null) {
            return parentStyles.getFontStyle();
        }
        return "normal";
    }

    public static boolean isFontVariant(LexicalUnit lu) {
        if (lu == null) {
            return false;
        }
        if (lu.getLexicalUnitType() == 35) {
            String s = lu.getStringValue();
            return s.equalsIgnoreCase("normal") || s.equalsIgnoreCase("small-caps");
        }
        return false;
    }
}

