/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.css;

import net.sf.vex.core.DisplayDevice;
import net.sf.vex.css.AbstractProperty;
import net.sf.vex.css.RelativeLength;
import net.sf.vex.css.Styles;
import org.w3c.css.sac.LexicalUnit;

public class LengthProperty
extends AbstractProperty {
    private int axis;

    public LengthProperty(String name, byte axis) {
        super(name);
        this.axis = axis;
    }

    @Override
    public Object calculate(LexicalUnit lu, Styles parentStyles, Styles styles) {
        int ppi;
        DisplayDevice device = DisplayDevice.getCurrent();
        int n = ppi = this.axis == 0 ? device.getHorizontalPPI() : device.getVerticalPPI();
        if (LengthProperty.isLength(lu)) {
            int length = LengthProperty.getIntLength(lu, styles.getFontSize(), ppi);
            return RelativeLength.createAbsolute(length);
        }
        if (LengthProperty.isPercentage(lu)) {
            return RelativeLength.createRelative(lu.getFloatValue() / 100.0f);
        }
        if (LengthProperty.isInherit(lu) && parentStyles != null) {
            return parentStyles.get(this.getName());
        }
        return RelativeLength.createAbsolute(0);
    }
}

