/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.vex.core.Insets;
import net.sf.vex.core.Rectangle;
import net.sf.vex.css.Styles;
import net.sf.vex.dom.IVexElement;
import net.sf.vex.layout.AbstractBlockBox;
import net.sf.vex.layout.AbstractBox;
import net.sf.vex.layout.ElementOrRangeCallback;
import net.sf.vex.layout.LayoutContext;
import net.sf.vex.layout.TableBox;
import net.sf.vex.layout.TableRowGroupBox;

public class TableBodyBox
extends AbstractBlockBox {
    private static Set childDisplayStyles = new HashSet();

    static {
        childDisplayStyles.add("table-row-group");
        childDisplayStyles.add("table-header-group");
        childDisplayStyles.add("table-footer-group");
    }

    public TableBodyBox(LayoutContext context, TableBox parent, int startOffset, int endOffset) {
        super(context, parent, startOffset, endOffset);
    }

    @Override
    protected List createChildren(final LayoutContext context) {
        final ArrayList children = new ArrayList();
        this.iterateChildrenByDisplayStyle(context.getStyleSheet(), childDisplayStyles, new ElementOrRangeCallback(){

            @Override
            public void onElement(IVexElement child, String displayStyle) {
                children.add(new TableRowGroupBox(context, TableBodyBox.this, child));
            }

            @Override
            public void onRange(IVexElement parent, int startOffset, int endOffset) {
                children.add(new TableRowGroupBox(context, TableBodyBox.this, startOffset, endOffset));
            }
        });
        return children;
    }

    @Override
    public Insets getInsets(LayoutContext context, int containerWidth) {
        if (this.getParent().getElement() != null) {
            Styles styles = context.getStyleSheet().getStyles(this.getParent().getElement());
            return AbstractBox.getInsets(styles, containerWidth);
        }
        return Insets.ZERO_INSETS;
    }

    @Override
    public void paint(LayoutContext context, int x, int y, Rectangle area) {
        this.drawBox(context, this.getParent().getElement(), x, y, this.getParent().getWidth(), true);
        this.paintChildren(context, x, y, area);
    }
}

