/*
 * Decompiled with CFR 0.152.
 */
package net.sf.vex.layout;

import net.sf.vex.core.Color;
import net.sf.vex.core.Drawable;
import net.sf.vex.core.Graphics;
import net.sf.vex.core.Rectangle;

class UnlabeledInlineMarker
implements Drawable {
    protected int size;
    protected static final int[] color;
    protected boolean isLeftMarker;

    static {
        int[] nArray = new int[3];
        nArray[1] = 100;
        nArray[2] = 255;
        color = nArray;
    }

    public UnlabeledInlineMarker(boolean setLeftMarker, float fontsize) {
        this.size = (int)((double)fontsize * 0.6);
        this.isLeftMarker = setLeftMarker;
    }

    @Override
    public void draw(Graphics g, int x, int y) {
        boolean oldAntiAliased = g.isAntiAliased();
        g.setAntiAliased(true);
        g.setColor(g.createColor(new Color(color[0], color[1], color[2])));
        g.setLineStyle(0);
        g.setLineWidth(1);
        int width = (int)((double)this.size * 0.5);
        if (this.isLeftMarker) {
            g.drawLine(x, y, x, y + this.size);
            g.drawLine(x, y + this.size, x + width, y + this.size / 2);
            g.drawLine(x + width, y + this.size / 2, x, y);
        } else {
            g.drawLine(x + width, y, x + width, y + this.size);
            g.drawLine(x + width, y + this.size, x, y + this.size / 2);
            g.drawLine(x, y + this.size / 2, x + width, y);
        }
        g.setAntiAliased(oldAntiAliased);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, -this.size, this.size, this.size);
    }
}

