/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.linkeditor.controller.TeiFactory;

import info.textgrid.lab.core.model.util.StringToOM;
import info.textgrid.lab.linkeditor.controller.Activator;
import info.textgrid.lab.linkeditor.controller.LinkEditorController;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGGroup;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGImage;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGShape;
import info.textgrid.lab.linkeditor.controller.TeiFactory.SVGText;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEILink;
import info.textgrid.lab.linkeditor.controller.TeiFactory.TEILinkGroup;
import info.textgrid.lab.linkeditor.controller.utils.XMLPrettyPrinter;
import info.textgrid.lab.linkeditor.model.graphics.TGLine;
import info.textgrid.lab.linkeditor.model.graphics.TGShape;
import info.textgrid.lab.linkeditor.model.links.ILink;
import info.textgrid.lab.linkeditor.model.links.LinksContainer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.stream.XMLStreamException;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.progress.UIJob;

public class TEIDocFactory {
    private OMFactory omFactory;
    private OMNamespace teiNS;
    private OMNamespace xmlNS;
    private OMNamespace svgNS;
    private OMNamespace xlinkNS;
    private OMElement tei;
    private OMElement teiHeader;
    private OMElement svg;
    private OMElement ab;
    public static String XML_NS_URI = "http://www.w3.org/XML/1998/namespace";
    public static String TEI_NS_URI = "http://www.tei-c.org/ns/1.0";
    public static String XLINK_NS_URI = "http://www.w3.org/1999/xlink";
    public static String SVG_NS_URI = "http://www.w3.org/2000/svg";
    public static String XML_NS_Prefix = "xml";
    public static String TEI_NS_Prefix = "tei";
    public static String XLINK_NS_Prefix = "xlink";
    public static String SVG_NS_Prefix = "svg";
    private LinksContainer links = null;
    private boolean inBackground = true;
    private List<SVGGroup> svgGroups = Collections.synchronizedList(new ArrayList());
    private List<TEILinkGroup> teiLinkGroups = Collections.synchronizedList(new ArrayList());
    private List<TGLine> dockingLines = null;
    private TGShape.WRITING_MODE defaultWritingMode = TGShape.WRITING_MODE.NONE;

    public TEIDocFactory(LinksContainer links, boolean inBackground) {
        this.links = links;
        this.inBackground = inBackground;
        this.omFactory = OMAbstractFactory.getOMFactory();
    }

    public OMElement createTeiDocument(String parentPath, IProgressMonitor monitor) throws UnsupportedEncodingException, XMLStreamException, FactoryConfigurationError {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        this.teiNS = this.omFactory.createOMNamespace(TEI_NS_URI, TEI_NS_Prefix);
        this.tei = this.omFactory.createOMElement("TEI", this.teiNS);
        this.xmlNS = this.omFactory.createOMNamespace(XML_NS_URI, XML_NS_Prefix);
        this.svgNS = this.omFactory.createOMNamespace(SVG_NS_URI, SVG_NS_Prefix);
        this.xlinkNS = this.omFactory.createOMNamespace(XLINK_NS_URI, XLINK_NS_Prefix);
        this.tei.declareNamespace(this.xmlNS);
        this.tei.declareNamespace(this.svgNS);
        this.tei.declareNamespace(this.xlinkNS);
        monitor.worked(10);
        String header_text = "<teiHeader><fileDesc><titleStmt><title>Text-Image-Link Object</title></titleStmt><publicationStmt><p/></publicationStmt><sourceDesc><p/></sourceDesc></fileDesc></teiHeader>";
        this.teiHeader = StringToOM.getOMElement((String)header_text);
        this.setNamespaceRecursive(this.teiHeader, this.teiNS);
        this.tei.addChild((OMNode)this.teiHeader);
        OMElement facsimile = this.omFactory.createOMElement("facsimile", this.teiNS, (OMContainer)this.tei);
        this.svg = this.omFactory.createOMElement("svg", this.svgNS, (OMContainer)facsimile);
        OMElement text = this.omFactory.createOMElement("text", this.teiNS, (OMContainer)this.tei);
        OMElement body = this.omFactory.createOMElement("body", this.teiNS, (OMContainer)text);
        this.ab = this.omFactory.createOMElement("ab", this.teiNS, (OMContainer)body);
        monitor.worked(10);
        this.addLinksToDocument(parentPath);
        monitor.worked(10);
        return this.tei;
    }

    public void addDockingLines(List<TGLine> dockingLines2) {
        this.dockingLines = dockingLines2;
    }

    public void replaceUris(Map<String, String> urisMap) {
        String teiString = this.tei.toString();
        for (String first : urisMap.keySet()) {
            teiString = teiString.replace(first, urisMap.get(first));
        }
        try {
            this.tei = StringToOM.getOMElement((String)teiString);
        }
        catch (UnsupportedEncodingException e) {
            Activator.handleError(e);
        }
        catch (XMLStreamException e) {
            Activator.handleError(e);
        }
        catch (FactoryConfigurationError e) {
            Activator.handleError(e);
        }
    }

    public boolean makePersistent(IFile file, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.worked(20);
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            XMLPrettyPrinter.prettify(this.tei, resultStream);
            file.setContents((InputStream)new ByteArrayInputStream(resultStream.toString("UTF-8").getBytes("UTF-8")), 1, monitor);
            monitor.worked(30);
            return true;
        }
        catch (Exception e) {
            Activator.handleError(e);
            return false;
        }
    }

    public boolean makePersistent(File file, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try (FileOutputStream out = null;){
                out = new FileOutputStream(file);
                XMLPrettyPrinter.prettify(this.tei, out);
            }
            monitor.worked(50);
            return true;
        }
        catch (Exception e) {
            Activator.handleError(e);
            return false;
        }
    }

    private void addLinksToDocument(String parentPath) {
        TreeSet<String> imageUris = new TreeSet<String>();
        for (ILink l : this.links) {
            imageUris.add(l.getImageUri());
        }
        int svgGrpId = 1;
        int teiLinkGrpId = 1;
        int shapeId = 1;
        int textId = 1;
        int dockLineId = 1;
        for (final String string : imageUris) {
            Point imageWH = LinkEditorController.getInstance().getImageWidthHeight(string);
            if (this.inBackground) {
                UIJob j1 = new UIJob(""){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        TEIDocFactory.this.defaultWritingMode = LinkEditorController.getInstance().getDefaultWritingMode(string);
                        return Status.OK_STATUS;
                    }
                };
                j1.schedule();
                try {
                    j1.join();
                }
                catch (InterruptedException e) {
                    Activator.handleWarning(e);
                }
            } else {
                this.defaultWritingMode = LinkEditorController.getInstance().getDefaultWritingMode(string);
            }
            SVGGroup svgGrp = new SVGGroup("textgrid-layer-" + svgGrpId++, this.defaultWritingMode);
            svgGrp.setImage(new SVGImage(TEIDocFactory.getRelativeUri(string, parentPath), imageWH.x, imageWH.y));
            TEILinkGroup teiLinkGrp = new TEILinkGroup("text-image-links-" + teiLinkGrpId++);
            for (ILink iLink : this.links) {
                if (!iLink.getImageUri().equals(string)) continue;
                String _shapeId = "shape-" + shapeId++;
                String _textId = "text-" + textId++;
                TGShape shape = iLink.getShape();
                svgGrp.addShape(new SVGShape(_shapeId, shape, imageWH.x, imageWH.y));
                svgGrp.addText(new SVGText(_textId, shape.getWritingMode()));
                teiLinkGrp.addLink(new TEILink(_shapeId, iLink, parentPath));
                teiLinkGrp.addLink(new TEILink(_textId, iLink, parentPath));
            }
            if (this.dockingLines != null && !this.dockingLines.isEmpty()) {
                for (TGLine tGLine : this.dockingLines) {
                    if (!tGLine.getImageUri().equals(string)) continue;
                    svgGrp.addShape(new SVGShape("dockline-" + dockLineId++, (TGShape)tGLine, imageWH.x, imageWH.y));
                }
            }
            teiLinkGrp.setSvgGrp(svgGrp);
            this.svgGroups.add(svgGrp);
            this.teiLinkGroups.add(teiLinkGrp);
        }
        for (SVGGroup sVGGroup : this.svgGroups) {
            sVGGroup.createOMElement(this.omFactory, this.svg, this.svgNS);
        }
        for (TEILinkGroup tEILinkGroup : this.teiLinkGroups) {
            tEILinkGroup.createOMElement(this.omFactory, this.ab, this.teiNS);
        }
    }

    public static String getRelativeUri(String uri, String parentPath) {
        if (parentPath == null || !uri.startsWith("file")) {
            return uri;
        }
        String relativeUri = uri;
        String parentUri = new File(parentPath).toURI().toString();
        relativeUri = uri.replace(parentUri, "");
        return relativeUri;
    }

    private void setNamespaceRecursive(OMElement elem, OMNamespace ns) {
        elem.setNamespace(ns);
        Iterator children = elem.getChildElements();
        while (children.hasNext()) {
            OMElement e = (OMElement)children.next();
            e.setNamespace(ns);
            this.setNamespaceRecursive(e, ns);
        }
    }

    public static void main(String[] args) {
        try {
            TEIDocFactory f = new TEIDocFactory(new LinksContainer(), false);
            OMElement tei = f.createTeiDocument("Desktop", null);
            XMLPrettyPrinter.prettify(tei, System.out);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

