/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.navigator;

import com.google.common.collect.ImmutableSet;
import info.textgrid.lab.conf.ConfPlugin;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.client.ConfClient;
import info.textgrid.lab.core.aggregations.ui.treeWriter.AggregationWriter;
import info.textgrid.lab.core.model.AggregationReader;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.model.TextGridProject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.navigator.Activator;
import info.textgrid.lab.navigator.CopyService;
import info.textgrid.lab.navigator.Messages;
import info.textgrid.lab.navigator.NaviView;
import info.textgrid.lab.ui.core.DropSetValues;
import info.textgrid.middleware.tgsearch.client.SearchClient;
import info.textgrid.namespaces.middleware.tgsearch.EntryType;
import info.textgrid.namespaces.middleware.tgsearch.PathGroupType;
import info.textgrid.namespaces.middleware.tgsearch.PathResponse;
import info.textgrid.namespaces.middleware.tgsearch.PathType;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.navigator.CommonDropAdapter;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class CommonDropAdapterAssistant
extends org.eclipse.ui.navigator.CommonDropAdapterAssistant {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IStatus handleDrop(CommonDropAdapter aDropAdapter, DropTargetEvent aDropTargetEvent, Object aTarget) {
        if (aDropTargetEvent.data == null) return Status.CANCEL_STATUS;
        if (aDropTargetEvent.data instanceof TreeSelection) {
            try {
                LocalSelectionTransfer localTransfer = LocalSelectionTransfer.getTransfer();
                if (aTarget instanceof TextGridProject) {
                    IStatus status = this.dropToProject((TextGridProject)aTarget, localTransfer);
                    if (status.isOK()) return Status.OK_STATUS;
                    return status;
                }
                if (!(aTarget instanceof TGObjectReference)) return Status.OK_STATUS;
                this.dropToAggregation(aTarget, localTransfer);
                return Status.OK_STATUS;
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.navigator");
                return Status.CANCEL_STATUS;
            }
            catch (OfflineException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.navigator", e.getLocalizedMessage(), (Throwable)e), 2);
                return Status.OK_STATUS;
            }
        } else {
            this.dropFromNonLab(aDropTargetEvent, aTarget);
        }
        return Status.OK_STATUS;
    }

    private void dropFromNonLab(DropTargetEvent aDropTargetEvent, Object aTarget) {
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ICommandService.class);
        Command command = commandService.getCommand("info.textgrid.lab.core.importexport.import");
        try {
            IParameter parameter = command.getParameter("info.textgrid.lab.core.importexport.import.usedroppedset");
            Parameterization parm = new Parameterization(parameter, "true");
            ParameterizedCommand parmCommand = new ParameterizedCommand(command, new Parameterization[]{parm});
            DropSetValues.setValues((String[])((String[])aDropTargetEvent.data));
            if (aTarget instanceof TextGridProject) {
                DropSetValues.setProject((TextGridProject)((TextGridProject)aTarget));
            }
            handlerService.executeCommand(parmCommand, null);
        }
        catch (NotDefinedException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
        }
        catch (ExecutionException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
        }
        catch (NotEnabledException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
        }
        catch (NotHandledException e) {
            Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotOpenImportPerspective, aTarget);
        }
    }

    private IStatus dropToAggregation(Object aTarget, LocalSelectionTransfer localTransfer) throws CoreException, OfflineException {
        final TextGridObject target = ((TGObjectReference)aTarget).getTgo();
        target.refreshWorkspaceIfNeccessary();
        final HashMap<TextGridObject, LinkedList<String>> aggregationMap = new HashMap<TextGridObject, LinkedList<String>>();
        final List targetsCurrentContent = AggregationReader.read((TextGridObject)target, (boolean)false);
        ArrayList<TGObjectReference> movedTGOs = new ArrayList<TGObjectReference>();
        if (localTransfer.getSelection() instanceof TreeSelection) {
            TreeSelection droppedSelection = (TreeSelection)localTransfer.getSelection();
            for (Object droppedItem : droppedSelection) {
                if (droppedItem instanceof TGObjectReference) {
                    URI droppedURI = ((TGObjectReference)droppedItem).getTgo().getPreparedURI();
                    ImmutableSet<URI> targetAncestors = this.getAncestors(target.getURI());
                    if (targetAncestors.contains((Object)this.toLatestURI(droppedURI))) {
                        this.reportAggregationCycle();
                        return Status.CANCEL_STATUS;
                    }
                    if (!this.confirmMove()) {
                        return Status.CANCEL_STATUS;
                    }
                }
                targetsCurrentContent.add(URI.create(((TGObjectReference)droppedItem).getTgo().getLatestURI()));
                movedTGOs.add((TGObjectReference)droppedItem);
                if (!((TGObjectReference)droppedItem).isPartOfAggregation()) continue;
                TextGridObject aggregation = ((TGObjectReference)droppedItem).getAggregation().getTgo();
                LinkedList<String> list = (LinkedList<String>)aggregationMap.get(aggregation);
                if (list == null) {
                    list = new LinkedList<String>();
                }
                list.add(((TGObjectReference)droppedItem).getRefUri());
                aggregationMap.put(aggregation, list);
            }
        }
        for (TGObjectReference ref : movedTGOs) {
            ref.setAggregation((TGObjectReference)aTarget);
        }
        Job saveJob = new Job(NLS.bind((String)Messages.CommonDropAdapterAssistant_IM_SavingAggregation, (Object)target)){

            protected IStatus run(IProgressMonitor monitor) {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)Messages.CommonDropAdapterAssistant_IM_SavingAggregaion, (Object)target), (int)(100 + 100 * aggregationMap.entrySet().size()));
                try {
                    IFile file = (IFile)AdapterUtils.getAdapterChecked((Object)target, IFile.class);
                    InputStream aggregationContent = AggregationWriter.getAggregationStream((List)targetsCurrentContent);
                    file.setContents(aggregationContent, true, false, (IProgressMonitor)progress.newChild(targetsCurrentContent.size()));
                    for (Map.Entry e : aggregationMap.entrySet()) {
                        TextGridObject sourceAggregation = (TextGridObject)e.getKey();
                        List val = (List)e.getValue();
                        LinkedList<URI> sourceURIs = new LinkedList<URI>();
                        try {
                            sourceAggregation.refreshWorkspaceIfNeccessary();
                            List aggregatesSource = AggregationReader.read((TextGridObject)sourceAggregation, (boolean)false);
                            for (URI uri : aggregatesSource) {
                                if (val.remove(uri.toString())) continue;
                                sourceURIs.add(uri);
                            }
                            try {
                                IFile sourceFile = (IFile)AdapterUtils.getAdapterChecked((Object)sourceAggregation, IFile.class);
                                sourceFile.setContents(AggregationWriter.getAggregationStream(sourceURIs), true, false, (IProgressMonitor)progress.newChild(100));
                            }
                            catch (XMLStreamException e2) {
                                Activator.handleError(e2, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, sourceAggregation);
                            }
                            catch (AdapterUtils.AdapterNotFoundException adapterNotFoundException) {
                                StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.navigator", "source equals target -> noop"));
                            }
                            catch (CoreException e2) {
                                Activator.handleError(e2, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, sourceAggregation);
                            }
                        }
                        catch (CoreException e1) {
                            StatusManager.getManager().handle(e1, "info.textgrid.lab.navigator");
                        }
                    }
                }
                catch (XMLStreamException e) {
                    Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, target);
                }
                catch (AdapterUtils.AdapterNotFoundException adapterNotFoundException) {
                    StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.navigator", "source equals target -> noop"));
                }
                catch (CoreException e) {
                    Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotWriteAggregation, target);
                }
                aggregationMap.clear();
                return Status.OK_STATUS;
            }
        };
        saveJob.addJobChangeListener((IJobChangeListener)new PostSaveNavigatorUpdater(movedTGOs, aTarget));
        saveJob.setUser(true);
        saveJob.schedule();
        return Status.OK_STATUS;
    }

    private boolean confirmMove() {
        boolean confirmMove = ConfPlugin.getDefault().getPreferenceStore().getBoolean("movewarning");
        if (confirmMove) {
            MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), Messages.MOVE_ShowReport, null, Messages.MOVE_ReportMessage, 3, new String[]{"OK", Messages.CopyService_Cancel}, 1);
            return messageDialog.open() == 0;
        }
        return true;
    }

    private void reportAggregationCycle() {
        MessageBox dialog = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 33);
        dialog.setText(Messages.MOVE_ShowReport);
        dialog.setMessage(Messages.MOVE_Circle_ReportMessage);
        dialog.open();
    }

    private IStatus dropToProject(TextGridProject aTarget, LocalSelectionTransfer localTransfer) throws CoreException {
        ArrayList<String> tgSelectionUris = new ArrayList<String>();
        String targetName = aTarget.getId();
        if (localTransfer.getSelection() instanceof TreeSelection) {
            TreeSelection treeSelection = (TreeSelection)localTransfer.getSelection();
            for (Object next : treeSelection) {
                TextGridObject tgo1 = (TextGridObject)AdapterUtils.getAdapter(next, TextGridObject.class);
                if (tgo1 == null) continue;
                if (tgo1.getProject().equals(targetName)) {
                    StatusManager.getManager().handle((IStatus)new Status(2, "info.textgrid.lab.navigator", "source equals target -> noop"));
                    return Status.CANCEL_STATUS;
                }
                tgSelectionUris.add(tgo1.getURI().toString());
            }
            CopyService.getInstance().copy(tgSelectionUris, targetName);
        }
        return Status.OK_STATUS;
    }

    private URI toLatestURI(URI uri) {
        return URI.create(uri.toString().split("\\.")[0]);
    }

    private ImmutableSet<URI> getAncestors(URI uri) throws OfflineException {
        ImmutableSet.Builder ancestors = ImmutableSet.builder();
        SearchClient searchClient = new SearchClient(ConfClient.getInstance().getValue("tgsearch"));
        PathResponse pr = searchClient.getPath(uri.toString());
        ancestors.add((Object)this.toLatestURI(uri));
        for (PathGroupType group : pr.getPathGroup()) {
            for (PathType path : group.getPath()) {
                for (EntryType entry : path.getEntry()) {
                    ancestors.add((Object)this.toLatestURI(URI.create(entry.getTextgridUri())));
                }
            }
        }
        return ancestors.build();
    }

    public IStatus validateDrop(Object target, int operation, TransferData transferType) {
        return Status.OK_STATUS;
    }

    public boolean isSupportedType(TransferData aTransferType) {
        return true;
    }

    private final class PostSaveNavigatorUpdater
    extends JobChangeAdapter {
        private final List<TGObjectReference> movedTGOs;
        private final Object aTarget;

        private PostSaveNavigatorUpdater(List<TGObjectReference> movedTGOs, Object aTarget) {
            this.movedTGOs = movedTGOs;
            this.aTarget = aTarget;
        }

        public void done(IJobChangeEvent event) {
            if (event.getResult().isOK()) {
                UIJob uiJob = new UIJob(Messages.CommonDropAdapterAssistant_IM_UpdateNavigatorGUI){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        for (TGObjectReference tgoRef : PostSaveNavigatorUpdater.this.movedTGOs) {
                            try {
                                if (((TGObjectReference)PostSaveNavigatorUpdater.this.aTarget).getTgo().getProjectInstance() == tgoRef.getTgo().getProjectInstance()) {
                                    NaviView.getViewer().remove((Object)tgoRef);
                                }
                            }
                            catch (CoreException e) {
                                Activator.handleError(e, Messages.CommonDropAdapterAssistant_EM_CouldNotUpdateNavigatorGUI, new Object[0]);
                            }
                            NaviView.getViewer().add(PostSaveNavigatorUpdater.this.aTarget, (Object)tgoRef);
                        }
                        return Status.OK_STATUS;
                    }
                };
                uiJob.schedule(500L);
            }
        }
    }
}

