/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.dialogs;

import info.textgrid.lab.core.model.CrudServiceException;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import info.textgrid.lab.xmleditor.dialogs.Messages;
import info.textgrid.lab.xmleditor.mpeditor.Activator;
import java.net.URI;
import java.text.MessageFormat;
import java.util.EnumSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.ITextEditor;

public class SetSchemaDialog
extends TitleAreaDialog
implements ISelectionChangedListener,
SelectionListener {
    static final int TITLE_COLUMN = 0;
    static final int PROJECT_COLUMN = 1;
    private Composite dialogContent;
    private Button noSchema;
    private TextGridObject object;
    private TextGridObjectTableViewer schemaTable;
    private IEditorPart editor = null;

    private void createSchemaTable(Composite parent) {
        this.schemaTable = new TextGridObjectTableViewer(parent, 65540);
        this.schemaTable.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.DATE, TextGridObjectTableViewer.Column.OWNER));
        this.schemaTable.addSelectionChangedListener((ISelectionChangedListener)this);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200).applyTo((Control)this.schemaTable.getTable());
        try {
            URI currentSchemaURI = this.object.getSchemaURI();
            if (currentSchemaURI != null) {
                this.schemaTable.setDefaultSelection(new TextGridObject[]{TextGridObject.getInstanceOffline((URI)currentSchemaURI)});
            }
        }
        catch (CrudServiceException e) {
            Activator.handleProblem(4, e, Messages.SetSchemaDialog_CouldNotDetermineSchema, this.object, e.getMessage());
        }
        this.schemaTable.queryMetadata("( format:\"text/xsd+xml\" )");
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogContent = new Composite(parent, 0);
        this.dialogArea = this.dialogContent;
        GridLayoutFactory.fillDefaults().applyTo(this.dialogContent);
        GridDataFactory.fillDefaults().hint(-1, 400).grab(true, true).applyTo((Control)this.dialogContent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.dialogArea, "info.textgrid.lab.xmleditor.mpeditor.SetSchemaDialog");
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "info.textgrid.lab.xmleditor.mpeditor.SetSchemaDialog");
        Label currentSchema = new Label(this.dialogContent, 64);
        GridDataFactory.fillDefaults().grab(true, false).hint(400, -1).applyTo((Control)currentSchema);
        URI schemaURI = null;
        try {
            schemaURI = this.object.getSchemaURI();
            if (schemaURI != null) {
                int severity;
                TextGridObject schema = TextGridObject.getInstance((URI)schemaURI, (boolean)true);
                IFile schemaFile = (IFile)AdapterUtils.getAdapter((Object)schema, IFile.class);
                int n = severity = schemaFile == null ? 2 : schemaFile.findMaxProblemSeverity(null, true, 0);
                if (severity >= 2) {
                    currentSchema.setText(MessageFormat.format(Messages.SetSchemaDialog_SchemaFailedLastTime, schema, this.object));
                } else {
                    currentSchema.setText(MessageFormat.format(Messages.SetSchemaDialog_CurentSchemaMessage, this.object.getTitle(), schema.getTitle(), schema.getProject(), schema.getURI()));
                }
            } else {
                currentSchema.setText(MessageFormat.format(Messages.SetSchemaDialog_NoSchemaMessage, this.object.getTitle()));
            }
        }
        catch (CoreException e) {
            Activator.handleProblem(4, e, Messages.SetSchemaDialog_NoInfoMessage, this.object, e.getMessage());
        }
        this.createSchemaTable(this.dialogContent);
        this.noSchema = new Button(this.dialogContent, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.noSchema);
        this.noSchema.setText(Messages.SetSchemaDialog_NoSchemaButton);
        this.noSchema.addSelectionListener((SelectionListener)this);
        this.noSchema.setToolTipText(Messages.SetSchemaDialog_NoSchemaTooltip);
        this.noSchema.setSelection(schemaURI == null);
        Label saveWarning = new Label(this.dialogContent, 16448);
        saveWarning.setImage(JFaceResources.getImage((String)"dialog_messasge_warning_image"));
        saveWarning.setText(Messages.SetSchemaDialog_SaveWarning);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)saveWarning);
        this.getShell().setText(Messages.SetSchemaDialog_SelectSchemaShellTitle);
        this.setTitle(Messages.SetSchemaDialog_SelectSchemaDlgTitle);
        try {
            this.setMessage(NLS.bind((String)Messages.SetSchemaDialog_SelectSchemaDlgMessage, (Object)this.object.getTitle()));
        }
        catch (CoreException e) {
            Activator.handleProblem(2, e, Messages.SetSchemaDialog_CouldNotFetchTitle, this.object, e.getLocalizedMessage());
        }
        return this.dialogArea;
    }

    public SetSchemaDialog(Shell parentShell, TextGridObject object, IEditorPart editor) {
        super(parentShell);
        Assert.isNotNull((Object)object, (String)"Cannot associate a schema to a null object ...");
        this.object = object;
        this.editor = editor;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.getButton(0).setEnabled(event.getSelection() != null);
        if (event.getSelectionProvider() == this.schemaTable && !event.getSelection().isEmpty()) {
            this.noSchema.setSelection(false);
        }
        if (!this.schemaTable.getSelection().isEmpty()) {
            IFile schemaFile = (IFile)AdapterUtils.getAdapter((Object)((IStructuredSelection)this.schemaTable.getSelection()).getFirstElement(), IFile.class);
            try {
                IMarker[] markers = schemaFile.findMarkers(null, true, 2);
                StringBuilder errorMessage = new StringBuilder();
                IMarker[] iMarkerArray = markers;
                int n = markers.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarker marker = iMarkerArray[n2];
                    if (marker.getAttribute("severity", 0) >= 2) {
                        errorMessage.append(marker.getAttribute("message")).append("\n");
                    }
                    ++n2;
                }
                if (errorMessage.length() > 0) {
                    this.setErrorMessage(NLS.bind((String)Messages.SetSchemaDialog_Problems, (Object)errorMessage));
                } else {
                    this.setErrorMessage(null);
                }
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.xmleditor.mpeditor");
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        e.doit = true;
        if (e.widget == this.noSchema && this.noSchema.getSelection()) {
            this.schemaTable.setSelection((ISelection)new StructuredSelection());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected void okPressed() {
        if (this.noSchema.getSelection()) {
            this.object.deleteSchema();
        } else {
            this.object.setSchema(((TextGridObject)((IStructuredSelection)this.schemaTable.getSelection()).getFirstElement()).getURI());
        }
        IFile file = (IFile)AdapterUtils.getAdapter((Object)this.object, IFile.class);
        if (file != null) {
            try {
                file.deleteMarkers(null, true, 2);
            }
            catch (CoreException e) {
                StatusManager.getManager().handle(e, "info.textgrid.lab.xmleditor.mpeditor");
            }
        }
        if (this.editor != null) {
            if (this.editor instanceof MultiPageEditorPart) {
                IEditorPart[] editors;
                IEditorPart[] iEditorPartArray = editors = ((MultiPageEditorPart)this.editor).findEditors(this.editor.getEditorInput());
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorPart editorPage = iEditorPartArray[n2];
                    this.markEditorChanged(editorPage);
                    ++n2;
                }
            } else {
                this.markEditorChanged(this.editor);
            }
        }
        super.okPressed();
    }

    private void markEditorChanged(IEditorPart editor) {
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            try {
                textEditor.getDocumentProvider().getDocument((Object)editor.getEditorInput()).replace(0, 0, "");
            }
            catch (BadLocationException badLocationException) {}
        }
    }
}

