/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.search.ui.text.ISearchEditorAccess;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.ui.part.MultiPageSelectionProvider;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.contentoutline.IJFaceNodeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.contenttype.ContentTypeIdForXML;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.contentoutline.JFaceNodeLabelProvider;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLEditorMessages;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLMultiPageEditorActionBarContributor;
import org.eclipse.wst.xml.ui.internal.tabletree.XMLTableTreeViewer;
import org.w3c.dom.Node;

public abstract class AbstractXMLMultiPageEditorPart
extends MultiPageEditorPart {
    private int fDesignPageIndex;
    private IDesignViewer fDesignViewer;
    private ActivationListener fActivationListener;
    IPropertyListener fPropertyListener = null;
    private int fSourcePageIndex;
    private StructuredTextEditor fTextEditor;
    private TextEditorPostSelectionAdapter fTextEditorSelectionListener;
    private ILabelProvider fStatusLineLabelProvider = new StatusLineLabelProvider();

    void _firePropertyChange(int property) {
        super.firePropertyChange(property);
    }

    private void addSourcePage() throws PartInitException {
        this.fSourcePageIndex = this.addPage((IEditorPart)this.fTextEditor, this.getEditorInput());
        this.setPageText(this.fSourcePageIndex, XMLEditorMessages.XMLMultiPageEditorPart_0);
        this.firePropertyChange(1);
        this.fTextEditor.getTextViewer().addTextInputListener((ITextInputListener)new TextInputListener());
    }

    protected void connectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
        if (this.fDesignViewer.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.fDesignViewer.getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ((MultiPageSelectionProvider)AbstractXMLMultiPageEditorPart.this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
                }
            });
        }
        this.fDesignViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((MultiPageSelectionProvider)AbstractXMLMultiPageEditorPart.this.getSite().getSelectionProvider()).fireSelectionChanged(event);
            }
        });
        if (this.fDesignViewer.getSelectionProvider() instanceof IPostSelectionProvider) {
            ((IPostSelectionProvider)this.fDesignViewer.getSelectionProvider()).addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (AbstractXMLMultiPageEditorPart.this.getActivePage() != AbstractXMLMultiPageEditorPart.this.fSourcePageIndex) {
                        AbstractXMLMultiPageEditorPart.this.getTextEditor().getSelectionProvider().setSelection(event.getSelection());
                    }
                    if (AbstractXMLMultiPageEditorPart.this.fDesignViewer.equals(event.getSource())) {
                        try {
                            AbstractXMLMultiPageEditorPart.this.updateStatusLine(event.getSelection());
                        }
                        catch (Exception exception) {
                            Logger.logException((Throwable)exception);
                        }
                    }
                }
            });
        } else {
            this.fDesignViewer.getSelectionProvider().addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (AbstractXMLMultiPageEditorPart.this.getActivePage() != AbstractXMLMultiPageEditorPart.this.fSourcePageIndex) {
                        AbstractXMLMultiPageEditorPart.this.getTextEditor().getSelectionProvider().setSelection(event.getSelection());
                    }
                }
            });
        }
        this.fDesignViewer.getControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                ISelection selection = AbstractXMLMultiPageEditorPart.this.fDesignViewer.getSelectionProvider().getSelection();
                int start = -1;
                int length = -1;
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    Object o = structuredSelection.getFirstElement();
                    Object o2 = null;
                    o2 = structuredSelection.size() > 1 ? structuredSelection.toArray()[structuredSelection.size() - 1] : o;
                    if (o instanceof IndexedRegion) {
                        start = ((IndexedRegion)o).getStartOffset();
                        length = ((IndexedRegion)o2).getEndOffset() - start;
                    } else if (o2 instanceof ITextRegion) {
                        start = ((ITextRegion)o).getStart();
                        length = ((ITextRegion)o2).getEnd() - start;
                    }
                } else if (selection instanceof ITextSelection) {
                    start = ((ITextSelection)selection).getOffset();
                    length = ((ITextSelection)selection).getLength();
                }
                if (start > -1 && length > -1) {
                    AbstractXMLMultiPageEditorPart.this.getTextEditor().selectAndReveal(start, length);
                }
            }
        });
        ISelectionProvider provider = this.getTextEditor().getSelectionProvider();
        if (this.fTextEditorSelectionListener == null) {
            this.fTextEditorSelectionListener = new TextEditorPostSelectionAdapter();
        }
        if (provider instanceof IPostSelectionProvider) {
            this.fTextEditorSelectionListener.forcePostSelection = false;
            ((IPostSelectionProvider)provider).addPostSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        } else {
            this.fTextEditorSelectionListener.forcePostSelection = true;
            provider.addSelectionChangedListener((ISelectionChangedListener)this.fTextEditorSelectionListener);
        }
    }

    private void createAndAddDesignPage() {
        IDesignViewer designViewer;
        this.fDesignViewer = designViewer = this.createDesignPage();
        this.fDesignPageIndex = this.addPage(designViewer.getControl());
        this.setPageText(this.fDesignPageIndex, designViewer.getTitle());
    }

    protected IDesignViewer createDesignPage() {
        XMLTableTreeViewer tableTreeViewer = new XMLTableTreeViewer(this.getContainer());
        XMLUIPlugin.getInstance().getWorkbench().getHelpSystem().setHelp(tableTreeViewer.getControl(), "org.eclipse.wst.xml.ui.xmlm3000");
        return tableTreeViewer;
    }

    protected void createPages() {
        try {
            int activePageIndex;
            this.createSourcePage();
            this.createAndAddDesignPage();
            this.addSourcePage();
            this.connectDesignPage();
            IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
            if (contributor instanceof MultiPageEditorActionBarContributor) {
                ((MultiPageEditorActionBarContributor)contributor).setActiveEditor((IEditorPart)this);
            }
            if ((activePageIndex = this.getPreferenceStore().getInt("lastActivePage")) >= 0 && activePageIndex < this.getPageCount()) {
                this.setActivePage(activePageIndex);
            } else {
                this.setActivePage(this.fSourcePageIndex);
            }
        }
        catch (PartInitException e) {
            Logger.logException((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected IEditorSite createSite(IEditorPart editor) {
        Object site = null;
        site = editor == this.fTextEditor ? new MultiPageEditorSite(this, editor){

            public IEditorActionBarContributor getActionBarContributor() {
                IEditorActionBarContributor contributor = super.getActionBarContributor();
                IEditorActionBarContributor multiContributor = AbstractXMLMultiPageEditorPart.this.getEditorSite().getActionBarContributor();
                if (multiContributor instanceof XMLMultiPageEditorActionBarContributor) {
                    contributor = ((XMLMultiPageEditorActionBarContributor)multiContributor).sourceViewerActionContributor;
                }
                return contributor;
            }

            public String getId() {
                return String.valueOf(ContentTypeIdForXML.ContentTypeID_XML) + ".source";
            }
        } : super.createSite(editor);
        return site;
    }

    protected void createSourcePage() throws PartInitException {
        this.fTextEditor = this.createTextEditor();
        this.fTextEditor.setEditorPart((IEditorPart)this);
        if (this.fPropertyListener == null) {
            this.fPropertyListener = new PropertyListener();
        }
        this.fTextEditor.addPropertyListener(this.fPropertyListener);
    }

    private StructuredTextEditor createTextEditor() {
        return new StructuredTextEditor();
    }

    private void disconnectDesignPage() {
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(null);
        }
    }

    public void dispose() {
        Logger.trace((String)"Source Editor", (String)"XMLMultiPageEditorPart::dispose entry");
        this.disconnectDesignPage();
        if (this.fActivationListener != null) {
            this.fActivationListener.dispose();
            this.fActivationListener = null;
        }
        if (this.fTextEditor != null && this.fPropertyListener != null) {
            this.fTextEditor.removePropertyListener(this.fPropertyListener);
        }
        super.dispose();
        Logger.trace((String)"Source Editor", (String)"StructuredTextMultiPageEditorPart::dispose exit");
    }

    public void doSave(IProgressMonitor monitor) {
        this.fTextEditor.doSave(monitor);
    }

    public void doSaveAs() {
        this.fTextEditor.doSaveAs();
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
    }

    public Object getAdapter(Class key) {
        Object result = null;
        result = super.getAdapter(key);
        if (result == null) {
            if (key == IDesignViewer.class) {
                result = this.fDesignViewer;
            } else if (key.equals(IGotoMarker.class)) {
                result = new IGotoMarker(){

                    public void gotoMarker(IMarker marker) {
                        AbstractXMLMultiPageEditorPart.this.gotoMarker(marker);
                    }
                };
            } else if (ISearchEditorAccess.class.equals((Object)key)) {
                result = new ISearchEditorAccess(){

                    public IDocument getDocument(Match match) {
                        IDocument document = null;
                        if (AbstractXMLMultiPageEditorPart.this.fTextEditor != null) {
                            document = AbstractXMLMultiPageEditorPart.this.fTextEditor.getDocumentProvider().getDocument((Object)AbstractXMLMultiPageEditorPart.this.fTextEditor.getEditorInput());
                        }
                        return document;
                    }

                    public IAnnotationModel getAnnotationModel(Match match) {
                        IAnnotationModel annoModel = null;
                        if (AbstractXMLMultiPageEditorPart.this.fTextEditor != null) {
                            annoModel = AbstractXMLMultiPageEditorPart.this.fTextEditor.getDocumentProvider().getAnnotationModel((Object)AbstractXMLMultiPageEditorPart.this.fTextEditor.getEditorInput());
                        }
                        return annoModel;
                    }
                };
            } else if (this.fTextEditor != null) {
                result = this.fTextEditor.getAdapter(key);
            }
        }
        return result;
    }

    protected IDocument getDocument() {
        IDocument document = null;
        if (this.fTextEditor != null) {
            document = this.fTextEditor.getDocumentProvider().getDocument((Object)this.fTextEditor.getEditorInput());
        }
        return document;
    }

    private IPreferenceStore getPreferenceStore() {
        return XMLUIPlugin.getDefault().getPreferenceStore();
    }

    protected StructuredTextEditor getTextEditor() {
        return this.fTextEditor;
    }

    public String getTitle() {
        String title = null;
        if (this.getTextEditor() == null) {
            if (this.getEditorInput() != null) {
                title = this.getEditorInput().getName();
            }
        } else {
            title = this.getTextEditor().getTitle();
        }
        if (title == null) {
            title = this.getPartName();
        }
        return title;
    }

    void gotoMarker(IMarker marker) {
        this.setActivePage(this.fSourcePageIndex);
        IDE.gotoMarker((IEditorPart)this.fTextEditor, (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        try {
            super.init(site, input);
            this.fActivationListener = new ActivationListener(site.getWorkbenchWindow().getPartService());
        }
        catch (Exception e) {
            Logger.logException((String)("exception initializing " + ((Object)((Object)this)).getClass().getName()), (Throwable)e);
        }
        this.setPartName(input.getName());
    }

    public boolean isSaveAsAllowed() {
        return this.fTextEditor != null && this.fTextEditor.isSaveAsAllowed();
    }

    public boolean isSaveOnCloseNeeded() {
        if (this.fTextEditor != null) {
            return this.fTextEditor.isSaveOnCloseNeeded();
        }
        return this.isDirty();
    }

    protected void pageChange(int newPageIndex) {
        ISelectionProvider selectionProvider;
        super.pageChange(newPageIndex);
        this.saveLastActivePageIndex(newPageIndex);
        if (newPageIndex == this.fDesignPageIndex && (selectionProvider = this.fDesignViewer.getSelectionProvider()) != null) {
            SelectionChangedEvent event = new SelectionChangedEvent(selectionProvider, selectionProvider.getSelection());
            ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).fireSelectionChanged(event);
            ((MultiPageSelectionProvider)this.getSite().getSelectionProvider()).firePostSelectionChanged(event);
        }
    }

    private void saveLastActivePageIndex(int newPageIndex) {
        this.getPreferenceStore().setValue("lastActivePage", newPageIndex);
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        if (this.fDesignViewer != null) {
            this.fDesignViewer.setDocument(this.getDocument());
        }
        this.setPartName(input.getName());
    }

    protected void updateStatusLine(ISelection selection) {
        IStatusLineManager statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        if (this.fStatusLineLabelProvider != null && statusLineManager != null) {
            Object firstElement;
            String text = null;
            Image image = null;
            if (selection instanceof IStructuredSelection && !selection.isEmpty() && (firstElement = ((IStructuredSelection)selection).getFirstElement()) != null) {
                text = this.fStatusLineLabelProvider.getText(firstElement);
                image = this.fStatusLineLabelProvider.getImage(firstElement);
            }
            if (image == null) {
                statusLineManager.setMessage(text);
            } else {
                statusLineManager.setMessage(image, text);
            }
        }
    }

    protected IDesignViewer getDesignViewer() {
        return this.fDesignViewer;
    }

    public int getSourcePageIndex() {
        return this.fSourcePageIndex;
    }

    public int getDesignPageIndex() {
        return this.fDesignPageIndex;
    }

    class ActivationListener
    implements IPartListener,
    IWindowListener {
        private IWorkbenchPart fActivePart;
        private boolean fIsHandlingActivation = false;
        private IPartService fPartService;

        public ActivationListener(IPartService partService) {
            this.fPartService = partService;
            this.fPartService.addPartListener((IPartListener)this);
            PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
        }

        public void dispose() {
            this.fPartService.removePartListener((IPartListener)this);
            PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
            this.fPartService = null;
        }

        public void partActivated(IWorkbenchPart part) {
            this.fActivePart = part;
            this.handleActivation();
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            this.fActivePart = null;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        void handleActivation() {
            if (this.fIsHandlingActivation || AbstractXMLMultiPageEditorPart.this.getTextEditor() == null) {
                return;
            }
            if (this.fActivePart == AbstractXMLMultiPageEditorPart.this) {
                this.fIsHandlingActivation = true;
                try {
                    AbstractXMLMultiPageEditorPart.this.getTextEditor().safelySanityCheckState(AbstractXMLMultiPageEditorPart.this.getEditorInput());
                }
                finally {
                    this.fIsHandlingActivation = false;
                }
            }
        }

        public void windowActivated(IWorkbenchWindow window) {
            if (window == AbstractXMLMultiPageEditorPart.this.getEditorSite().getWorkbenchWindow()) {
                window.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        ActivationListener.this.handleActivation();
                    }
                });
            }
        }

        public void windowDeactivated(IWorkbenchWindow window) {
        }

        public void windowClosed(IWorkbenchWindow window) {
        }

        public void windowOpened(IWorkbenchWindow window) {
        }
    }

    class PropertyListener
    implements IPropertyListener {
        PropertyListener() {
        }

        public void propertyChanged(Object source, int propId) {
            switch (propId) {
                case 257: 
                case 258: {
                    if (source != AbstractXMLMultiPageEditorPart.this.getTextEditor() || AbstractXMLMultiPageEditorPart.this.getTextEditor().getEditorInput() == AbstractXMLMultiPageEditorPart.this.getEditorInput()) break;
                    AbstractXMLMultiPageEditorPart.this.setInput(AbstractXMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    Runnable runnable = new Runnable(){

                        @Override
                        public void run() {
                            AbstractXMLMultiPageEditorPart.this._firePropertyChange(1);
                        }
                    };
                    ((Control)AbstractXMLMultiPageEditorPart.this.getTextEditor().getAdapter(Control.class)).getDisplay().asyncExec(runnable);
                    break;
                }
                case 1: {
                    if (source != AbstractXMLMultiPageEditorPart.this.getTextEditor() || AbstractXMLMultiPageEditorPart.this.getTextEditor().getEditorInput() == AbstractXMLMultiPageEditorPart.this.getEditorInput()) break;
                    AbstractXMLMultiPageEditorPart.this.setInput(AbstractXMLMultiPageEditorPart.this.getTextEditor().getEditorInput());
                    break;
                }
                default: {
                    if (source != AbstractXMLMultiPageEditorPart.this.getTextEditor()) break;
                    AbstractXMLMultiPageEditorPart.this._firePropertyChange(propId);
                }
            }
        }
    }

    class StatusLineLabelProvider
    extends JFaceNodeLabelProvider {
        public String getText(Object element) {
            if (element == null) {
                return null;
            }
            StringBuffer s = new StringBuffer();
            Node node = (Node)element;
            if (node.getNodeType() != 9) {
                while (node != null && node instanceof INodeNotifier) {
                    IJFaceNodeAdapter adapter;
                    INodeNotifier notifier = (INodeNotifier)node;
                    if (node.getNodeType() != 9 && (adapter = (IJFaceNodeAdapter)notifier.getAdapterFor(IJFaceNodeAdapter.class)) != null) {
                        s.insert(0, adapter.getLabelText((Object)node));
                    }
                    if ((node = node.getParentNode()) == null || node.getNodeType() == 9) continue;
                    s.insert(0, '/');
                }
            }
            return s.toString();
        }
    }

    private class TextEditorPostSelectionAdapter
    extends UIJob
    implements ISelectionChangedListener {
        boolean forcePostSelection;
        ISelection selection;

        public TextEditorPostSelectionAdapter() {
            super(AbstractXMLMultiPageEditorPart.this.getTitle());
            this.forcePostSelection = false;
            this.selection = null;
            this.setUser(true);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            if (this.selection != null) {
                AbstractXMLMultiPageEditorPart.this.getDesignViewer().getSelectionProvider().setSelection(this.selection);
            }
            return Status.OK_STATUS;
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(AbstractXMLMultiPageEditorPart.this.getDesignViewer() == null || AbstractXMLMultiPageEditorPart.this.getActivePage() == AbstractXMLMultiPageEditorPart.this.getDesignPageIndex() && ((Object)((Object)AbstractXMLMultiPageEditorPart.this)).equals(AbstractXMLMultiPageEditorPart.this.getSite().getPage().getActivePart()))) {
                if (this.forcePostSelection) {
                    this.selection = event.getSelection();
                    this.schedule(200L);
                } else {
                    AbstractXMLMultiPageEditorPart.this.getDesignViewer().getSelectionProvider().setSelection(event.getSelection());
                }
            }
        }
    }

    class TextInputListener
    implements ITextInputListener {
        TextInputListener() {
        }

        public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        }

        public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
            if (AbstractXMLMultiPageEditorPart.this.getDesignViewer() != null && newInput != null) {
                AbstractXMLMultiPageEditorPart.this.getDesignViewer().setDocument(newInput);
            }
        }
    }
}

