/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.xmleditor.multicharbrowser;

import com.ibm.icu.lang.UCharacter;
import com.ibm.icu.lang.UScript;
import info.textgrid.lab.core.swtutils.AdapterUtils;
import info.textgrid.lab.xmleditor.multicharbrowser.ComboContributionItem;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetData;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetDialog;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetResourceReader;
import info.textgrid.lab.xmleditor.multicharbrowser.CustomCharsetTableCombinedItem;
import info.textgrid.lab.xmleditor.multicharbrowser.Messages;
import info.textgrid.lab.xmleditor.multicharbrowser.StreamWriterUtils;
import info.textgrid.lab.xmleditor.multicharbrowser.UnicodeModel;
import info.textgrid.lab.xmleditor.multicharbrowser.UnicodeViewer;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.sf.vex.core.Log;
import net.sf.vex.dom.DocumentValidationException;
import net.sf.vex.editor.VexEditor;
import net.sf.vex.swt.VexWidget;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class UnicodeView
extends ViewPart {
    private UnicodeViewer unicodeViewer;
    private Table table;
    private final ArrayList<String> list = new ArrayList(16);
    private ICommandService commandService;
    private ComboContributionItem comboContrib;
    private IToolBarManager toolBarManager;
    private int toggleState;
    private ActionContributionItem buttonToggleModeLeft;
    private ActionContributionItem buttonToggleModeRight;
    private Action customActionLeft;
    private Action customActionRight;
    private Vector<String> comboItems = null;
    final UnicodeView unicodeView = this;
    public static final int TOGGLE_NONE = 0;
    public static final int TOGGLE_LEFT = 1;
    public static final int TOGGLE_RIGHT = 2;
    public static final int TOGGLE_CUSTOM_LEFT = 3;
    public static final int TOGGLE_CUSTOM_RIGHT = 4;

    private void setupToggleButtonLeft() {
        this.buttonToggleModeLeft = new ActionContributionItem((IAction)new Action("Block", 2){

            public void run() {
                if (UnicodeView.this.toggleState != 1) {
                    UnicodeView.this.comboContrib.updateItems(UnicodeView.getBlockVector());
                    UnicodeView.this.setToggleState(1);
                    UnicodeView.this.toggleButtons();
                    this.setText("Block");
                } else {
                    UnicodeView.this.buttonToggleModeLeft.getAction().setChecked(true);
                }
                UnicodeView.this.changeCharacterSet(UnicodeView.this.comboContrib.getLayersCombo().getItem(UnicodeView.this.comboContrib.getLayersCombo().getSelectionIndex()), true);
            }
        });
        this.buttonToggleModeLeft.getAction().setChecked(true);
        this.buttonToggleModeLeft.getAction().setToolTipText(Messages.UnicodeView_2);
        ImageDescriptor toggleLeftEclipseImage = ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "font-x-generic.png"));
        this.buttonToggleModeLeft.getAction().setImageDescriptor(toggleLeftEclipseImage);
    }

    private void setupToggleButtonRight() {
        this.buttonToggleModeRight = new ActionContributionItem((IAction)new Action("Script", 2){

            public void run() {
                if (UnicodeView.this.toggleState != 2) {
                    UnicodeView.this.comboContrib.updateItems(UnicodeView.this.getScriptVector());
                    UnicodeView.this.setToggleState(2);
                    UnicodeView.this.toggleButtons();
                    this.setText("Script");
                } else {
                    UnicodeView.this.buttonToggleModeRight.getAction().setChecked(true);
                }
                UnicodeView.this.changeCharacterSet(UnicodeView.this.comboContrib.getLayersCombo().getItem(UnicodeView.this.comboContrib.getLayersCombo().getSelectionIndex()), false);
            }
        });
        this.buttonToggleModeRight.getAction().setToolTipText(Messages.UnicodeView_6);
        ImageDescriptor toggleRightEclipseImage = ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "text-x-generic.png"));
        this.buttonToggleModeRight.getAction().setImageDescriptor(toggleRightEclipseImage);
    }

    protected static Vector<String> getBlockVector() {
        Object[] blocks = new String[154];
        int i = 0;
        while (i < 154) {
            blocks[i] = UCharacter.UnicodeBlock.getInstance((int)(i + 1)).toString();
            ++i;
        }
        Arrays.sort(blocks);
        Vector<String> comboItems = new Vector<String>();
        Object[] objectArray = blocks;
        int n = blocks.length;
        int n2 = 0;
        while (n2 < n) {
            Object entry = objectArray[n2];
            if (!((String)entry).equals("LATIN_EXTENDED_D") && !((String)entry).equals("LATIN_EXTENDED_E")) {
                comboItems.add((String)entry);
            }
            ++n2;
        }
        return comboItems;
    }

    private Vector<String> getScriptVector() {
        if (this.comboItems == null) {
            this.initializeScriptVector();
        }
        return this.comboItems;
    }

    private void initializeScriptVector() {
        this.comboItems = new Vector();
        Hashtable<String, Boolean> hashtableScriptHasMembers = new Hashtable<String, Boolean>();
        int i = 0;
        while (i < 161) {
            hashtableScriptHasMembers.put(UScript.getName((int)i), new Boolean(false));
            ++i;
        }
        int i2 = 0;
        while (i2 < 0x10FFFF) {
            String currentScript = UScript.getName((int)UScript.getScript((int)i2));
            boolean isFound = (Boolean)hashtableScriptHasMembers.get(currentScript);
            if (!isFound) {
                hashtableScriptHasMembers.remove(currentScript);
                hashtableScriptHasMembers.put(currentScript, new Boolean(true));
            }
            ++i2;
        }
        Enumeration enums = hashtableScriptHasMembers.keys();
        while (enums.hasMoreElements()) {
            String current = (String)enums.nextElement();
            if (hashtableScriptHasMembers.get(current) == null || !((Boolean)hashtableScriptHasMembers.get(current)).booleanValue()) continue;
            this.comboItems.add(current);
        }
        Collections.sort(this.comboItems);
    }

    protected static String newString(int codePoint) {
        if (Character.charCount(codePoint) == 1) {
            return String.valueOf((char)codePoint);
        }
        return new String(Character.toChars(codePoint));
    }

    public void changeCharacterSet(String newCharSet, boolean isBlock) {
        this.comboContrib.setComboContribSelection(newCharSet);
        this.unicodeViewer.changeViewerCharset(newCharSet, isBlock);
    }

    public void changeCharacterSet(String[] customChars) {
        this.unicodeViewer.changeViewerCharset(customChars);
    }

    public void toggleButtons() {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = this.getViewSite().getActionBars().getMenuManager().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IContributionItem contribItem = iContributionItemArray[n2];
            if (contribItem instanceof ActionContributionItem) {
                Action action = (Action)((ActionContributionItem)contribItem).getAction();
                action.setChecked(false);
            }
            ++n2;
        }
        this.buttonToggleModeLeft.getAction().setChecked(false);
        this.buttonToggleModeRight.getAction().setChecked(false);
        this.comboContrib.getComboBox().setEnabled(false);
        switch (this.toggleState) {
            case 1: {
                this.buttonToggleModeLeft.getAction().setChecked(true);
                this.comboContrib.getComboBox().setEnabled(true);
                break;
            }
            case 2: {
                this.buttonToggleModeRight.getAction().setChecked(true);
                this.comboContrib.getComboBox().setEnabled(true);
                break;
            }
            case 3: {
                if (this.customActionLeft == null) break;
                this.customActionLeft.setChecked(true);
                break;
            }
            case 4: {
                if (this.customActionRight == null) break;
                this.customActionRight.setChecked(true);
                break;
            }
        }
    }

    public void createPartControl(final Composite parent) {
        this.unicodeViewer = new UnicodeViewer(parent, this);
        this.table = this.unicodeViewer.getTable();
        this.table.setVisible(true);
        this.toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        Action selectFontAction = new Action(){

            public void run() {
                FontDialog dialog = new FontDialog(parent.getShell(), 0);
                dialog.setText("Unicode Table Font");
                FontData fontData = dialog.open();
                if (fontData != null) {
                    UnicodeView.this.unicodeViewer.setCurrentFontName(fontData.getName());
                }
            }
        };
        selectFontAction.setDescription("Select font ...");
        selectFontAction.setImageDescriptor(ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "preferences-desktop-font.png")));
        this.toolBarManager.add((IContributionItem)new ActionContributionItem((IAction)selectFontAction));
        this.setupToggleButtonLeft();
        this.toolBarManager.add((IContributionItem)this.buttonToggleModeLeft);
        this.setupToggleButtonRight();
        this.toolBarManager.add((IContributionItem)this.buttonToggleModeRight);
        this.setToggleState(1);
        this.comboContrib = new ComboContributionItem(UnicodeView.getBlockVector(), this);
        this.toolBarManager.add((IContributionItem)this.comboContrib);
        this.toolBarManager.add((IContributionItem)new Separator());
        this.createCustomCharsetItems(true);
        this.changeCharacterSet(UnicodeView.getBlockVector().get(95), true);
    }

    public void createCustomCharsetItems(boolean isFirstRun) {
        IMenuManager menuManager = this.getViewSite().getActionBars().getMenuManager();
        menuManager.removeAll();
        ImageDescriptor genericImage = new ImageDescriptor(){

            public ImageData getImageData() {
                return ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "image-missing.png")).getImageData();
            }
        };
        CustomCharsetResourceReader.loadCustomCharsetsFromFile();
        Vector<CustomCharsetData> dataVector = CustomCharsetResourceReader.getDataVector();
        CustomCharsetData mathematicalSymbolsData = new CustomCharsetData();
        mathematicalSymbolsData.name = "Mathematical Symbols";
        mathematicalSymbolsData.unicodeBlockset = "MATHEMATICAL_OPERATORS";
        mathematicalSymbolsData.isBlock = true;
        mathematicalSymbolsData.imageLocation = "$Bundle$icons/character-sum.png";
        dataVector.insertElementAt(mathematicalSymbolsData, 0);
        CustomCharsetData musicalSymbolsData = new CustomCharsetData();
        musicalSymbolsData.name = "Musical Symbols";
        musicalSymbolsData.unicodeBlockset = "MUSICAL_SYMBOLS";
        musicalSymbolsData.font = "Euterpe";
        musicalSymbolsData.isBlock = true;
        musicalSymbolsData.imageLocation = "$Bundle$icons/character-note.png";
        dataVector.insertElementAt(musicalSymbolsData, 1);
        int iterator = 0;
        while (iterator < dataVector.size()) {
            final CustomCharsetData charset = dataVector.get(iterator);
            final int iteratorPlusThree = iterator + 3;
            Action charsetAction = charset.getCustomCharsetTable() == null ? new Action(charset.getName(), 2){

                public void run() {
                    UnicodeView.this.unicodeViewer.changeViewerCharset(charset.getUnicodeBlockset(), charset.isIsBlock());
                    UnicodeView.this.unicodeViewer.setCurrentFontName(charset.getFont());
                    UnicodeView.this.setToggleState(iteratorPlusThree);
                    UnicodeView.this.toggleButtons();
                    UnicodeView.this.setActionChecked(this);
                }
            } : new Action(charset.getName(), 2){

                public void run() {
                    int arraySize = charset.getCustomCharsetTable().customCharsetTableItem.size();
                    int arraySizeCombined = 0;
                    if (charset.getCustomCharsetTable().customCharsetTableCombinedItem != null) {
                        arraySizeCombined = charset.getCustomCharsetTable().customCharsetTableCombinedItem.size();
                    }
                    String[] charsetArrayLong = new String[arraySize + arraySizeCombined];
                    int i = 0;
                    while (i < arraySize) {
                        charsetArrayLong[i] = UnicodeModel.newString((int)charset.getCustomCharsetTable().customCharsetTableItem.get((int)i).point);
                        ++i;
                    }
                    i = 0;
                    while (i < arraySizeCombined) {
                        String content = "";
                        CustomCharsetTableCombinedItem customCharsetTableCombinedItem = charset.getCustomCharsetTable().customCharsetTableCombinedItem.get(i);
                        int j = 0;
                        while (j < customCharsetTableCombinedItem.getCustomCharsetTableItem().size()) {
                            content = String.valueOf(content) + UnicodeModel.newString((int)customCharsetTableCombinedItem.getCustomCharsetTableItem().get((int)j).point);
                            ++j;
                        }
                        charsetArrayLong[i + arraySize] = content;
                        ++i;
                    }
                    UnicodeView.this.unicodeViewer.changeViewerCharset(charsetArrayLong);
                    UnicodeView.this.unicodeViewer.setCurrentFontName(charset.getFont());
                    UnicodeView.this.setToggleState(iteratorPlusThree);
                    UnicodeView.this.toggleButtons();
                    UnicodeView.this.setActionChecked(this);
                }
            };
            charsetAction.setToolTipText(charset.getName());
            if (charset.getImageLocation() != null && charset.getImageLocation().length() > 0) {
                charsetAction.setImageDescriptor(new ImageDescriptor(){

                    public ImageData getImageData() {
                        if (charset.getName() == "Mathematical Symbols") {
                            return ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "character-sum.png")).getImageData();
                        }
                        if (charset.getName() == "Musical Symbols") {
                            return ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "character-note.png")).getImageData();
                        }
                        String imagePath = charset.getImageLocation();
                        File testFile = new File(imagePath);
                        if (testFile.exists()) {
                            return ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.validateImageLocationPath(charset.getImageLocation())).getImageData();
                        }
                        return ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "image-missing.png")).getImageData();
                    }
                });
            } else {
                charsetAction.setImageDescriptor(genericImage);
            }
            menuManager.add((IAction)charsetAction);
            if (iterator < 2 && isFirstRun) {
                this.toolBarManager.add((IAction)charsetAction);
                if (iterator == 0) {
                    this.customActionLeft = charsetAction;
                } else {
                    this.customActionRight = charsetAction;
                }
            }
            ++iterator;
        }
        menuManager.add((IContributionItem)new Separator());
        Action customCharsetEditor = new Action(Messages.UnicodeView_11){

            public void run() {
                CustomCharsetDialog customCharsetDialog = new CustomCharsetDialog(Display.getCurrent().getActiveShell(), 0);
                customCharsetDialog.setUnicodeView(UnicodeView.this.unicodeView);
                customCharsetDialog.open();
            }
        };
        this.toolBarManager.update(true);
        customCharsetEditor.setEnabled(true);
        ImageDescriptor customCharsetEditorImage = new ImageDescriptor(){

            public ImageData getImageData() {
                return ImageDescriptor.createFromURL((URL)CustomCharsetResourceReader.findResource("icons", "list-add.png")).getImageData();
            }
        };
        customCharsetEditor.setImageDescriptor(customCharsetEditorImage);
        menuManager.add((IAction)customCharsetEditor);
    }

    private void setActionChecked(Action action) {
        action.setChecked(true);
    }

    public boolean insertIntoEditor(TableItem item, int i) {
        boolean result = this.insertIntoEditor(item.getText(i));
        if (!this.list.contains(item.getText(i))) {
            if (this.list.size() < 16) {
                this.list.add(item.getText(i));
            } else {
                this.list.remove(0);
                this.list.add(item.getText(i));
            }
        }
        return result;
    }

    public boolean insertIntoEditor(String insertString) {
        boolean result = false;
        IOperationHistory operationHistory = OperationHistoryFactory.getOperationHistory();
        IEditorPart part = this.getViewSite().getPage().getActiveEditor();
        if (part == null) {
            Log.logError((String)Messages.UnicodeView_13);
        } else {
            try {
                if (part instanceof VexEditor) {
                    VexEditor editor = (VexEditor)part;
                    if (editor != null) {
                        InsertSymbolIntoVexEditorAction insertVexOperation = new InsertSymbolIntoVexEditorAction("insert", insertString, editor);
                        operationHistory.execute((IUndoableOperation)insertVexOperation, null, null);
                        result = true;
                    }
                } else {
                    ITextEditor editor = (ITextEditor)AdapterUtils.getAdapter((Object)part, ITextEditor.class);
                    if (editor != null) {
                        InsertSymbolIntoTextEditorAction insertTextOperation = new InsertSymbolIntoTextEditorAction("insert", insertString, editor);
                        operationHistory.execute((IUndoableOperation)insertTextOperation, null, null);
                        result = true;
                        editor.setFocus();
                    }
                }
            }
            catch (DocumentValidationException e) {
                Log.logError((String)e.toString());
            }
            catch (ExecutionException e) {
                StreamWriterUtils.writeLogError(4, "Execution exception", (Object)e);
            }
        }
        return result;
    }

    public void handleDispose() {
        this.getSite().getPage().hideView((IViewPart)this);
    }

    public void setFocus() {
        this.unicodeViewer.getControl().setFocus();
    }

    public int getToggleState() {
        return this.toggleState;
    }

    public void setToggleState(int newToggleState) {
        this.toggleState = newToggleState < 5 ? newToggleState : 0;
    }

    public void setCommandService(ICommandService commandService) {
        this.commandService = commandService;
    }

    public ICommandService getCommandService() {
        return this.commandService;
    }

    public class InsertSymbolIntoTextEditorAction
    extends AbstractOperation {
        private final String insertString;
        private final ITextEditor editor;

        public InsertSymbolIntoTextEditorAction(String label, String insertString, ITextEditor editor) {
            super(label);
            this.editor = editor;
            this.insertString = insertString;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            IDocumentProvider dp = this.editor.getDocumentProvider();
            IDocument doc = dp.getDocument((Object)this.editor.getEditorInput());
            ITextSelection selection = (ITextSelection)this.editor.getSelectionProvider().getSelection();
            int offset = selection.getOffset();
            try {
                doc.replace(selection.getOffset(), selection.getLength(), this.insertString);
            }
            catch (BadLocationException e) {
                StreamWriterUtils.writeLogError(2, "could not execute insertAction", (Object)e);
            }
            this.editor.getSelectionProvider().setSelection((ISelection)new TextSelection(offset + this.insertString.length(), 0));
            return null;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return null;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return null;
        }
    }

    public class InsertSymbolIntoVexEditorAction
    extends AbstractOperation {
        private final VexEditor editor;
        private final String insertString;

        public InsertSymbolIntoVexEditorAction(String label, String insertString, VexEditor editor) {
            super(label);
            this.insertString = insertString;
            this.editor = editor;
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            VexWidget widget = this.editor.getVexWidget();
            widget.insertText(this.insertString);
            return null;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return null;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            return null;
        }
    }
}

