/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.revisions.ui;

import info.textgrid.lab.core.metadataeditor.Activator;
import info.textgrid.lab.core.model.TGObjectReference;
import info.textgrid.lab.core.model.TextGridObject;
import info.textgrid.lab.core.revisions.ui.Messages;
import info.textgrid.lab.newsearch.SearchRequest;
import info.textgrid.lab.ui.core.utils.TextGridObjectTableViewer;
import java.util.EnumSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;

public class RevisionView
extends ViewPart {
    private TextGridObjectTableViewer viewer;
    private TextGridObject tgo;
    private Composite composite;
    private Label tgoLabel;
    private final ISelectionListener tgoSelectedListener = new ISelectionListener(){

        public void selectionChanged(IWorkbenchPart sourcepart, ISelection selection) {
            if (sourcepart.getSite().getId().equals("info.textgrid.lab.navigator.view") && selection instanceof IStructuredSelection) {
                IStructuredSelection iss = (IStructuredSelection)selection;
                if (!iss.isEmpty()) {
                    Object firstelem = iss.toArray()[0];
                    if (firstelem instanceof TGObjectReference) {
                        RevisionView.this.refreshViewer(((TGObjectReference)firstelem).getTgo());
                    } else {
                        RevisionView.this.refreshViewer(null);
                    }
                } else {
                    RevisionView.this.refreshViewer(null);
                }
            }
        }
    };
    private TextGridObject.ITextGridObjectListener objectListener = new TextGridObject.ITextGridObjectListener(){

        public void textGridObjectChanged(TextGridObject.ITextGridObjectListener.Event event, TextGridObject object) {
            if (event == TextGridObject.ITextGridObjectListener.Event.DELETED) {
                RevisionView.this.viewer.remove((Object)object);
            }
        }
    };

    public RevisionView() {
        TextGridObject.addListener((TextGridObject.ITextGridObjectListener)this.objectListener);
    }

    public void createPartControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        GridData gdc = new GridData(4, 4, true, true);
        this.composite.setLayoutData((Object)gdc);
        GridLayout glp = new GridLayout(1, false);
        this.composite.setLayout((Layout)glp);
        this.tgoLabel = new Label(this.composite, 16384);
        this.viewer = new TextGridObjectTableViewer(this.composite, 772);
        this.viewer.setVisibleColumns(EnumSet.of(TextGridObjectTableViewer.Column.REVISION, TextGridObjectTableViewer.Column.TITLE, TextGridObjectTableViewer.Column.PROJECT, TextGridObjectTableViewer.Column.DATE, TextGridObjectTableViewer.Column.OWNER));
        this.viewer.getTable().setHeaderVisible(true);
        GridData gd1 = new GridData(4, 4, true, true);
        this.viewer.getControl().setLayoutData((Object)gd1);
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.getSite().getPage().addSelectionListener(this.tgoSelectedListener);
        this.hookContextMenu((TableViewer)this.viewer);
    }

    public void refreshViewer(final TextGridObject tgo) {
        if (this.tgo == tgo) {
            return;
        }
        this.setTgo(tgo);
        if (tgo == null) {
            this.tgoLabel.setText("");
            this.viewer.setInput(null);
            return;
        }
        try {
            this.tgoLabel.setText(NLS.bind((String)Messages.RevisionView_RevisionsOfInProject, (Object)this.getTgo().getTitle().replaceAll("&", "&&"), (Object)this.getTgo().getProjectInstance().getName().replaceAll("&", "&&")));
        }
        catch (CoreException e) {
            Activator.handleError((Throwable)e);
        }
        this.composite.layout();
        final SearchRequest searchRequest = new SearchRequest();
        UIJob job = new UIJob(Messages.RevisionView_RetrieveRevisions){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                    progress.beginTask(NLS.bind((String)Messages.RevisionView_QueryForChildren, (Object)tgo.getTitle()), 100);
                    searchRequest.setQueryRevision(RevisionView.this.getTgo().getURI().toString());
                    RevisionView.this.viewer.setInput((Object)searchRequest);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    Activator.handleError((Throwable)e);
                    return Status.CANCEL_STATUS;
                }
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private void hookContextMenu(TableViewer viewer) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public TextGridObject getTgo() {
        return this.tgo;
    }

    public void setTgo(TextGridObject tgo) {
        this.tgo = tgo;
    }

    public void dispose() {
        if (this.tgoSelectedListener != null) {
            this.getSite().getPage().removeSelectionListener(this.tgoSelectedListener);
        }
        if (this.objectListener != null) {
            TextGridObject.removeListener((TextGridObject.ITextGridObjectListener)this.objectListener);
        }
        super.dispose();
    }
}

