/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.authn;

import info.textgrid.lab.authn.Activator;
import info.textgrid.lab.authn.AuthBrowser;
import info.textgrid.lab.authn.Messages;
import info.textgrid.lab.authn.RBACSession;
import info.textgrid.lab.conf.OfflineException;
import info.textgrid.lab.conf.OnlineStatus;
import info.textgrid.lab.conf.client.ConfClient;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.statushandlers.StatusManager;

public class AuthNDialog
extends TrayDialog {
    private static final int RESTART_LOGIN = 123;
    private static final int RESET_PASSWORD = 127;
    AuthBrowser browserComp;
    AuthNDialog thisDialog;
    Button neverAsk;
    AuthBrowser.ISIDChangedListener sidChangedListener;

    protected AuthNDialog(IShellProvider parentShell) {
        super(parentShell);
        this.initialize();
    }

    public AuthNDialog(Shell parentShell) {
        super(parentShell);
        this.initialize();
    }

    protected void initialize() {
        this.thisDialog = this;
        this.setHelpAvailable(false);
        this.setShellStyle(67696);
        this.sidChangedListener = new AuthBrowser.ISIDChangedListener(){

            @Override
            public void sidChanged(String newSID, String newEPPN) {
                if (!RBACSession.getInstance().getSID(false).equals("")) {
                    new UIJob(Messages.AuthNDialog_ClosingDialog){

                        public IStatus runInUIThread(IProgressMonitor m) {
                            (this).AuthNDialog.this.thisDialog.destroy();
                            return Status.OK_STATUS;
                        }
                    }.schedule();
                }
            }
        };
        AuthBrowser.addSIDChangedListener(this.sidChangedListener);
    }

    @Deprecated
    protected void destroy() {
        this.close();
    }

    public boolean close() {
        AuthBrowser.removeSIDChangedListener(this.sidChangedListener);
        boolean result = super.close();
        RBACSession.authDialogIsOpen(false);
        return result;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        ++((GridLayout)parent.getLayout()).numColumns;
        if (Activator.getDefault().getPreferenceStore().getBoolean(Activator.ALLOW_SAVE_SID)) {
            final Button rememberMe = new Button(parent, 32);
            rememberMe.setText(Messages.AuthNDialog_StayLoggedIn);
            rememberMe.setToolTipText(Messages.AuthNDialog_StayLoggedInTooltip);
            rememberMe.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (AuthNDialog.this.browserComp != null && !AuthNDialog.this.browserComp.isDisposed()) {
                        AuthNDialog.this.browserComp.setSaveSID(rememberMe.getSelection());
                    }
                }
            });
        }
        this.createButton(parent, 123, Messages.AuthNDialog_BackBtn, false);
        this.createButton(parent, 12, IDialogConstants.CLOSE_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
        if (buttonId == 12) {
            this.close();
        }
        if (buttonId == 123) {
            Browser.clearSessions();
            this.browserComp.gotoStartPage(false);
        }
        if (buttonId == 127) {
            URL pwrurl = null;
            try {
                ConfClient confClient = ConfClient.getInstance();
                String pwrurlString = confClient.getValue("PasswordReset");
                pwrurl = URI.create(pwrurlString).toURL();
                PlatformUI.getWorkbench().getBrowserSupport().createBrowser(128, "info.textgrid.lab.authn.external_browser", "TGauth* Browser", "").openURL(pwrurl);
                MessageBox mb = new MessageBox(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), 34);
                mb.setText(Messages.AuthNDialog_ResettingPassword);
                mb.setMessage(Messages.AuthNDialog_ResetMessage);
                mb.open();
            }
            catch (OfflineException e) {
                OnlineStatus.netAccessFailed((String)Messages.AuthNDialog_CouldNotContactConfserv, (Throwable)e);
            }
            catch (MalformedURLException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, "info.textgrid.lab.authn", e.getLocalizedMessage(), (Throwable)e));
            }
            catch (PartInitException e) {
                StatusManager.getManager().handle((CoreException)e, "info.textgrid.lab.authn");
            }
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.browserComp = new AuthBrowser(parent);
        this.getShell().setText(Messages.AuthNDialog_WayfMessage);
        return this.browserComp;
    }
}

