/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.core.importexport.legacy;

import info.textgrid.lab.core.importexport.legacy.LegacyImportPlugin;
import info.textgrid.lab.core.importexport.legacy.LegacyRewritingSupplier;
import info.textgrid.lab.core.importexport.model.IImportEntryConfigurator;
import info.textgrid.lab.core.importexport.model.ISpecialImportEntrySupplier;
import info.textgrid.lab.core.importexport.model.ImportEntry;
import info.textgrid.lab.core.model.TGContentType;
import info.textgrid.namespaces.metadata.core._2010.ObjectType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXB;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.osgi.framework.Bundle;

public class LegacyImportEntryConfigurator
implements IImportEntryConfigurator {
    public void configureImport(ImportEntry entry, IProgressMonitor monitor) {
        File oldMetadata = new File(entry.getLocalFile().getParent(), "." + entry.getLocalFile().getName() + ".meta");
        if (oldMetadata.exists() && !entry.getLocalMetadataFile().exists()) {
            try {
                ObjectType converted = this.convertOldMetadataFile(oldMetadata);
                entry.getObject().setMetadata(converted);
                entry.getObject().setContentType(TGContentType.of((String)converted.getGeneric().getProvided().getFormat()));
                entry.setSupplier((ISpecialImportEntrySupplier)new LegacyRewritingSupplier(entry));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (TransformerException e) {
                e.printStackTrace();
            }
        }
    }

    private ObjectType convertOldMetadataFile(File oldMetadata) throws IOException, TransformerException {
        StreamSource mdSource = new StreamSource(oldMetadata);
        try {
            InputStream xslStream = FileLocator.openStream((Bundle)LegacyImportPlugin.getDefault().getBundle(), (IPath)new Path("resources").append("old2new-metadata.xsl"), (boolean)false);
            StreamSource xslSource = new StreamSource(xslStream);
            Transformer transformer = TransformerFactory.newInstance().newTransformer(xslSource);
            ByteArrayOutputStream resultStream = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(resultStream);
            transformer.transform(mdSource, result);
            resultStream.close();
            ByteArrayInputStream convertedStream = new ByteArrayInputStream(resultStream.toByteArray());
            ObjectType metadata = (ObjectType)JAXB.unmarshal((InputStream)convertedStream, ObjectType.class);
            return metadata;
        }
        catch (TransformerConfigurationException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new IllegalStateException(e);
        }
    }
}

