/*
 * Decompiled with CFR 0.152.
 */
package info.textgrid.lab.search;

import info.textgrid.lab.search.ContextEntry;
import info.textgrid.lab.search.SingleSearchResult;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;

public class KWICEntry
extends PlatformObject
implements IDeferredWorkbenchAdapter {
    private String path = null;
    private String pathLabel = null;
    private ContextEntry[] allChildren = null;
    private SingleSearchResult parent = null;

    public KWICEntry(OMElement ome, String namespace) {
        OMElement location = ome.getFirstChildWithName(new QName(namespace, "location"));
        boolean firstPass = true;
        Iterator locationIterator = location.getChildrenWithLocalName("locitem");
        while (locationIterator.hasNext()) {
            OMElement itemLocation = (OMElement)locationIterator.next();
            this.pathLabel = firstPass ? itemLocation.getText() : String.valueOf(this.pathLabel) + " > " + itemLocation.getText();
            firstPass = false;
        }
        this.path = location.getFirstChildWithName(new QName(namespace, "locitem")).getAttributeValue(new QName("path"));
        ArrayList<ContextEntry> cArray = new ArrayList<ContextEntry>();
        Iterator citer = ome.getChildrenWithName(new QName(namespace, "context"));
        while (citer.hasNext()) {
            OMElement nextContext = (OMElement)citer.next();
            ContextEntry ce = new ContextEntry(nextContext);
            ce.setParent(this);
            cArray.add(ce);
        }
        this.allChildren = cArray.toArray(new ContextEntry[0]);
    }

    public String getPath() {
        return this.path;
    }

    public String getPathLabel() {
        return this.pathLabel;
    }

    public ContextEntry[] getChildren() {
        return this.allChildren;
    }

    public void setParent(SingleSearchResult parent) {
        this.parent = parent;
    }

    public SingleSearchResult getParent() {
        return this.parent;
    }

    public String toString() {
        return String.valueOf(this.allChildren.length) + " " + this.path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
        monitor.beginTask("Retrieving children of " + this.toString(), -1);
        KWICEntry kWICEntry = this;
        synchronized (kWICEntry) {
            if (object instanceof KWICEntry) {
                ContextEntry[] contextEntryArray = this.allChildren;
                int n = this.allChildren.length;
                int n2 = 0;
                while (n2 < n) {
                    ContextEntry ce = contextEntryArray[n2];
                    collector.add((Object)ce, monitor);
                    ++n2;
                }
            } else {
                throw new IllegalArgumentException(MessageFormat.format("KWICEntry''s fetchDeferredChildren does not know the children of {0}s like {1}", object.getClass(), object));
            }
            collector.done();
            monitor.done();
        }
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    public boolean isContainer() {
        return true;
    }

    public Object[] getChildren(Object o) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return null;
    }

    public String getLabel(Object o) {
        return null;
    }

    public Object getParent(Object o) {
        return null;
    }
}

