/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.equinox.internal.ds.Activator;
import org.eclipse.equinox.internal.util.string.CharBuffer;
import org.eclipse.equinox.internal.util.xml.TagClass;
import org.eclipse.equinox.internal.util.xml.TagListener;

public class XMLReader {
    private static final String DEBUG = "equinox.ds.xml.debug";
    private static final String SET_OLD_BEHAVIOUR = "equinox.ds.xml.oldbehaviour";
    private static final String SET_OLD_LEVELS = "equinox.ds.xml.oldlevels";
    private static final String INTERN_ATTRIBUTES = "equinox.ds.xml.intern.attributes";
    private static final String CDATA = "CDATA";
    private static final String XML = "xml";
    private static final String VERSION = "version";
    private static final String ENCODING = "encoding";
    private static final String STANDALONE = "standalone";
    private static final String ERR_EOS = "End-of-stream reached before the end of XML.";
    private static final String ERR_ENTITY_EXPECTED = "Entity reference or Character reference expected.";
    private static final String ERR_EQUAL_EXPECTED = "'=' expected.";
    private static final String ERR_QUOT_EXPECTED = "''' or '\"' expected.";
    private static final String ERR_GT_EXPECTED = "'>' expected.";
    private static final String ERR_LT_EXPECTED = "'<' expected.";
    private static final String ERR_CLOSE_TAG1_EXPECTED = "'/' or tag name expected.";
    private static final String ERR_CLOSE_TAG2_EXPECTED = "'>', '/>' or more attributes expected.";
    private static final String ERR_CLOSE_TAG3_EXPECTED = "'?>' expected.";
    private static final String ERR_CONTENT_EXPECTED = "Content data, new tag or closing tag expected.";
    private static final String ERR_QUESTIONMARK_EXPECTED = "'?' expected.";
    private static final String ERR_ILLEGAL_CHARACTER = "Illegal character.";
    private static final String ERR_TAGNAME_EXPECTED = "Tag name expected.";
    private static final String ERR_TAGNAME2_EXPECTED = "Tag name, '?' or '!' expected.";
    private static final String ERR_DASH_EXPECTED = "'-' expected.";
    private static final String ERR_COMMENT_CLOSE_EXPECTED = "'-->' expected.";
    private static final String ERR_CDATA_EXPECTED = "'CDATA' expected.";
    private static final String ERR_OPENSQBRACKET_EXPECTED = "'[' expected.";
    private static final String ERR_CLOSE_CDATA_EXPECTED = "']]>' expected.";
    private static final String ERR_SEMICOLON_EXPECTED = "';' expected.";
    private static final String ERR_XMLPROLOG_EXPECTED = "XML prolog '<?xml' is not expected at this position.";
    private static final String ERR_VERSION_EXPECTED = "'version' attribute expected.";
    private static final String ERR_ENCODING_STANDALONE_EXPECTED = "'encoding', 'standalone' or '?>' expected.";
    private static final String ERR_STANDALONE_EXPECTED = "'standalone' attribute expected.";
    private static final boolean fDebug = Activator.getBoolean("equinox.ds.xml.debug");
    private static final boolean fOldBehaviour = Activator.getBoolean("equinox.ds.xml.oldbehaviour");
    private static final boolean fOldLevels = Activator.getBoolean("equinox.ds.xml.oldlevels");
    private static final boolean fInternAttributes = Activator.getBoolean("equinox.ds.xml.intern.attributes");
    private String fDefaultEncoding = "UTF-8";
    private CharBuffer temp = new CharBuffer();
    private CharBuffer temp2 = null;
    protected Reader fReader = null;
    protected InputStream fStream = null;
    protected char currentChar = '\u0000';
    protected TagListener fTagListener;
    protected int fLine = 1;
    protected int fPos = 0;
    protected int fLevel = -1;
    protected int fCurrentLevel = 1;
    private String fVersion = "1.0";
    private String fEncoding = "UTF-8";
    private String fStandalone = "no";
    protected static final String[] fNew_entities = new String[]{"amp", "apos", "lt", "gt", "quot"};
    protected static final char[] fNew_ent_chars = new char[]{'&', '\'', '<', '>', '\"'};
    protected static final String[] fOld_entities = new String[]{"amp", "nbsp", "crlf", "tab", "lt", "gt", "quot", "apos"};
    protected static final char[] fOld_ent_chars = new char[]{'&', ' ', '\n', '\t', '<', '>', '\"', '\''};
    protected char prev_char = '\u0000';
    protected char[] fBuffer = new char[4096];
    protected int fBufferLen = 0;
    protected int fBufferPos = 0;
    private static final char bA = '@';
    private static final char aZ = '[';
    private static final char ba = '`';
    private static final char az = '{';
    private static final char b0 = '/';
    private static final char a9 = ':';
    private static final String[] fEntities = fOldBehaviour ? fOld_entities : fNew_entities;
    private static final char[] fEnt_chars = fOldBehaviour ? fOld_ent_chars : fNew_ent_chars;

    public XMLReader() {
    }

    public XMLReader(InputStream aInputStream, TagListener aListener) {
        this.fStream = aInputStream;
        this.fTagListener = aListener;
    }

    public XMLReader(Reader aReader, TagListener aListener) {
        this.fReader = aReader;
        this.fTagListener = aListener;
    }

    public static void read(InputStream aInputStream, TagListener aListener) throws IOException {
        XMLReader.parseXML(aInputStream, aListener, -1);
    }

    public static void read(InputStream aInputStream, TagListener aListener, int aLevel) throws IOException {
        XMLReader.parseXML(aInputStream, aListener, aLevel);
    }

    public static void read(Reader aReader, TagListener aListener) throws IOException {
        XMLReader.parseXML(aReader, aListener, -1);
    }

    public static void read(Reader aReader, TagListener aListener, int aLevel) throws IOException {
        XMLReader.parseXML(aReader, aListener, aLevel);
    }

    protected void setEncoding(String aEncoding) {
        if (this.fReader == null) {
            try {
                this.fReader = new InputStreamReader(this.fStream, aEncoding);
            }
            catch (Exception exception) {
                if (fDebug) {
                    System.err.println("[XMLReader] Failed setting the encoding \"" + aEncoding + "\", continue parsing with the default one.");
                }
                this.fReader = new InputStreamReader(this.fStream);
            }
        }
    }

    protected void setLevel(int aLevel) {
        this.fLevel = aLevel;
    }

    protected CharBuffer getCharBuffer() {
        if (this.temp.length() <= 0) {
            return this.temp;
        }
        if (this.temp2 == null) {
            this.temp2 = new CharBuffer(0);
            return this.temp2;
        }
        if (this.temp2.length() <= 0) {
            return this.temp2;
        }
        return new CharBuffer(0);
    }

    protected boolean getNextChar() throws IOException {
        char ch;
        if (this.fReader == null) {
            int ach = this.fStream.read();
            if (ach < 0) {
                ach = 0;
            }
            if ((ch = (char)ach) == '\u0000' && this.prev_char == '\u0000') {
                throw new IOException(ERR_EOS);
            }
        } else {
            if (this.fBufferLen < 0) {
                throw new IOException(ERR_EOS);
            }
            if (this.fBufferPos >= this.fBufferLen) {
                this.fBufferLen = 0;
                this.fBufferPos = 0;
                int count = 0;
                while (this.fBufferLen == 0 && count < 100) {
                    this.fBufferLen = this.fReader.read(this.fBuffer);
                    ++count;
                }
                char c = ch = this.fBufferLen > 0 ? this.fBuffer[this.fBufferPos++] : (char)'\u0000';
                if (this.fBufferLen == 0) {
                    this.fBufferLen = -1;
                }
            } else {
                ch = this.fBuffer[this.fBufferPos++];
            }
        }
        this.prev_char = this.currentChar;
        this.currentChar = ch;
        ++this.fPos;
        switch (ch) {
            case '\n': {
                if (this.prev_char != '\r') {
                    ++this.fLine;
                }
                this.fPos = 0;
                break;
            }
            case '\r': {
                this.fPos = 0;
                ++this.fLine;
            }
        }
        return this.currentChar != '\u0000';
    }

    protected void parse_attr_value(CharBuffer sb, char quot) throws IOException {
        while (this.currentChar != quot && this.currentChar != '<') {
            if (this.accept_char('&')) {
                if (this.parse_CharRef(sb) || this.parse_EntityRef(sb, true)) continue;
                this.err(this.fPos - 1, ERR_ENTITY_EXPECTED);
                continue;
            }
            sb.append(this.currentChar);
            if (!this.getNextChar()) break;
        }
    }

    protected boolean parse_attr(CharBuffer cb) throws IOException {
        this.clearWhiteSpaces();
        cb.append(' ');
        int length = this.parse_identifier(cb);
        if (length > 0) {
            this.clearWhiteSpaces();
            if (!this.accept_char('=')) {
                this.err(ERR_EQUAL_EXPECTED);
            }
            cb.append('=');
            this.clearWhiteSpaces();
            char quot = '\u0000';
            if (this.accept_char('\"')) {
                quot = '\"';
            } else if (this.accept_char('\'')) {
                quot = '\'';
            } else {
                this.err(ERR_QUOT_EXPECTED);
            }
            cb.append(quot);
            this.parse_attr_value(cb, quot);
            if (!this.accept_char(quot)) {
                this.err("'" + quot + "' expected.");
            }
            cb.append(quot);
            return true;
        }
        return false;
    }

    protected boolean parse_attr_list(TagClass aParent) throws IOException {
        boolean result = false;
        CharBuffer cb = this.getCharBuffer();
        cb.append(aParent.getName());
        while (this.parse_attr(cb)) {
            result = true;
        }
        aParent.fAttributes = fInternAttributes ? cb.toString().intern() : cb.toString();
        cb.setLength(0);
        return result;
    }

    public static final boolean isNameStartChar(char ch) {
        return ch > '@' && ch < '[' || ch > '`' && ch < '{' || ch == ':' || ch == '_' || ch > '\u00bf' && ch < '\u00d7' || ch > '\u00d7' && ch < '\u00f7' || ch > '\u00f7' && ch < '\u0300' || ch > '\u036f' && ch < '\u037e' || ch > '\u037e' && ch < '\u2000' || ch > '\u200b' && ch < '\u200e' || ch > '\u206f' && ch < '\u2190' || ch > '\u2bff' && ch < '\u2ff0' || ch > '\u3000' && ch < '\ud800' || ch > '\uf900' && ch < '\ufdd0' || ch > '\ufdef' && ch < '\ufffe' || ch > '\uffff' && ch < '\uf0000';
    }

    public static final boolean isNameChar(char ch) {
        return ch == '-' || ch == '.' || ch == '\u00b7' || ch > '/' && ch < ':' || XMLReader.isNameStartChar(ch) || ch > '\u02ff' && ch < '\u0370' || ch > '\u203e' && ch < '\u2041';
    }

    protected String parse_identifier() throws IOException {
        if (XMLReader.isNameStartChar(this.currentChar)) {
            CharBuffer sb = this.getCharBuffer();
            while (XMLReader.isNameChar(this.currentChar)) {
                sb.append(this.currentChar);
                if (!this.getNextChar()) break;
            }
            String result = sb.toString().intern();
            sb.setLength(0);
            return result;
        }
        return null;
    }

    protected int parse_identifier(CharBuffer cb) throws IOException {
        if (XMLReader.isNameStartChar(this.currentChar)) {
            int length = 0;
            while (XMLReader.isNameChar(this.currentChar)) {
                cb.append(this.currentChar);
                ++length;
                if (!this.getNextChar()) break;
            }
            return length;
        }
        return 0;
    }

    protected boolean parse_tag_name(TagClass aParent) throws IOException {
        String name = this.parse_identifier();
        if (name != null) {
            aParent.setName(name);
        }
        return name != null;
    }

    protected void notifyListeners(TagClass aTag) {
        try {
            if (this.fLevel <= 0 || this.fLevel == this.fCurrentLevel) {
                this.fTagListener.useTag(aTag);
            }
        }
        catch (RuntimeException re) {
            if (fDebug) {
                System.err.println("An outside exception occurred while processing a tag on line " + aTag.getLine() + ", the tag name is: " + aTag.getName() + ", the level is: " + this.fCurrentLevel);
                re.printStackTrace(System.err);
            }
            throw re;
        }
    }

    protected boolean parse_tag_normal(TagClass aParent) throws IOException {
        if (XMLReader.isNameStartChar(this.currentChar)) {
            TagClass tag = new TagClass();
            tag.setLine(this.fLine);
            this.parse_tag_name(tag);
            this.parse_attr_list(tag);
            this.clearWhiteSpaces();
            if (this.accept_char('/')) {
                if (!this.accept_char('>')) {
                    this.err(ERR_GT_EXPECTED);
                }
                tag.setInline();
                aParent.addTag(tag);
                if (!fOldBehaviour) {
                    this.notifyListeners(tag);
                }
                return true;
            }
            if (this.accept_char('>')) {
                while (true) {
                    this.clearWhiteSpaces();
                    int pos = this.fPos;
                    if (this.currentChar == '<') {
                        if (this.parse_tag(tag)) continue;
                        if (!this.accept_char('/')) {
                            this.err(pos + 1, ERR_CLOSE_TAG1_EXPECTED);
                        }
                        pos = this.fPos;
                        if (!this.accept_seq(tag.getName())) {
                            this.err(pos, String.valueOf('\'') + tag.getName() + "' string expected.");
                        }
                        this.clearWhiteSpaces();
                        if (!this.accept_char('>')) {
                            this.err(ERR_GT_EXPECTED);
                        }
                        aParent.addTag(tag);
                        this.notifyListeners(tag);
                        return true;
                    }
                    if (!this.parse_PCDATA(tag)) break;
                }
                this.err(ERR_CONTENT_EXPECTED);
            } else {
                this.err(ERR_CLOSE_TAG2_EXPECTED);
            }
        }
        return false;
    }

    protected boolean parse_tag_special(TagClass aParent) throws IOException {
        if (this.accept_char('!')) {
            TagClass tag = new TagClass();
            if (this.parse_tag_name(tag)) {
                this.clearWhiteSpaces();
                while (true) {
                    if (this.accept_char('>')) {
                        this.clearWhiteSpaces();
                        return true;
                    }
                    this.getNextChar();
                }
            }
            if (this.parse_tag_CDATA(aParent)) {
                return true;
            }
            if (this.parse_comment(tag)) {
                return true;
            }
        } else if (this.accept_char('?')) {
            TagClass tag = new TagClass();
            int pos = this.fPos;
            if (this.parse_tag_name(tag)) {
                if (tag.getName().equals(XML)) {
                    this.err(pos - 2, ERR_XMLPROLOG_EXPECTED);
                }
                int prevCh = 0;
                while (true) {
                    if (this.currentChar == '>' && prevCh == 63) {
                        this.accept_char('>');
                        this.clearWhiteSpaces();
                        return true;
                    }
                    prevCh = this.currentChar;
                    this.getNextChar();
                }
            }
            this.err(pos, ERR_TAGNAME_EXPECTED);
        }
        return false;
    }

    protected String getAttrValue() throws IOException {
        CharBuffer cb = this.getCharBuffer();
        this.clearWhiteSpaces();
        this.accept_char('=');
        this.clearWhiteSpaces();
        if (this.currentChar != '\'' && this.currentChar != '\"') {
            this.err(ERR_QUOT_EXPECTED);
        }
        char quot = this.currentChar;
        this.accept_char(quot);
        this.parse_attr_value(cb, quot);
        if (!this.accept_char(quot)) {
            this.err("'" + quot + "' expected.");
        }
        String result = cb.toString();
        cb.setLength(0);
        this.clearWhiteSpaces();
        return result;
    }

    protected boolean parse_xml_prolog(TagClass parent) throws IOException {
        TagClass tag;
        if (this.accept_char('?') && this.parse_tag_name(tag = new TagClass())) {
            if (tag.getName().equalsIgnoreCase(XML)) {
                if (fOldLevels) {
                    ++this.fCurrentLevel;
                }
                this.clearWhiteSpaces();
                int pos = this.fPos;
                String s = this.parse_identifier();
                boolean bEncoding = false;
                boolean bStandalone = false;
                if (VERSION.equals(s)) {
                    this.fVersion = this.getAttrValue();
                    s = this.parse_identifier();
                } else {
                    this.err(pos, ERR_VERSION_EXPECTED);
                }
                if (ENCODING.equals(s)) {
                    this.fEncoding = this.getAttrValue().toUpperCase();
                    s = this.parse_identifier();
                    bEncoding = true;
                }
                if (STANDALONE.equals(s)) {
                    this.fStandalone = this.getAttrValue();
                    s = this.parse_identifier();
                    bStandalone = true;
                }
                if (s != null) {
                    if (bEncoding && bStandalone) {
                        this.err(ERR_CLOSE_TAG3_EXPECTED);
                    }
                    if (!bEncoding && !bStandalone) {
                        this.err(ERR_ENCODING_STANDALONE_EXPECTED);
                    }
                    if (bEncoding) {
                        this.err(ERR_STANDALONE_EXPECTED);
                    }
                    this.err(ERR_CLOSE_TAG3_EXPECTED);
                }
                this.clearWhiteSpaces();
                pos = this.fPos;
                if (!this.accept_seq("?>")) {
                    this.err(pos, ERR_CLOSE_TAG3_EXPECTED);
                }
                return true;
            }
            int prevCh = 0;
            while (true) {
                if (this.currentChar == '>') {
                    if (prevCh == 63) {
                        this.accept_char('>');
                        this.clearWhiteSpaces();
                        return true;
                    }
                    this.err(ERR_QUESTIONMARK_EXPECTED);
                } else if (this.currentChar == '<') {
                    this.err("Illegal character. ('<')");
                }
                prevCh = this.currentChar;
                this.getNextChar();
            }
        }
        return false;
    }

    protected boolean parse_comment(TagClass aParent) throws IOException {
        if (this.accept_char('-')) {
            if (!this.accept_char('-')) {
                this.err(ERR_DASH_EXPECTED);
            }
            while (true) {
                if (this.accept_char('-') && this.accept_char('-')) {
                    if (this.accept_char('>')) break;
                    this.err(ERR_GT_EXPECTED);
                }
                if (this.getNextChar()) continue;
                this.err(ERR_COMMENT_CLOSE_EXPECTED);
            }
            return true;
        }
        return false;
    }

    protected boolean parse_tag(TagClass aParent) throws IOException {
        this.clearWhiteSpaces();
        try {
            ++this.fCurrentLevel;
            return this.accept_char('<') && (this.parse_tag_normal(aParent) || this.parse_tag_special(aParent));
            {
            }
        }
        finally {
            --this.fCurrentLevel;
        }
    }

    protected boolean parse_content(TagClass aParent) throws IOException {
        return this.parse_PCDATA(aParent) || this.parse_tag(aParent);
    }

    protected boolean parse_tag_CDATA(TagClass aParent) throws IOException {
        if (this.accept_char('[')) {
            int pos = this.fPos;
            if (!this.accept_seq(CDATA)) {
                this.err(pos, ERR_CDATA_EXPECTED);
            }
            if (!this.accept_char('[')) {
                this.err(ERR_OPENSQBRACKET_EXPECTED);
            }
            do {
                if (this.currentChar != '>') {
                    aParent.getContentBuffer().append(this.currentChar);
                    continue;
                }
                CharBuffer sb = aParent.getContentBuffer();
                int l = sb.length();
                if (l >= 2 && sb.charAt(l - 1) == ']' && sb.charAt(l - 2) == ']') {
                    sb.setLength(l - 2);
                    this.getNextChar();
                    return true;
                }
                sb.append(this.currentChar);
            } while (this.getNextChar());
            this.err(this.fPos - 1, ERR_CLOSE_CDATA_EXPECTED);
        }
        return false;
    }

    protected boolean parse_PCDATA(TagClass aParent) throws IOException {
        boolean result = false;
        while (this.currentChar != '<') {
            result = true;
            CharBuffer sbContent = aParent.getContentBuffer();
            if (this.accept_char('&')) {
                int pos = this.fPos;
                if (this.parse_CharRef(sbContent) || this.parse_EntityRef(sbContent, false)) continue;
                this.err(pos - 1, ERR_ENTITY_EXPECTED);
                continue;
            }
            sbContent.append(this.currentChar);
            if (!this.getNextChar()) break;
        }
        return result;
    }

    protected boolean accept_char(char ch) throws IOException {
        if (this.currentChar == ch) {
            this.getNextChar();
            return true;
        }
        return false;
    }

    protected boolean accept_seq(String seq) throws IOException {
        int i = 0;
        while (i < seq.length()) {
            if (!this.accept_char(seq.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean parse_EntityRef(CharBuffer sb, boolean inAttribute) throws IOException {
        String ent = this.parse_identifier();
        if (!this.accept_char(';')) {
            this.err(ERR_SEMICOLON_EXPECTED);
        }
        if (!inAttribute) {
            int length = fEntities.length;
            int i = 0;
            while (i < length) {
                if (fEntities[i] == ent) {
                    sb.append(fEnt_chars[i]);
                    return true;
                }
                ++i;
            }
        }
        sb.append('&');
        if (ent != null) {
            sb.append(ent);
        }
        sb.append(';');
        return true;
    }

    protected boolean parse_CharRef(CharBuffer sb) throws IOException {
        if (this.accept_char('#')) {
            while (this.currentChar != ';') {
                this.getNextChar();
            }
            if (!this.accept_char(';')) {
                this.err(this.fPos - 1, ERR_SEMICOLON_EXPECTED);
            }
            return true;
        }
        return false;
    }

    protected void clearWhiteSpaces() throws IOException {
        while (Character.isWhitespace(this.currentChar)) {
            if (!this.getNextChar()) break;
        }
    }

    protected void err(String message) throws IOException {
        this.err(this.fPos, message);
    }

    protected void err(int pos, String message) throws IOException {
        throw new IOException("[Line: " + this.fLine + ", Pos: " + pos + "]  " + message);
    }

    protected void parseXML() throws IOException {
        TagClass rootTag = new TagClass();
        try {
            this.getNextChar();
            this.clearWhiteSpaces();
            boolean start = false;
            while (this.accept_char('<')) {
                start = true;
                int pos = this.fPos;
                if (this.fPos == 2 && this.fLine == 1) {
                    if (this.parse_xml_prolog(rootTag)) {
                        this.setEncoding(this.fEncoding);
                        this.clearWhiteSpaces();
                        continue;
                    }
                } else {
                    this.setEncoding(this.fDefaultEncoding);
                }
                if (!this.parse_tag_special(rootTag)) {
                    if (this.parse_tag_normal(rootTag)) {
                        return;
                    }
                    this.err(pos, ERR_TAGNAME2_EXPECTED);
                }
                this.clearWhiteSpaces();
            }
            if (!start) {
                this.err(ERR_LT_EXPECTED);
            }
        }
        catch (IOException ioe) {
            if (fDebug) {
                ioe.printStackTrace(System.err);
            }
            throw ioe;
        }
    }

    public static void parseXML(InputStream aInputStream, TagListener aListener, int aLevel) throws IOException {
        XMLReader xml = new XMLReader(aInputStream, aListener);
        xml.setLevel(aLevel);
        xml.parseXML();
    }

    public static void parseXML(Reader aReader, TagListener aListener, int aLevel) throws IOException {
        XMLReader xml = new XMLReader(aReader, aListener);
        xml.setLevel(aLevel);
        xml.parseXML();
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getEncoding() {
        return this.fEncoding;
    }

    public String getStandalone() {
        return this.fStandalone;
    }
}

